      subroutine xc_lebedev(l_ang, oprint)
      implicit none
c
C$Id$
c
#include "cdft.fh"
#include "stdio.fh"
#include "global.fh"
#include "tcgmsg.fh"
c
c     Routine for Lebedev weights, supplied by Mauro Causa`
c     modified by E. Apra based on the following paper
c     B.Delley, J. Comp. Chem. 17, 1152 (1996) 
c     All points were provided by DN Laikov and VI lebedev
c     3/7/200
c     n = 131 from VI Lebedev and DN Laikov, 
c      Doklady Mathematics 366, 741 (1999)
c
c     integer iacc  ! [input]
c
      integer MAXN, i
      parameter(MAXN = 1281)
      logical oprint
      double precision gjk(2,MAXN), wleb(MAXN), fasf(6), goh(3,3,48)
      integer njk(6,IAC_MAX), ivj(48,6), nvj(6),
     &        jkv(IAC_MAX+1),  itop(3,3,6), isig(3,8)
cedo      double precision nridv(IAC_MAX)
      double precision fourpi
C      parameter(fourpi = 4.d0*3.1415926535897932385d0)
c
      integer nop, n48, iv, k, ks, isi, j, ia, l_ang, iaz, jk, jk1, 
     &        nvjj, l
      double precision wtest, fasfj, x0, y0, z0, gjkt1, gjkt2, gjkt3
c
      data itop/1, 0, 0, 0, 1, 0, 0, 0, 1,  1, 0, 0, 0, 0, 1, 0, 1, 0,
     &          0, 1, 0, 1, 0, 0, 0, 0, 1,  0, 0, 1, 0, 1, 0, 1, 0, 0,
     &          0, 1, 0, 0, 0, 1, 1, 0, 0,  0, 0, 1, 1, 0, 0, 0, 1, 0/
c
      data isig/ 1,  1,  1, -1,  1,  1,  1, -1,  1,  1,  1, -1,
     &          -1, -1, -1,  1, -1, -1, -1,  1, -1, -1, -1,  1/
C
C   n =   9
C
      data wleb(   1),(gjk(i,   1),i=1,2)/
     &  9.523809523809525D-03,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(   2),(gjk(i,   2),i=1,2)/
     &  3.214285714285714D-02,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(   3),(gjk(i,   3),i=1,2)/
     &  2.857142857142857D-02,
     &  4.597008433809831D-01, 0.000000000000000D+00/
C
C   n =  11
C
      data wleb(   4),(gjk(i,   4),i=1,2)/
     &  1.269841269841270D-02,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(   5),(gjk(i,   5),i=1,2)/
     &  2.257495590828924D-02,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(   6),(gjk(i,   6),i=1,2)/
     &  2.109375000000000D-02,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(   7),(gjk(i,   7),i=1,2)/
     &  2.017333553791887D-02,
     &  3.015113445777636D-01, 3.015113445777636D-01/
C
C   n =  13
C
      data wleb(   8),(gjk(i,   8),i=1,2)/
     &  5.130671797338464D-04,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(   9),(gjk(i,   9),i=1,2)/
     &  1.660406956574204D-02,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  10),(gjk(i,  10),i=1,2)/
     & -2.958603896103896D-02,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  11),(gjk(i,  11),i=1,2)/
     &  2.657620708215946D-02,
     &  4.803844614152614D-01, 4.803844614152614D-01/
      data wleb(  12),(gjk(i,  12),i=1,2)/
     &  1.652217099371571D-02,
     &  3.207726489807764D-01, 0.000000000000000D+00/
C
C   n =  15
C
      data wleb(  13),(gjk(i,  13),i=1,2)/
     &  1.154401154401154D-02,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(  14),(gjk(i,  14),i=1,2)/
     &  1.194390908585628D-02,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  15),(gjk(i,  15),i=1,2)/
     &  1.111055571060340D-02,
     &  3.696028464541502D-01, 3.696028464541502D-01/
      data wleb(  16),(gjk(i,  16),i=1,2)/
     &  1.187650129453714D-02,
     &  6.943540066026664D-01, 6.943540066026664D-01/
      data wleb(  17),(gjk(i,  17),i=1,2)/
     &  1.181230374690448D-02,
     &  3.742430390903412D-01, 0.000000000000000D+00/
C
C   n =  17
C
      data wleb(  18),(gjk(i,  18),i=1,2)/
     &  3.828270494937162D-03,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(  19),(gjk(i,  19),i=1,2)/
     &  9.793737512487513D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  20),(gjk(i,  20),i=1,2)/
     &  8.211737283191111D-03,
     &  1.851156353447362D-01, 1.851156353447362D-01/
      data wleb(  21),(gjk(i,  21),i=1,2)/
     &  9.942814891178103D-03,
     &  6.904210483822922D-01, 6.904210483822922D-01/
      data wleb(  22),(gjk(i,  22),i=1,2)/
     &  9.595471336070962D-03,
     &  3.956894730559419D-01, 3.956894730559419D-01/
      data wleb(  23),(gjk(i,  23),i=1,2)/
     &  9.694996361663029D-03,
     &  4.783690288121502D-01, 0.000000000000000D+00/
C
C   n =  19
C
      data wleb(  24),(gjk(i,  24),i=1,2)/
     &  5.996313688621381D-04,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(  25),(gjk(i,  25),i=1,2)/
     &  7.372999718620756D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  26),(gjk(i,  26),i=1,2)/
     &  7.210515360144488D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  27),(gjk(i,  27),i=1,2)/
     &  7.116355493117555D-03,
     &  6.764410400114264D-01, 6.764410400114264D-01/
      data wleb(  28),(gjk(i,  28),i=1,2)/
     &  6.753829486314477D-03,
     &  4.174961227965453D-01, 4.174961227965453D-01/
      data wleb(  29),(gjk(i,  29),i=1,2)/
     &  7.574394159054034D-03,
     &  1.574676672039082D-01, 1.574676672039082D-01/
      data wleb(  30),(gjk(i,  30),i=1,2)/
     &  6.991087353303262D-03,
     &  1.403553811713183D-01, 4.493328323269557D-01/
C
C   n =  21
C
      data wleb(  31),(gjk(i,  31),i=1,2)/
     &  5.544842902037365D-03,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(  32),(gjk(i,  32),i=1,2)/
     &  6.071332770670752D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  33),(gjk(i,  33),i=1,2)/
     &  6.383674773515093D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  34),(gjk(i,  34),i=1,2)/
     &  5.183387587747790D-03,
     &  2.551252621114134D-01, 2.551252621114134D-01/
      data wleb(  35),(gjk(i,  35),i=1,2)/
     &  6.317929009813725D-03,
     &  6.743601460362766D-01, 6.743601460362766D-01/
      data wleb(  36),(gjk(i,  36),i=1,2)/
     &  6.201670006589077D-03,
     &  4.318910696719410D-01, 4.318910696719410D-01/
      data wleb(  37),(gjk(i,  37),i=1,2)/
     &  5.477143385137348D-03,
     &  2.613931360335988D-01, 0.000000000000000D+00/
      data wleb(  38),(gjk(i,  38),i=1,2)/
     &  5.968383987681156D-03,
     &  4.990453161796037D-01, 1.446630744325115D-01/
C
C   n =  23
C
      data wleb(  39),(gjk(i,  39),i=1,2)/
     &  1.782340447244611D-03,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(  40),(gjk(i,  40),i=1,2)/
     &  5.716905949977102D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  41),(gjk(i,  41),i=1,2)/
     &  5.573383178848738D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  42),(gjk(i,  42),i=1,2)/
     &  5.608704082587997D-03,
     &  6.712973442695226D-01, 6.712973442695226D-01/
      data wleb(  43),(gjk(i,  43),i=1,2)/
     &  5.158237711805383D-03,
     &  2.892465627575439D-01, 2.892465627575439D-01/
      data wleb(  44),(gjk(i,  44),i=1,2)/
     &  5.518771467273614D-03,
     &  4.446933178717437D-01, 4.446933178717437D-01/
      data wleb(  45),(gjk(i,  45),i=1,2)/
     &  4.106777028169394D-03,
     &  1.299335447650067D-01, 1.299335447650067D-01/
      data wleb(  46),(gjk(i,  46),i=1,2)/
     &  5.051846064614808D-03,
     &  3.457702197611283D-01, 0.000000000000000D+00/
      data wleb(  47),(gjk(i,  47),i=1,2)/
     &  5.530248916233094D-03,
     &  1.590417105383530D-01, 8.360360154824589D-01/
C
C   n =  25
C
      data wleb(  48),(gjk(i,  48),i=1,2)/
     & -5.522639919727325D-02,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(  49),(gjk(i,  49),i=1,2)/
     &  4.450274607445226D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  50),(gjk(i,  50),i=1,2)/
     &  4.496841067921404D-03,
     &  4.492044687397611D-01, 4.492044687397611D-01/
      data wleb(  51),(gjk(i,  51),i=1,2)/
     &  5.049153450478750D-03,
     &  2.520419490210201D-01, 2.520419490210201D-01/
      data wleb(  52),(gjk(i,  52),i=1,2)/
     &  3.976408018051883D-03,
     &  6.981906658447242D-01, 6.981906658447242D-01/
      data wleb(  53),(gjk(i,  53),i=1,2)/
     &  4.401400650381014D-03,
     &  6.587405243460960D-01, 6.587405243460960D-01/
      data wleb(  54),(gjk(i,  54),i=1,2)/
     &  1.724544350544401D-02,
     &  4.038544050097660D-02, 4.038544050097660D-02/
      data wleb(  55),(gjk(i,  55),i=1,2)/
     &  4.231083095357343D-03,
     &  5.823842309715584D-01, 0.000000000000000D+00/
      data wleb(  56),(gjk(i,  56),i=1,2)/
     &  5.198069864064399D-03,
     &  3.545877390518688D-01, 0.000000000000000D+00/
      data wleb(  57),(gjk(i,  57),i=1,2)/
     &  4.695720972568883D-03,
     &  2.272181808998187D-01, 4.864661535886647D-01/
C
C   n =  27
C
      data wleb(  58),(gjk(i,  58),i=1,2)/
     & -1.313769127326952D-03,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(  59),(gjk(i,  59),i=1,2)/
     & -2.522728704859336D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  60),(gjk(i,  60),i=1,2)/
     &  4.186853881700583D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  61),(gjk(i,  61),i=1,2)/
     &  5.315167977810885D-03,
     &  7.039373391585475D-01, 7.039373391585475D-01/
      data wleb(  62),(gjk(i,  62),i=1,2)/
     &  4.047142377086219D-03,
     &  1.012526248572414D-01, 1.012526248572414D-01/
      data wleb(  63),(gjk(i,  63),i=1,2)/
     &  4.112482394406990D-03,
     &  4.647448726420539D-01, 4.647448726420539D-01/
      data wleb(  64),(gjk(i,  64),i=1,2)/
     &  3.595584899758782D-03,
     &  3.277420654971629D-01, 3.277420654971629D-01/
      data wleb(  65),(gjk(i,  65),i=1,2)/
     &  4.256131351428158D-03,
     &  6.620338663699974D-01, 6.620338663699974D-01/
      data wleb(  66),(gjk(i,  66),i=1,2)/
     &  4.229582700647240D-03,
     &  8.506508083520399D-01, 0.000000000000000D+00/
      data wleb(  67),(gjk(i,  67),i=1,2)/
     &  4.080914225780505D-03,
     &  3.233484542692899D-01, 1.153112011009701D-01/
      data wleb(  68),(gjk(i,  68),i=1,2)/
     &  4.071467593830964D-03,
     &  2.314790158712601D-01, 5.244939240922365D-01/
C
C   n =  29
C
      data wleb(  69),(gjk(i,  69),i=1,2)/
     &  8.545911725128148D-04,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(  70),(gjk(i,  70),i=1,2)/
     &  3.599119285025571D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  71),(gjk(i,  71),i=1,2)/
     &  3.449788424305883D-03,
     &  3.515640345570105D-01, 3.515640345570105D-01/
      data wleb(  72),(gjk(i,  72),i=1,2)/
     &  3.604822601419882D-03,
     &  6.566329410219612D-01, 6.566329410219612D-01/
      data wleb(  73),(gjk(i,  73),i=1,2)/
     &  3.576729661743367D-03,
     &  4.729054132581005D-01, 4.729054132581005D-01/
      data wleb(  74),(gjk(i,  74),i=1,2)/
     &  2.352101413689164D-03,
     &  9.618308522614784D-02, 9.618308522614784D-02/
      data wleb(  75),(gjk(i,  75),i=1,2)/
     &  3.108953122413675D-03,
     &  2.219645236294178D-01, 2.219645236294178D-01/
      data wleb(  76),(gjk(i,  76),i=1,2)/
     &  3.650045807677255D-03,
     &  7.011766416089545D-01, 7.011766416089545D-01/
      data wleb(  77),(gjk(i,  77),i=1,2)/
     &  2.982344963171804D-03,
     &  2.644152887060663D-01, 0.000000000000000D+00/
      data wleb(  78),(gjk(i,  78),i=1,2)/
     &  3.600820932216460D-03,
     &  5.718955891878961D-01, 0.000000000000000D+00/
      data wleb(  79),(gjk(i,  79),i=1,2)/
     &  3.571540554273387D-03,
     &  2.510034751770465D-01, 8.000727494073951D-01/
      data wleb(  80),(gjk(i,  80),i=1,2)/
     &  3.392312205006170D-03,
     &  1.233548532583327D-01, 4.127724083168531D-01/
C
C   n =  31
C
      data wleb(  81),(gjk(i,  81),i=1,2)/
     &  3.006796749453936D-03,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(  82),(gjk(i,  82),i=1,2)/
     &  3.050627745650771D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  83),(gjk(i,  83),i=1,2)/
     &  1.621104600288991D-03,
     &  7.068965463912316D-01, 7.068965463912316D-01/
      data wleb(  84),(gjk(i,  84),i=1,2)/
     &  3.005701484901752D-03,
     &  4.794682625712025D-01, 4.794682625712025D-01/
      data wleb(  85),(gjk(i,  85),i=1,2)/
     &  2.990992529653774D-03,
     &  1.927533154878019D-01, 1.927533154878019D-01/
      data wleb(  86),(gjk(i,  86),i=1,2)/
     &  2.982170644107595D-03,
     &  6.930357961327123D-01, 6.930357961327123D-01/
      data wleb(  87),(gjk(i,  87),i=1,2)/
     &  2.721564237310992D-03,
     &  3.608302115520091D-01, 3.608302115520091D-01/
      data wleb(  88),(gjk(i,  88),i=1,2)/
     &  3.033513795811141D-03,
     &  6.498486161496169D-01, 6.498486161496169D-01/
      data wleb(  89),(gjk(i,  89),i=1,2)/
     &  3.007949555218533D-03,
     &  1.932945013230339D-01, 0.000000000000000D+00/
      data wleb(  90),(gjk(i,  90),i=1,2)/
     &  2.881964603055307D-03,
     &  3.800494919899303D-01, 0.000000000000000D+00/
      data wleb(  91),(gjk(i,  91),i=1,2)/
     &  2.958357626535696D-03,
     &  2.899558825499574D-01, 7.934537856582315D-01/
      data wleb(  92),(gjk(i,  92),i=1,2)/
     &  3.036020026407088D-03,
     &  9.684121455103957D-02, 8.280801506686862D-01/
      data wleb(  93),(gjk(i,  93),i=1,2)/
     &  2.832187403926303D-03,
     &  1.833434647041659D-01, 9.074658265305127D-01/
C
C   n =  35
C
      data wleb(  94),(gjk(i,  94),i=1,2)/
     &  5.265897968224436D-04,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(  95),(gjk(i,  95),i=1,2)/
     &  2.548219972002607D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  96),(gjk(i,  96),i=1,2)/
     &  2.512317418927307D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(  97),(gjk(i,  97),i=1,2)/
     &  2.530403801186355D-03,
     &  6.909346307509111D-01, 6.909346307509111D-01/
      data wleb(  98),(gjk(i,  98),i=1,2)/
     &  2.014279020918528D-03,
     &  1.774836054609158D-01, 1.774836054609158D-01/
      data wleb(  99),(gjk(i,  99),i=1,2)/
     &  2.501725168402936D-03,
     &  4.914342637784746D-01, 4.914342637784746D-01/
      data wleb( 100),(gjk(i, 100),i=1,2)/
     &  2.513267174597564D-03,
     &  6.456664707424256D-01, 6.456664707424256D-01/
      data wleb( 101),(gjk(i, 101),i=1,2)/
     &  2.302694782227416D-03,
     &  2.861289010307638D-01, 2.861289010307638D-01/
      data wleb( 102),(gjk(i, 102),i=1,2)/
     &  1.462495621594614D-03,
     &  7.568084367178018D-02, 7.568084367178018D-02/
      data wleb( 103),(gjk(i, 103),i=1,2)/
     &  2.445373437312980D-03,
     &  3.927259763368002D-01, 3.927259763368002D-01/
      data wleb( 104),(gjk(i, 104),i=1,2)/
     &  2.417442375638981D-03,
     &  8.818132877794288D-01, 0.000000000000000D+00/
      data wleb( 105),(gjk(i, 105),i=1,2)/
     &  1.910951282179532D-03,
     &  9.776428111182649D-01, 0.000000000000000D+00/
      data wleb( 106),(gjk(i, 106),i=1,2)/
     &  2.416930044324775D-03,
     &  2.054823696403044D-01, 8.689460322872412D-01/
      data wleb( 107),(gjk(i, 107),i=1,2)/
     &  2.512236854563495D-03,
     &  5.905157048925271D-01, 7.999278543857286D-01/
      data wleb( 108),(gjk(i, 108),i=1,2)/
     &  2.496644054553086D-03,
     &  5.550152361076807D-01, 7.717462626915901D-01/
      data wleb( 109),(gjk(i, 109),i=1,2)/
     &  2.236607760437849D-03,
     &  9.371809858553722D-01, 3.344363145343455D-01/
C
C   n =  41
C
      data wleb( 110),(gjk(i, 110),i=1,2)/
     &  3.095121295306187D-04,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 111),(gjk(i, 111),i=1,2)/
     &  1.852379698597489D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 112),(gjk(i, 112),i=1,2)/
     &  1.871790639277744D-03,
     &  7.040954938227469D-01, 7.040954938227469D-01/
      data wleb( 113),(gjk(i, 113),i=1,2)/
     &  1.858812585438317D-03,
     &  6.807744066455244D-01, 6.807744066455244D-01/
      data wleb( 114),(gjk(i, 114),i=1,2)/
     &  1.852028828296213D-03,
     &  6.372546939258752D-01, 6.372546939258752D-01/
      data wleb( 115),(gjk(i, 115),i=1,2)/
     &  1.846715956151242D-03,
     &  5.044419707800358D-01, 5.044419707800358D-01/
      data wleb( 116),(gjk(i, 116),i=1,2)/
     &  1.818471778162769D-03,
     &  4.215761784010967D-01, 4.215761784010967D-01/
      data wleb( 117),(gjk(i, 117),i=1,2)/
     &  1.749564657281154D-03,
     &  3.317920736472123D-01, 3.317920736472123D-01/
      data wleb( 118),(gjk(i, 118),i=1,2)/
     &  1.617210647254411D-03,
     &  2.384736701421887D-01, 2.384736701421887D-01/
      data wleb( 119),(gjk(i, 119),i=1,2)/
     &  1.384737234851692D-03,
     &  1.459036449157763D-01, 1.459036449157763D-01/
      data wleb( 120),(gjk(i, 120),i=1,2)/
     &  9.764331165051050D-04,
     &  6.095034115507196D-02, 6.095034115507196D-02/
      data wleb( 121),(gjk(i, 121),i=1,2)/
     &  1.857161196774078D-03,
     &  6.116843442009876D-01, 0.000000000000000D+00/
      data wleb( 122),(gjk(i, 122),i=1,2)/
     &  1.705153996395864D-03,
     &  3.964755348199858D-01, 0.000000000000000D+00/
      data wleb( 123),(gjk(i, 123),i=1,2)/
     &  1.300321685886048D-03,
     &  1.724782009907724D-01, 0.000000000000000D+00/
      data wleb( 124),(gjk(i, 124),i=1,2)/
     &  1.842866472905286D-03,
     &  5.610263808622060D-01, 3.518280927733519D-01/
      data wleb( 125),(gjk(i, 125),i=1,2)/
     &  1.802658934377451D-03,
     &  4.742392842551980D-01, 2.634716655937950D-01/
      data wleb( 126),(gjk(i, 126),i=1,2)/
     &  1.849830560443660D-03,
     &  5.984126497885380D-01, 1.816640840360209D-01/
      data wleb( 127),(gjk(i, 127),i=1,2)/
     &  1.713904507106709D-03,
     &  3.791035407695563D-01, 1.720795225656878D-01/
      data wleb( 128),(gjk(i, 128),i=1,2)/
     &  1.555213603396808D-03,
     &  2.778673190586244D-01, 8.213021581932511D-02/
      data wleb( 129),(gjk(i, 129),i=1,2)/
     &  1.802239128008525D-03,
     &  5.033564271075117D-01, 8.999205842074876D-02/
C
C   n =  47
C
      data wleb( 130),(gjk(i, 130),i=1,2)/
     &  2.192942088181184D-04,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 131),(gjk(i, 131),i=1,2)/
     &  1.436433617319080D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 132),(gjk(i, 132),i=1,2)/
     &  1.421940344335877D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 133),(gjk(i, 133),i=1,2)/
     &  6.798123511050502D-04,
     &  5.087204410502360D-02, 5.087204410502360D-02/
      data wleb( 134),(gjk(i, 134),i=1,2)/
     &  9.913184235294911D-04,
     &  1.228198790178831D-01, 1.228198790178831D-01/
      data wleb( 135),(gjk(i, 135),i=1,2)/
     &  1.180207833238949D-03,
     &  2.026890814408786D-01, 2.026890814408786D-01/
      data wleb( 136),(gjk(i, 136),i=1,2)/
     &  1.296599602080921D-03,
     &  2.847745156464294D-01, 2.847745156464294D-01/
      data wleb( 137),(gjk(i, 137),i=1,2)/
     &  1.365871427428316D-03,
     &  3.656719078978026D-01, 3.656719078978026D-01/
      data wleb( 138),(gjk(i, 138),i=1,2)/
     &  1.402988604775325D-03,
     &  4.428264886713469D-01, 4.428264886713469D-01/
      data wleb( 139),(gjk(i, 139),i=1,2)/
     &  1.418645563595609D-03,
     &  5.140619627249735D-01, 5.140619627249735D-01/
      data wleb( 140),(gjk(i, 140),i=1,2)/
     &  1.421376741851662D-03,
     &  6.306401219166803D-01, 6.306401219166803D-01/
      data wleb( 141),(gjk(i, 141),i=1,2)/
     &  1.423996475490962D-03,
     &  6.716883332022612D-01, 6.716883332022612D-01/
      data wleb( 142),(gjk(i, 142),i=1,2)/
     &  1.431554042178567D-03,
     &  6.979792685336881D-01, 6.979792685336881D-01/
      data wleb( 143),(gjk(i, 143),i=1,2)/
     &  9.254401499865368D-04,
     &  1.446865674195309D-01, 0.000000000000000D+00/
      data wleb( 144),(gjk(i, 144),i=1,2)/
     &  1.250239995053509D-03,
     &  3.390263475411216D-01, 0.000000000000000D+00/
      data wleb( 145),(gjk(i, 145),i=1,2)/
     &  1.394365843329230D-03,
     &  5.335804651263506D-01, 0.000000000000000D+00/
      data wleb( 146),(gjk(i, 146),i=1,2)/
     &  1.127089094671749D-03,
     &  6.944024393349413D-02, 2.355187894242326D-01/
      data wleb( 147),(gjk(i, 147),i=1,2)/
     &  1.345753760910670D-03,
     &  2.269004109529460D-01, 4.102182474045730D-01/
      data wleb( 148),(gjk(i, 148),i=1,2)/
     &  1.424957283316783D-03,
     &  8.025574607775339D-02, 6.214302417481605D-01/
      data wleb( 149),(gjk(i, 149),i=1,2)/
     &  1.261523341237750D-03,
     &  1.467999527896572D-01, 3.245284345717394D-01/
      data wleb( 150),(gjk(i, 150),i=1,2)/
     &  1.392547106052696D-03,
     &  1.571507769824727D-01, 5.224482189696630D-01/
      data wleb( 151),(gjk(i, 151),i=1,2)/
     &  1.418761677877656D-03,
     &  2.365702993157246D-01, 6.017546634089558D-01/
      data wleb( 152),(gjk(i, 152),i=1,2)/
     &  1.338366684479554D-03,
     &  7.714815866765733D-02, 4.346575516141163D-01/
      data wleb( 153),(gjk(i, 153),i=1,2)/
     &  1.393700862676131D-03,
     &  3.062936666210730D-01, 4.908826589037616D-01/
      data wleb( 154),(gjk(i, 154),i=1,2)/
     &  1.415914757466932D-03,
     &  3.822477379524787D-01, 5.648768149099500D-01/
C
C   n =  53
C
      data wleb( 155),(gjk(i, 155),i=1,2)/
     &  1.438294190527431D-04,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 156),(gjk(i, 156),i=1,2)/
     &  1.125772288287004D-03,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 157),(gjk(i, 157),i=1,2)/
     &  4.948029341949241D-04,
     &  4.292963545341347D-02, 4.292963545341347D-02/
      data wleb( 158),(gjk(i, 158),i=1,2)/
     &  7.357990109125470D-04,
     &  1.051426854086404D-01, 1.051426854086404D-01/
      data wleb( 159),(gjk(i, 159),i=1,2)/
     &  8.889132771304384D-04,
     &  1.750024867623087D-01, 1.750024867623087D-01/
      data wleb( 160),(gjk(i, 160),i=1,2)/
     &  9.888347838921435D-04,
     &  2.477653379650257D-01, 2.477653379650257D-01/
      data wleb( 161),(gjk(i, 161),i=1,2)/
     &  1.053299681709471D-03,
     &  3.206567123955957D-01, 3.206567123955957D-01/
      data wleb( 162),(gjk(i, 162),i=1,2)/
     &  1.092778807014578D-03,
     &  3.916520749849983D-01, 3.916520749849983D-01/
      data wleb( 163),(gjk(i, 163),i=1,2)/
     &  1.114389394063227D-03,
     &  4.590825874187624D-01, 4.590825874187624D-01/
      data wleb( 164),(gjk(i, 164),i=1,2)/
     &  1.123724788051555D-03,
     &  5.214563888415861D-01, 5.214563888415861D-01/
      data wleb( 165),(gjk(i, 165),i=1,2)/
     &  1.125239325243814D-03,
     &  6.253170244654199D-01, 6.253170244654199D-01/
      data wleb( 166),(gjk(i, 166),i=1,2)/
     &  1.126153271815905D-03,
     &  6.637926744523170D-01, 6.637926744523170D-01/
      data wleb( 167),(gjk(i, 167),i=1,2)/
     &  1.130286931123841D-03,
     &  6.910410398498301D-01, 6.910410398498301D-01/
      data wleb( 168),(gjk(i, 168),i=1,2)/
     &  1.134986534363955D-03,
     &  7.052907007457760D-01, 7.052907007457760D-01/
      data wleb( 169),(gjk(i, 169),i=1,2)/
     &  6.823367927109931D-04,
     &  1.236686762657990D-01, 0.000000000000000D+00/
      data wleb( 170),(gjk(i, 170),i=1,2)/
     &  9.454158160447096D-04,
     &  2.940777114468387D-01, 0.000000000000000D+00/
      data wleb( 171),(gjk(i, 171),i=1,2)/
     &  1.074429975385679D-03,
     &  4.697753849207649D-01, 0.000000000000000D+00/
      data wleb( 172),(gjk(i, 172),i=1,2)/
     &  1.129300086569132D-03,
     &  6.334563241139567D-01, 0.000000000000000D+00/
      data wleb( 173),(gjk(i, 173),i=1,2)/
     &  8.436884500901954D-04,
     &  5.974048614181342D-02, 2.029128752777523D-01/
      data wleb( 174),(gjk(i, 174),i=1,2)/
     &  1.075255720448885D-03,
     &  1.375760408473636D-01, 4.602621942484054D-01/
      data wleb( 175),(gjk(i, 175),i=1,2)/
     &  1.108577236864462D-03,
     &  3.391016526336286D-01, 5.030673999662036D-01/
      data wleb( 176),(gjk(i, 176),i=1,2)/
     &  9.566475323783357D-04,
     &  1.271675191439820D-01, 2.817606422442134D-01/
      data wleb( 177),(gjk(i, 177),i=1,2)/
     &  1.080663250717391D-03,
     &  2.693120740413512D-01, 4.331561291720157D-01/
      data wleb( 178),(gjk(i, 178),i=1,2)/
     &  1.126797131196295D-03,
     &  1.419786452601918D-01, 6.256167358580814D-01/
      data wleb( 179),(gjk(i, 179),i=1,2)/
     &  1.022568715358061D-03,
     &  6.709284600738255D-02, 3.798395216859157D-01/
      data wleb( 180),(gjk(i, 180),i=1,2)/
     &  1.108960267713108D-03,
     &  7.057738183256172D-02, 5.517505421423520D-01/
      data wleb( 181),(gjk(i, 181),i=1,2)/
     &  1.122790653435766D-03,
     &  2.783888477882155D-01, 6.029619156159187D-01/
      data wleb( 182),(gjk(i, 182),i=1,2)/
     &  1.032401847117460D-03,
     &  1.979578938917407D-01, 3.589606329589096D-01/
      data wleb( 183),(gjk(i, 183),i=1,2)/
     &  1.107249382283854D-03,
     &  2.087307061103274D-01, 5.348666438135476D-01/
      data wleb( 184),(gjk(i, 184),i=1,2)/
     &  1.121780048519972D-03,
     &  4.055122137872836D-01, 5.674997546074373D-01/
C
C   n =  59
C
      data wleb( 185),(gjk(i, 185),i=1,2)/
     &  1.105189233267572D-04,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 186),(gjk(i, 186),i=1,2)/
     &  9.205232738090741D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 187),(gjk(i, 187),i=1,2)/
     &  9.133159786443561D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 188),(gjk(i, 188),i=1,2)/
     &  3.690421898017899D-04,
     &  3.712636449657089D-02, 3.712636449657089D-02/
      data wleb( 189),(gjk(i, 189),i=1,2)/
     &  5.603990928680660D-04,
     &  9.140060412262223D-02, 9.140060412262223D-02/
      data wleb( 190),(gjk(i, 190),i=1,2)/
     &  6.865297629282609D-04,
     &  1.531077852469906D-01, 1.531077852469906D-01/
      data wleb( 191),(gjk(i, 191),i=1,2)/
     &  7.720338551145630D-04,
     &  2.180928891660612D-01, 2.180928891660612D-01/
      data wleb( 192),(gjk(i, 192),i=1,2)/
     &  8.301545958894795D-04,
     &  2.839874532200175D-01, 2.839874532200175D-01/
      data wleb( 193),(gjk(i, 193),i=1,2)/
     &  8.686692550179628D-04,
     &  3.491177600963764D-01, 3.491177600963764D-01/
      data wleb( 194),(gjk(i, 194),i=1,2)/
     &  8.927076285846890D-04,
     &  4.121431461444309D-01, 4.121431461444309D-01/
      data wleb( 195),(gjk(i, 195),i=1,2)/
     &  9.060820238568219D-04,
     &  4.718993627149127D-01, 4.718993627149127D-01/
      data wleb( 196),(gjk(i, 196),i=1,2)/
     &  9.119777254940867D-04,
     &  5.273145452842337D-01, 5.273145452842337D-01/
      data wleb( 197),(gjk(i, 197),i=1,2)/
     &  9.128720138604181D-04,
     &  6.209475332444019D-01, 6.209475332444019D-01/
      data wleb( 198),(gjk(i, 198),i=1,2)/
     &  9.130714935691735D-04,
     &  6.569722711857291D-01, 6.569722711857291D-01/
      data wleb( 199),(gjk(i, 199),i=1,2)/
     &  9.152873784554116D-04,
     &  6.841788309070143D-01, 6.841788309070143D-01/
      data wleb( 200),(gjk(i, 200),i=1,2)/
     &  9.187436274321654D-04,
     &  7.012604330123631D-01, 7.012604330123631D-01/
      data wleb( 201),(gjk(i, 201),i=1,2)/
     &  5.176977312965694D-04,
     &  1.072382215478166D-01, 0.000000000000000D+00/
      data wleb( 202),(gjk(i, 202),i=1,2)/
     &  7.331143682101417D-04,
     &  2.582068959496968D-01, 0.000000000000000D+00/
      data wleb( 203),(gjk(i, 203),i=1,2)/
     &  8.463232836379928D-04,
     &  4.172752955306717D-01, 0.000000000000000D+00/
      data wleb( 204),(gjk(i, 204),i=1,2)/
     &  9.031122694253992D-04,
     &  5.700366911792503D-01, 0.000000000000000D+00/
      data wleb( 205),(gjk(i, 205),i=1,2)/
     &  6.485778453163257D-04,
     &  9.827986018263947D-01, 1.771774022615325D-01/
      data wleb( 206),(gjk(i, 206),i=1,2)/
     &  7.435030910982369D-04,
     &  9.624249230326228D-01, 2.475716463426288D-01/
      data wleb( 207),(gjk(i, 207),i=1,2)/
     &  7.998527891839054D-04,
     &  9.402007994128811D-01, 3.354616289066489D-01/
      data wleb( 208),(gjk(i, 208),i=1,2)/
     &  8.101731497468018D-04,
     &  9.320822040143202D-01, 3.173615246611977D-01/
      data wleb( 209),(gjk(i, 209),i=1,2)/
     &  8.483389574594330D-04,
     &  9.043674199393299D-01, 4.090268427085357D-01/
      data wleb( 210),(gjk(i, 210),i=1,2)/
     &  8.556299257311812D-04,
     &  8.912407560074747D-01, 3.854291150669224D-01/
      data wleb( 211),(gjk(i, 211),i=1,2)/
     &  8.803208679738260D-04,
     &  8.676435628462708D-01, 4.932221184851285D-01/
      data wleb( 212),(gjk(i, 212),i=1,2)/
     &  8.811048182425720D-04,
     &  8.581979986041619D-01, 4.785320675922435D-01/
      data wleb( 213),(gjk(i, 213),i=1,2)/
     &  8.850282341265444D-04,
     &  8.396753624049856D-01, 4.507422593157064D-01/
      data wleb( 214),(gjk(i, 214),i=1,2)/
     &  9.021342299040653D-04,
     &  8.165288564022188D-01, 5.632123020762100D-01/
      data wleb( 215),(gjk(i, 215),i=1,2)/
     &  9.010091677105086D-04,
     &  8.015469370783529D-01, 5.434303569693900D-01/
      data wleb( 216),(gjk(i, 216),i=1,2)/
     &  9.022692938426915D-04,
     &  7.773563069070351D-01, 5.123518486419871D-01/
      data wleb( 217),(gjk(i, 217),i=1,2)/
     &  9.158016174693465D-04,
     &  7.661621213900394D-01, 6.394279634749102D-01/
      data wleb( 218),(gjk(i, 218),i=1,2)/
     &  9.131578003189435D-04,
     &  7.553584143533510D-01, 6.269805509024392D-01/
      data wleb( 219),(gjk(i, 219),i=1,2)/
     &  9.107813579482705D-04,
     &  7.344305757559503D-01, 6.031161693096310D-01/
      data wleb( 220),(gjk(i, 220),i=1,2)/
     &  9.105760258970126D-04,
     &  7.043837184021765D-01, 5.693702498468441D-01/
C
C   n =  65
C
      data wleb( 221),(gjk(i, 221),i=1,2)/
     &  7.777160743261247D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 222),(gjk(i, 222),i=1,2)/
     &  7.557646413004701D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 223),(gjk(i, 223),i=1,2)/
     &  2.841633806090617D-04,
     &  3.229290663413854D-02, 3.229290663413854D-02/
      data wleb( 224),(gjk(i, 224),i=1,2)/
     &  4.374419127053555D-04,
     &  8.036733271462222D-02, 8.036733271462222D-02/
      data wleb( 225),(gjk(i, 225),i=1,2)/
     &  5.417174740872172D-04,
     &  1.354289960531653D-01, 1.354289960531653D-01/
      data wleb( 226),(gjk(i, 226),i=1,2)/
     &  6.148000891358593D-04,
     &  1.938963861114426D-01, 1.938963861114426D-01/
      data wleb( 227),(gjk(i, 227),i=1,2)/
     &  6.664394485800704D-04,
     &  2.537343715011275D-01, 2.537343715011275D-01/
      data wleb( 228),(gjk(i, 228),i=1,2)/
     &  7.025039356923220D-04,
     &  3.135251434752570D-01, 3.135251434752570D-01/
      data wleb( 229),(gjk(i, 229),i=1,2)/
     &  7.268511789249627D-04,
     &  3.721558339375338D-01, 3.721558339375338D-01/
      data wleb( 230),(gjk(i, 230),i=1,2)/
     &  7.422637534208629D-04,
     &  4.286809575195696D-01, 4.286809575195696D-01/
      data wleb( 231),(gjk(i, 231),i=1,2)/
     &  7.509545035841214D-04,
     &  4.822510128282994D-01, 4.822510128282994D-01/
      data wleb( 232),(gjk(i, 232),i=1,2)/
     &  7.548535057718401D-04,
     &  5.320679333566263D-01, 5.320679333566263D-01/
      data wleb( 233),(gjk(i, 233),i=1,2)/
     &  7.554088969774001D-04,
     &  6.172998195394274D-01, 6.172998195394274D-01/
      data wleb( 234),(gjk(i, 234),i=1,2)/
     &  7.553147174442808D-04,
     &  6.510679849127481D-01, 6.510679849127481D-01/
      data wleb( 235),(gjk(i, 235),i=1,2)/
     &  7.564767653292297D-04,
     &  6.777315251687360D-01, 6.777315251687360D-01/
      data wleb( 236),(gjk(i, 236),i=1,2)/
     &  7.587991808518730D-04,
     &  6.963109410648741D-01, 6.963109410648741D-01/
      data wleb( 237),(gjk(i, 237),i=1,2)/
     &  7.608261832033027D-04,
     &  7.058935009831749D-01, 7.058935009831749D-01/
      data wleb( 238),(gjk(i, 238),i=1,2)/
     &  4.021680447874916D-04,
     &  9.955546194091857D-01, 0.000000000000000D+00/
      data wleb( 239),(gjk(i, 239),i=1,2)/
     &  5.804871793945964D-04,
     &  9.734115901794209D-01, 0.000000000000000D+00/
      data wleb( 240),(gjk(i, 240),i=1,2)/
     &  6.792151955945159D-04,
     &  9.275693732388626D-01, 0.000000000000000D+00/
      data wleb( 241),(gjk(i, 241),i=1,2)/
     &  7.336741211286294D-04,
     &  8.568022422795103D-01, 0.000000000000000D+00/
      data wleb( 242),(gjk(i, 242),i=1,2)/
     &  7.581866300989608D-04,
     &  7.623495553719372D-01, 0.000000000000000D+00/
      data wleb( 243),(gjk(i, 243),i=1,2)/
     &  7.538257859800743D-04,
     &  5.707522908892223D-01, 4.387028039889501D-01/
      data wleb( 244),(gjk(i, 244),i=1,2)/
     &  7.483517247053123D-04,
     &  5.196463388403083D-01, 3.858908414762617D-01/
      data wleb( 245),(gjk(i, 245),i=1,2)/
     &  7.371763661112059D-04,
     &  4.646337531215351D-01, 3.301937372343854D-01/
      data wleb( 246),(gjk(i, 246),i=1,2)/
     &  7.183448895756934D-04,
     &  4.063901697557691D-01, 2.725423573563777D-01/
      data wleb( 247),(gjk(i, 247),i=1,2)/
     &  6.895815529822191D-04,
     &  3.456329466643087D-01, 2.139510237495250D-01/
      data wleb( 248),(gjk(i, 248),i=1,2)/
     &  6.480105801792886D-04,
     &  2.831395121050332D-01, 1.555922309786647D-01/
      data wleb( 249),(gjk(i, 249),i=1,2)/
     &  5.897558896594636D-04,
     &  2.197682022925330D-01, 9.892878979686097D-02/
      data wleb( 250),(gjk(i, 250),i=1,2)/
     &  5.095708849247346D-04,
     &  1.564696098650355D-01, 4.598642910675510D-02/
      data wleb( 251),(gjk(i, 251),i=1,2)/
     &  7.536906428909755D-04,
     &  6.027356673721295D-01, 3.376625140173426D-01/
      data wleb( 252),(gjk(i, 252),i=1,2)/
     &  7.472505965575118D-04,
     &  5.496032320255096D-01, 2.822301309727988D-01/
      data wleb( 253),(gjk(i, 253),i=1,2)/
     &  7.343017132279698D-04,
     &  4.921707755234567D-01, 2.248632342592540D-01/
      data wleb( 254),(gjk(i, 254),i=1,2)/
     &  7.130871582177445D-04,
     &  4.309422998598483D-01, 1.666224723456479D-01/
      data wleb( 255),(gjk(i, 255),i=1,2)/
     &  6.817022032112776D-04,
     &  3.664108182313672D-01, 1.086964901822169D-01/
      data wleb( 256),(gjk(i, 256),i=1,2)/
     &  6.380941145604121D-04,
     &  2.990189057758436D-01, 5.251989784120085D-02/
      data wleb( 257),(gjk(i, 257),i=1,2)/
     &  7.550381377920310D-04,
     &  6.268724013144998D-01, 2.297523657550023D-01/
      data wleb( 258),(gjk(i, 258),i=1,2)/
     &  7.478646640144802D-04,
     &  5.707324144834607D-01, 1.723080607093800D-01/
      data wleb( 259),(gjk(i, 259),i=1,2)/
     &  7.335918720601220D-04,
     &  5.096360901960365D-01, 1.140238465390513D-01/
      data wleb( 260),(gjk(i, 260),i=1,2)/
     &  7.110120527658118D-04,
     &  4.438729938312456D-01, 5.611522095882537D-02/
      data wleb( 261),(gjk(i, 261),i=1,2)/
     &  7.571363978689501D-04,
     &  6.419978471082389D-01, 1.164174423140873D-01/
      data wleb( 262),(gjk(i, 262),i=1,2)/
     &  7.489908329079233D-04,
     &  5.817218061802611D-01, 5.797589531445219D-02/
C
C   n =  71
C
      data wleb( 263),(gjk(i, 263),i=1,2)/
     &  6.309049437420976D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 264),(gjk(i, 264),i=1,2)/
     &  6.398287705571748D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 265),(gjk(i, 265),i=1,2)/
     &  6.357185073530719D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 266),(gjk(i, 266),i=1,2)/
     &  2.221207162188168D-04,
     &  2.860923126194662D-02, 2.860923126194662D-02/
      data wleb( 267),(gjk(i, 267),i=1,2)/
     &  3.475784022286848D-04,
     &  7.142556767711522D-02, 7.142556767711522D-02/
      data wleb( 268),(gjk(i, 268),i=1,2)/
     &  4.350742443589804D-04,
     &  1.209199540995559D-01, 1.209199540995559D-01/
      data wleb( 269),(gjk(i, 269),i=1,2)/
     &  4.978569136522127D-04,
     &  1.738673106594379D-01, 1.738673106594379D-01/
      data wleb( 270),(gjk(i, 270),i=1,2)/
     &  5.435036221998053D-04,
     &  2.284645438467734D-01, 2.284645438467734D-01/
      data wleb( 271),(gjk(i, 271),i=1,2)/
     &  5.765913388219542D-04,
     &  2.834807671701512D-01, 2.834807671701512D-01/
      data wleb( 272),(gjk(i, 272),i=1,2)/
     &  6.001200359226003D-04,
     &  3.379680145467339D-01, 3.379680145467339D-01/
      data wleb( 273),(gjk(i, 273),i=1,2)/
     &  6.162178172717512D-04,
     &  3.911355454819537D-01, 3.911355454819537D-01/
      data wleb( 274),(gjk(i, 274),i=1,2)/
     &  6.265218152438484D-04,
     &  4.422860353001403D-01, 4.422860353001403D-01/
      data wleb( 275),(gjk(i, 275),i=1,2)/
     &  6.323987160974212D-04,
     &  4.907781568726057D-01, 4.907781568726057D-01/
      data wleb( 276),(gjk(i, 276),i=1,2)/
     &  6.350767851540569D-04,
     &  5.360006153211468D-01, 5.360006153211468D-01/
      data wleb( 277),(gjk(i, 277),i=1,2)/
     &  6.354362775297107D-04,
     &  6.142105973596603D-01, 6.142105973596603D-01/
      data wleb( 278),(gjk(i, 278),i=1,2)/
     &  6.352302462706236D-04,
     &  6.459300387977503D-01, 6.459300387977503D-01/
      data wleb( 279),(gjk(i, 279),i=1,2)/
     &  6.358117881417972D-04,
     &  6.718056125089225D-01, 6.718056125089225D-01/
      data wleb( 280),(gjk(i, 280),i=1,2)/
     &  6.373101590310116D-04,
     &  6.910888533186254D-01, 6.910888533186254D-01/
      data wleb( 281),(gjk(i, 281),i=1,2)/
     &  6.390428961368665D-04,
     &  7.030467416823252D-01, 7.030467416823252D-01/
      data wleb( 282),(gjk(i, 282),i=1,2)/
     &  3.186913449946576D-04,
     &  8.354951166354646D-02, 0.000000000000000D+00/
      data wleb( 283),(gjk(i, 283),i=1,2)/
     &  4.678028558591711D-04,
     &  2.050143009099486D-01, 0.000000000000000D+00/
      data wleb( 284),(gjk(i, 284),i=1,2)/
     &  5.538829697598626D-04,
     &  3.370208290706637D-01, 0.000000000000000D+00/
      data wleb( 285),(gjk(i, 285),i=1,2)/
     &  6.044475907190476D-04,
     &  4.689051484233963D-01, 0.000000000000000D+00/
      data wleb( 286),(gjk(i, 286),i=1,2)/
     &  6.313575103509012D-04,
     &  5.939400424557334D-01, 0.000000000000000D+00/
      data wleb( 287),(gjk(i, 287),i=1,2)/
     &  4.078626431855630D-04,
     &  1.394983311832261D-01, 4.097581162050343D-02/
      data wleb( 288),(gjk(i, 288),i=1,2)/
     &  4.759933057812725D-04,
     &  1.967999180485014D-01, 8.851987391293348D-02/
      data wleb( 289),(gjk(i, 289),i=1,2)/
     &  5.268151186413440D-04,
     &  2.546183732548967D-01, 1.397680182969819D-01/
      data wleb( 290),(gjk(i, 290),i=1,2)/
     &  5.643048560507316D-04,
     &  3.121281074713875D-01, 1.929452542226526D-01/
      data wleb( 291),(gjk(i, 291),i=1,2)/
     &  5.914501076613073D-04,
     &  3.685981078502492D-01, 2.467898337061562D-01/
      data wleb( 292),(gjk(i, 292),i=1,2)/
     &  6.104561257874195D-04,
     &  4.233760321547856D-01, 3.003104124785409D-01/
      data wleb( 293),(gjk(i, 293),i=1,2)/
     &  6.230252860707806D-04,
     &  4.758671236059246D-01, 3.526684328175033D-01/
      data wleb( 294),(gjk(i, 294),i=1,2)/
     &  6.305618761760796D-04,
     &  5.255178579796463D-01, 4.031134861145713D-01/
      data wleb( 295),(gjk(i, 295),i=1,2)/
     &  6.343092767597889D-04,
     &  5.718025633734589D-01, 4.509426448342351D-01/
      data wleb( 296),(gjk(i, 296),i=1,2)/
     &  5.176268945737827D-04,
     &  2.686927772723415D-01, 4.711322502423248D-02/
      data wleb( 297),(gjk(i, 297),i=1,2)/
     &  5.564840313313692D-04,
     &  3.306006819904809D-01, 9.784487303942695D-02/
      data wleb( 298),(gjk(i, 298),i=1,2)/
     &  5.856426671038980D-04,
     &  3.904906850594983D-01, 1.505395810025273D-01/
      data wleb( 299),(gjk(i, 299),i=1,2)/
     &  6.066386925777091D-04,
     &  4.479957951904390D-01, 2.039728156296050D-01/
      data wleb( 300),(gjk(i, 300),i=1,2)/
     &  6.208824962234458D-04,
     &  5.027076848919780D-01, 2.571529941121107D-01/
      data wleb( 301),(gjk(i, 301),i=1,2)/
     &  6.296314297822907D-04,
     &  5.542087392260217D-01, 3.092191375815670D-01/
      data wleb( 302),(gjk(i, 302),i=1,2)/
     &  6.340423756791859D-04,
     &  6.020850887375186D-01, 3.593807506130276D-01/
      data wleb( 303),(gjk(i, 303),i=1,2)/
     &  5.829627677107342D-04,
     &  4.019851409179594D-01, 5.063389934378671D-02/
      data wleb( 304),(gjk(i, 304),i=1,2)/
     &  6.048693376081110D-04,
     &  4.635614567449800D-01, 1.032422269160612D-01/
      data wleb( 305),(gjk(i, 305),i=1,2)/
     &  6.202362317732461D-04,
     &  5.215860931591575D-01, 1.566322094006254D-01/
      data wleb( 306),(gjk(i, 306),i=1,2)/
     &  6.299005328403779D-04,
     &  5.758202499099271D-01, 2.098082827491099D-01/
      data wleb( 307),(gjk(i, 307),i=1,2)/
     &  6.347722390609352D-04,
     &  6.259893683876795D-01, 2.618824114553391D-01/
      data wleb( 308),(gjk(i, 308),i=1,2)/
     &  6.203778981238834D-04,
     &  5.313795124811891D-01, 5.263245019338556D-02/
      data wleb( 309),(gjk(i, 309),i=1,2)/
     &  6.308414671239979D-04,
     &  5.893317955931995D-01, 1.061059730982005D-01/
      data wleb( 310),(gjk(i, 310),i=1,2)/
     &  6.362706466959498D-04,
     &  6.426246321215801D-01, 1.594171564034221D-01/
      data wleb( 311),(gjk(i, 311),i=1,2)/
     &  6.375414170333233D-04,
     &  6.511904367376113D-01, 5.354789536565540D-02/
C
C   n =  77
C
      data wleb( 312),(gjk(i, 312),i=1,2)/
     &  4.656031899197431D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 313),(gjk(i, 313),i=1,2)/
     &  5.421549195295507D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 314),(gjk(i, 314),i=1,2)/
     &  1.778522133346553D-04,
     &  2.540835336814348D-02, 2.540835336814348D-02/
      data wleb( 315),(gjk(i, 315),i=1,2)/
     &  2.811325405682796D-04,
     &  6.399322800504915D-02, 6.399322800504915D-02/
      data wleb( 316),(gjk(i, 316),i=1,2)/
     &  3.548896312631459D-04,
     &  1.088269469804125D-01, 1.088269469804125D-01/
      data wleb( 317),(gjk(i, 317),i=1,2)/
     &  4.090310897173364D-04,
     &  1.570670798818287D-01, 1.570670798818287D-01/
      data wleb( 318),(gjk(i, 318),i=1,2)/
     &  4.493286134169965D-04,
     &  2.071163932282514D-01, 2.071163932282514D-01/
      data wleb( 319),(gjk(i, 319),i=1,2)/
     &  4.793728447962723D-04,
     &  2.578914044450844D-01, 2.578914044450844D-01/
      data wleb( 320),(gjk(i, 320),i=1,2)/
     &  5.015415319164265D-04,
     &  3.085687558169623D-01, 3.085687558169623D-01/
      data wleb( 321),(gjk(i, 321),i=1,2)/
     &  5.175127372677937D-04,
     &  3.584719706267024D-01, 3.584719706267024D-01/
      data wleb( 322),(gjk(i, 322),i=1,2)/
     &  5.285522262081019D-04,
     &  4.070135594428709D-01, 4.070135594428709D-01/
      data wleb( 323),(gjk(i, 323),i=1,2)/
     &  5.356832703713962D-04,
     &  4.536618626222638D-01, 4.536618626222638D-01/
      data wleb( 324),(gjk(i, 324),i=1,2)/
     &  5.397914736175170D-04,
     &  4.979195686463577D-01, 4.979195686463577D-01/
      data wleb( 325),(gjk(i, 325),i=1,2)/
     &  5.416899441599930D-04,
     &  5.393075111126999D-01, 5.393075111126999D-01/
      data wleb( 326),(gjk(i, 326),i=1,2)/
     &  5.419308476889938D-04,
     &  6.115617676843916D-01, 6.115617676843916D-01/
      data wleb( 327),(gjk(i, 327),i=1,2)/
     &  5.416936902030596D-04,
     &  6.414308435160159D-01, 6.414308435160159D-01/
      data wleb( 328),(gjk(i, 328),i=1,2)/
     &  5.419544338703164D-04,
     &  6.664099412721607D-01, 6.664099412721607D-01/
      data wleb( 329),(gjk(i, 329),i=1,2)/
     &  5.428983656630974D-04,
     &  6.859161771214913D-01, 6.859161771214913D-01/
      data wleb( 330),(gjk(i, 330),i=1,2)/
     &  5.442286500098193D-04,
     &  6.993625593503890D-01, 6.993625593503890D-01/
      data wleb( 331),(gjk(i, 331),i=1,2)/
     &  5.452250345057301D-04,
     &  7.062393387719380D-01, 7.062393387719380D-01/
      data wleb( 332),(gjk(i, 332),i=1,2)/
     &  2.568002497728530D-04,
     &  7.479028168349763D-02, 0.000000000000000D+00/
      data wleb( 333),(gjk(i, 333),i=1,2)/
     &  3.827211700292145D-04,
     &  1.848951153969366D-01, 0.000000000000000D+00/
      data wleb( 334),(gjk(i, 334),i=1,2)/
     &  4.579491561917824D-04,
     &  3.059529066581305D-01, 0.000000000000000D+00/
      data wleb( 335),(gjk(i, 335),i=1,2)/
     &  5.042003969083574D-04,
     &  4.285556101021362D-01, 0.000000000000000D+00/
      data wleb( 336),(gjk(i, 336),i=1,2)/
     &  5.312708889976024D-04,
     &  5.468758653496526D-01, 0.000000000000000D+00/
      data wleb( 337),(gjk(i, 337),i=1,2)/
     &  5.438401790747117D-04,
     &  6.565821978343439D-01, 0.000000000000000D+00/
      data wleb( 338),(gjk(i, 338),i=1,2)/
     &  3.316041873197344D-04,
     &  1.253901572367117D-01, 3.681917226439641D-02/
      data wleb( 339),(gjk(i, 339),i=1,2)/
     &  3.899113567153771D-04,
     &  1.775721510383941D-01, 7.982487607213301D-02/
      data wleb( 340),(gjk(i, 340),i=1,2)/
     &  4.343343327201309D-04,
     &  2.305693358216114D-01, 1.264640966592335D-01/
      data wleb( 341),(gjk(i, 341),i=1,2)/
     &  4.679415262318919D-04,
     &  2.836502845992063D-01, 1.751585683418957D-01/
      data wleb( 342),(gjk(i, 342),i=1,2)/
     &  4.930847981631031D-04,
     &  3.361794746232590D-01, 2.247995907632670D-01/
      data wleb( 343),(gjk(i, 343),i=1,2)/
     &  5.115031867540091D-04,
     &  3.875979172264824D-01, 2.745299257422246D-01/
      data wleb( 344),(gjk(i, 344),i=1,2)/
     &  5.245217148457367D-04,
     &  4.374019316999074D-01, 3.236373482441118D-01/
      data wleb( 345),(gjk(i, 345),i=1,2)/
     &  5.332041499895321D-04,
     &  4.851275843340022D-01, 3.714967859436741D-01/
      data wleb( 346),(gjk(i, 346),i=1,2)/
     &  5.384583126021542D-04,
     &  5.303391803806868D-01, 4.175353646321745D-01/
      data wleb( 347),(gjk(i, 347),i=1,2)/
     &  5.411067210798852D-04,
     &  5.726197380596287D-01, 4.612084406355461D-01/
      data wleb( 348),(gjk(i, 348),i=1,2)/
     &  4.259797391468714D-04,
     &  2.431520732564863D-01, 4.258040133043952D-02/
      data wleb( 349),(gjk(i, 349),i=1,2)/
     &  4.604931368460021D-04,
     &  3.002096800895869D-01, 8.869424306722722D-02/
      data wleb( 350),(gjk(i, 350),i=1,2)/
     &  4.871814878255202D-04,
     &  3.558554457457432D-01, 1.368811706510655D-01/
      data wleb( 351),(gjk(i, 351),i=1,2)/
     &  5.072242910074885D-04,
     &  4.097782537048887D-01, 1.860739985015033D-01/
      data wleb( 352),(gjk(i, 352),i=1,2)/
     &  5.217069845235350D-04,
     &  4.616337666067458D-01, 2.354235077395853D-01/
      data wleb( 353),(gjk(i, 353),i=1,2)/
     &  5.315785966280310D-04,
     &  5.110707008417874D-01, 2.842074921347011D-01/
      data wleb( 354),(gjk(i, 354),i=1,2)/
     &  5.376833708758905D-04,
     &  5.577415286163795D-01, 3.317784414984102D-01/
      data wleb( 355),(gjk(i, 355),i=1,2)/
     &  5.408032092069521D-04,
     &  6.013060431366950D-01, 3.775299002040700D-01/
      data wleb( 356),(gjk(i, 356),i=1,2)/
     &  4.842744917904866D-04,
     &  3.661596767261781D-01, 4.599367887164592D-02/
      data wleb( 357),(gjk(i, 357),i=1,2)/
     &  5.048926076188130D-04,
     &  4.237633153506581D-01, 9.404893773654421D-02/
      data wleb( 358),(gjk(i, 358),i=1,2)/
     &  5.202607980478373D-04,
     &  4.786328454658452D-01, 1.431377109091971D-01/
      data wleb( 359),(gjk(i, 359),i=1,2)/
     &  5.309932388325743D-04,
     &  5.305702076789774D-01, 1.924186388843570D-01/
      data wleb( 360),(gjk(i, 360),i=1,2)/
     &  5.377419770895208D-04,
     &  5.793436224231788D-01, 2.411590944775190D-01/
      data wleb( 361),(gjk(i, 361),i=1,2)/
     &  5.411696331677717D-04,
     &  6.247069017094747D-01, 2.886871491583605D-01/
      data wleb( 362),(gjk(i, 362),i=1,2)/
     &  5.197996293282420D-04,
     &  4.874315552535204D-01, 4.804978774953206D-02/
      data wleb( 363),(gjk(i, 363),i=1,2)/
     &  5.311120836622945D-04,
     &  5.427337322059053D-01, 9.716857199366664D-02/
      data wleb( 364),(gjk(i, 364),i=1,2)/
     &  5.384309319956951D-04,
     &  5.943493747246700D-01, 1.465205839795055D-01/
      data wleb( 365),(gjk(i, 365),i=1,2)/
     &  5.421859504051886D-04,
     &  6.421314033564943D-01, 1.953579449803574D-01/
      data wleb( 366),(gjk(i, 366),i=1,2)/
     &  5.390948355046314D-04,
     &  6.020628374713980D-01, 4.916375015738108D-02/
      data wleb( 367),(gjk(i, 367),i=1,2)/
     &  5.433312705027845D-04,
     &  6.529222529856881D-01, 9.861621540127005D-02/
C
C   n =  83
C
      data wleb( 368),(gjk(i, 368),i=1,2)/
     &  3.922616270665292D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 369),(gjk(i, 369),i=1,2)/
     &  4.703831750854424D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 370),(gjk(i, 370),i=1,2)/
     &  4.678202801282136D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 371),(gjk(i, 371),i=1,2)/
     &  1.437832228979900D-04,
     &  2.290024646530589D-02, 2.290024646530589D-02/
      data wleb( 372),(gjk(i, 372),i=1,2)/
     &  2.303572493577644D-04,
     &  5.779086652271284D-02, 5.779086652271284D-02/
      data wleb( 373),(gjk(i, 373),i=1,2)/
     &  2.933110752447454D-04,
     &  9.863103576375984D-02, 9.863103576375984D-02/
      data wleb( 374),(gjk(i, 374),i=1,2)/
     &  3.402905998359838D-04,
     &  1.428155792982185D-01, 1.428155792982185D-01/
      data wleb( 375),(gjk(i, 375),i=1,2)/
     &  3.759138466870372D-04,
     &  1.888978116601463D-01, 1.888978116601463D-01/
      data wleb( 376),(gjk(i, 376),i=1,2)/
     &  4.030638447899798D-04,
     &  2.359091682970210D-01, 2.359091682970210D-01/
      data wleb( 377),(gjk(i, 377),i=1,2)/
     &  4.236591432242211D-04,
     &  2.831228833706171D-01, 2.831228833706171D-01/
      data wleb( 378),(gjk(i, 378),i=1,2)/
     &  4.390522656946746D-04,
     &  3.299495857966693D-01, 3.299495857966693D-01/
      data wleb( 379),(gjk(i, 379),i=1,2)/
     &  4.502523466626247D-04,
     &  3.758840802660796D-01, 3.758840802660796D-01/
      data wleb( 380),(gjk(i, 380),i=1,2)/
     &  4.580577727783541D-04,
     &  4.204751831009480D-01, 4.204751831009480D-01/
      data wleb( 381),(gjk(i, 381),i=1,2)/
     &  4.631391616615899D-04,
     &  4.633068518751051D-01, 4.633068518751051D-01/
      data wleb( 382),(gjk(i, 382),i=1,2)/
     &  4.660928953698676D-04,
     &  5.039849474507313D-01, 5.039849474507313D-01/
      data wleb( 383),(gjk(i, 383),i=1,2)/
     &  4.674751807936953D-04,
     &  5.421265793440747D-01, 5.421265793440747D-01/
      data wleb( 384),(gjk(i, 384),i=1,2)/
     &  4.676414903932920D-04,
     &  6.092660230557310D-01, 6.092660230557310D-01/
      data wleb( 385),(gjk(i, 385),i=1,2)/
     &  4.674086492347870D-04,
     &  6.374654204984869D-01, 6.374654204984869D-01/
      data wleb( 386),(gjk(i, 386),i=1,2)/
     &  4.674928539483207D-04,
     &  6.615136472609892D-01, 6.615136472609892D-01/
      data wleb( 387),(gjk(i, 387),i=1,2)/
     &  4.680748979686447D-04,
     &  6.809487285958127D-01, 6.809487285958127D-01/
      data wleb( 388),(gjk(i, 388),i=1,2)/
     &  4.690449806389040D-04,
     &  6.952980021665196D-01, 6.952980021665196D-01/
      data wleb( 389),(gjk(i, 389),i=1,2)/
     &  4.699877075860818D-04,
     &  7.041245497695400D-01, 7.041245497695400D-01/
      data wleb( 390),(gjk(i, 390),i=1,2)/
     &  2.099942281069176D-04,
     &  6.744033088306065D-02, 0.000000000000000D+00/
      data wleb( 391),(gjk(i, 391),i=1,2)/
     &  3.172269150712804D-04,
     &  1.678684485334166D-01, 0.000000000000000D+00/
      data wleb( 392),(gjk(i, 392),i=1,2)/
     &  3.832051358546523D-04,
     &  2.793559049539613D-01, 0.000000000000000D+00/
      data wleb( 393),(gjk(i, 393),i=1,2)/
     &  4.252193818146985D-04,
     &  3.935264218057639D-01, 0.000000000000000D+00/
      data wleb( 394),(gjk(i, 394),i=1,2)/
     &  4.513807963755000D-04,
     &  5.052629268232558D-01, 0.000000000000000D+00/
      data wleb( 395),(gjk(i, 395),i=1,2)/
     &  4.657797469114178D-04,
     &  6.107905315437531D-01, 0.000000000000000D+00/
      data wleb( 396),(gjk(i, 396),i=1,2)/
     &  2.733362800522836D-04,
     &  1.135081039843524D-01, 3.331954884662588D-02/
      data wleb( 397),(gjk(i, 397),i=1,2)/
     &  3.235485368463559D-04,
     &  1.612866626099378D-01, 7.247167465436538D-02/
      data wleb( 398),(gjk(i, 398),i=1,2)/
     &  3.624908726013453D-04,
     &  2.100786550168205D-01, 1.151539110849745D-01/
      data wleb( 399),(gjk(i, 399),i=1,2)/
     &  3.925540070712828D-04,
     &  2.592282009459942D-01, 1.599491097143677D-01/
      data wleb( 400),(gjk(i, 400),i=1,2)/
     &  4.156129781116235D-04,
     &  3.081740561320203D-01, 2.058699956028027D-01/
      data wleb( 401),(gjk(i, 401),i=1,2)/
     &  4.330644984623263D-04,
     &  3.564289781578164D-01, 2.521624953502911D-01/
      data wleb( 402),(gjk(i, 402),i=1,2)/
     &  4.459677725921312D-04,
     &  4.035587288240703D-01, 2.982090785797674D-01/
      data wleb( 403),(gjk(i, 403),i=1,2)/
     &  4.551593004456795D-04,
     &  4.491671196373903D-01, 3.434762087235733D-01/
      data wleb( 404),(gjk(i, 404),i=1,2)/
     &  4.613341462749918D-04,
     &  4.928854782917489D-01, 3.874831357203437D-01/
      data wleb( 405),(gjk(i, 405),i=1,2)/
     &  4.651019618269806D-04,
     &  5.343646791958988D-01, 4.297814821746926D-01/
      data wleb( 406),(gjk(i, 406),i=1,2)/
     &  4.670249536100625D-04,
     &  5.732683216530990D-01, 4.699402260943537D-01/
      data wleb( 407),(gjk(i, 407),i=1,2)/
     &  3.549555576441708D-04,
     &  2.214131583218986D-01, 3.873602040643895D-02/
      data wleb( 408),(gjk(i, 408),i=1,2)/
     &  3.856108245249010D-04,
     &  2.741796504750071D-01, 8.089496256902012D-02/
      data wleb( 409),(gjk(i, 409),i=1,2)/
     &  4.098622845756882D-04,
     &  3.259797439149485D-01, 1.251732177620872D-01/
      data wleb( 410),(gjk(i, 410),i=1,2)/
     &  4.286328604268950D-04,
     &  3.765441148826891D-01, 1.706260286403185D-01/
      data wleb( 411),(gjk(i, 411),i=1,2)/
     &  4.427802198993945D-04,
     &  4.255773574530558D-01, 2.165115147300408D-01/
      data wleb( 412),(gjk(i, 412),i=1,2)/
     &  4.530473511488561D-04,
     &  4.727795117058430D-01, 2.622089812225259D-01/
      data wleb( 413),(gjk(i, 413),i=1,2)/
     &  4.600805475703138D-04,
     &  5.178546895819012D-01, 3.071721431296201D-01/
      data wleb( 414),(gjk(i, 414),i=1,2)/
     &  4.644599059958017D-04,
     &  5.605141192097460D-01, 3.508998998801138D-01/
      data wleb( 415),(gjk(i, 415),i=1,2)/
     &  4.667274455712508D-04,
     &  6.004763319352512D-01, 3.929160876166931D-01/
      data wleb( 416),(gjk(i, 416),i=1,2)/
     &  4.069360518020356D-04,
     &  3.352842634946949D-01, 4.202563457288019D-02/
      data wleb( 417),(gjk(i, 417),i=1,2)/
     &  4.260442819919195D-04,
     &  3.891971629814670D-01, 8.614309758870850D-02/
      data wleb( 418),(gjk(i, 418),i=1,2)/
     &  4.408678508029063D-04,
     &  4.409875565542281D-01, 1.314500879380001D-01/
      data wleb( 419),(gjk(i, 419),i=1,2)/
     &  4.518748115548597D-04,
     &  4.904893058592484D-01, 1.772189657383859D-01/
      data wleb( 420),(gjk(i, 420),i=1,2)/
     &  4.595564875375116D-04,
     &  5.375056138769549D-01, 2.228277110050294D-01/
      data wleb( 421),(gjk(i, 421),i=1,2)/
     &  4.643988774315846D-04,
     &  5.818255708669969D-01, 2.677179935014386D-01/
      data wleb( 422),(gjk(i, 422),i=1,2)/
     &  4.668827491646946D-04,
     &  6.232334858144959D-01, 3.113675035544165D-01/
      data wleb( 423),(gjk(i, 423),i=1,2)/
     &  4.400541823741973D-04,
     &  4.489485354492058D-01, 4.409162378368174D-02/
      data wleb( 424),(gjk(i, 424),i=1,2)/
     &  4.514512890193797D-04,
     &  5.015136875933150D-01, 8.939009917748489D-02/
      data wleb( 425),(gjk(i, 425),i=1,2)/
     &  4.596198627347549D-04,
     &  5.511300550512623D-01, 1.351806029383365D-01/
      data wleb( 426),(gjk(i, 426),i=1,2)/
     &  4.648659016801781D-04,
     &  5.976720409858000D-01, 1.808370355053196D-01/
      data wleb( 427),(gjk(i, 427),i=1,2)/
     &  4.675502017157673D-04,
     &  6.409956378989354D-01, 2.257852192301602D-01/
      data wleb( 428),(gjk(i, 428),i=1,2)/
     &  4.598494476455523D-04,
     &  5.581222330827514D-01, 4.532173421637160D-02/
      data wleb( 429),(gjk(i, 429),i=1,2)/
     &  4.654916955152048D-04,
     &  6.074705984161695D-01, 9.117488031840314D-02/
      data wleb( 430),(gjk(i, 430),i=1,2)/
     &  4.684709779505137D-04,
     &  6.532272537379032D-01, 1.369294213140155D-01/
      data wleb( 431),(gjk(i, 431),i=1,2)/
     &  4.691445539106986D-04,
     &  6.594761494500487D-01, 4.589901487275583D-02/
C
C   n =  89
C
      data wleb( 432),(gjk(i, 432),i=1,2)/
     &  2.998675149888161D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 433),(gjk(i, 433),i=1,2)/
     &  4.077860529495355D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 434),(gjk(i, 434),i=1,2)/
     &  1.185349192520667D-04,
     &  2.065562538818703D-02, 2.065562538818703D-02/
      data wleb( 435),(gjk(i, 435),i=1,2)/
     &  1.913408643425751D-04,
     &  5.250918173022379D-02, 5.250918173022379D-02/
      data wleb( 436),(gjk(i, 436),i=1,2)/
     &  2.452886577209897D-04,
     &  8.993480082038376D-02, 8.993480082038376D-02/
      data wleb( 437),(gjk(i, 437),i=1,2)/
     &  2.862408183288702D-04,
     &  1.306023924436019D-01, 1.306023924436019D-01/
      data wleb( 438),(gjk(i, 438),i=1,2)/
     &  3.178032258257357D-04,
     &  1.732060388531418D-01, 1.732060388531418D-01/
      data wleb( 439),(gjk(i, 439),i=1,2)/
     &  3.422945667633690D-04,
     &  2.168727084820249D-01, 2.168727084820249D-01/
      data wleb( 440),(gjk(i, 440),i=1,2)/
     &  3.612790520235922D-04,
     &  2.609528309173586D-01, 2.609528309173586D-01/
      data wleb( 441),(gjk(i, 441),i=1,2)/
     &  3.758638229818521D-04,
     &  3.049252927938952D-01, 3.049252927938952D-01/
      data wleb( 442),(gjk(i, 442),i=1,2)/
     &  3.868711798859953D-04,
     &  3.483484138084404D-01, 3.483484138084404D-01/
      data wleb( 443),(gjk(i, 443),i=1,2)/
     &  3.949429933189938D-04,
     &  3.908321549106406D-01, 3.908321549106406D-01/
      data wleb( 444),(gjk(i, 444),i=1,2)/
     &  4.006068107541156D-04,
     &  4.320210071894814D-01, 4.320210071894814D-01/
      data wleb( 445),(gjk(i, 445),i=1,2)/
     &  4.043192149672723D-04,
     &  4.715824795890053D-01, 4.715824795890053D-01/
      data wleb( 446),(gjk(i, 446),i=1,2)/
     &  4.064947495808078D-04,
     &  5.091984794078454D-01, 5.091984794078454D-01/
      data wleb( 447),(gjk(i, 447),i=1,2)/
     &  4.075245619813152D-04,
     &  5.445580145650804D-01, 5.445580145650804D-01/
      data wleb( 448),(gjk(i, 448),i=1,2)/
     &  4.076423540893566D-04,
     &  6.072575796841768D-01, 6.072575796841768D-01/
      data wleb( 449),(gjk(i, 449),i=1,2)/
     &  4.074280862251555D-04,
     &  6.339484505755802D-01, 6.339484505755802D-01/
      data wleb( 450),(gjk(i, 450),i=1,2)/
     &  4.074163756012244D-04,
     &  6.570718257486958D-01, 6.570718257486958D-01/
      data wleb( 451),(gjk(i, 451),i=1,2)/
     &  4.077647795071246D-04,
     &  6.762557330090709D-01, 6.762557330090709D-01/
      data wleb( 452),(gjk(i, 452),i=1,2)/
     &  4.084517552782530D-04,
     &  6.911161696923790D-01, 6.911161696923790D-01/
      data wleb( 453),(gjk(i, 453),i=1,2)/
     &  4.092468459224052D-04,
     &  7.012841911659961D-01, 7.012841911659961D-01/
      data wleb( 454),(gjk(i, 454),i=1,2)/
     &  4.097872687240906D-04,
     &  7.064559272410020D-01, 7.064559272410020D-01/
      data wleb( 455),(gjk(i, 455),i=1,2)/
     &  1.738986811745028D-04,
     &  6.123554989894765D-02, 0.000000000000000D+00/
      data wleb( 456),(gjk(i, 456),i=1,2)/
     &  2.659616045280191D-04,
     &  1.533070348312393D-01, 0.000000000000000D+00/
      data wleb( 457),(gjk(i, 457),i=1,2)/
     &  3.240596008171533D-04,
     &  2.563902605244206D-01, 0.000000000000000D+00/
      data wleb( 458),(gjk(i, 458),i=1,2)/
     &  3.621195964432943D-04,
     &  3.629346991663361D-01, 0.000000000000000D+00/
      data wleb( 459),(gjk(i, 459),i=1,2)/
     &  3.868838330760539D-04,
     &  4.683949968987538D-01, 0.000000000000000D+00/
      data wleb( 460),(gjk(i, 460),i=1,2)/
     &  4.018911532693111D-04,
     &  5.694479240657953D-01, 0.000000000000000D+00/
      data wleb( 461),(gjk(i, 461),i=1,2)/
     &  4.089929432983252D-04,
     &  6.634465430993955D-01, 0.000000000000000D+00/
      data wleb( 462),(gjk(i, 462),i=1,2)/
     &  2.279907527706409D-04,
     &  1.033958573552305D-01, 3.034544009063584D-02/
      data wleb( 463),(gjk(i, 463),i=1,2)/
     &  2.715205490578897D-04,
     &  1.473521412414395D-01, 6.618803044247135D-02/
      data wleb( 464),(gjk(i, 464),i=1,2)/
     &  3.057917896703976D-04,
     &  1.924552158705967D-01, 1.054431128987715D-01/
      data wleb( 465),(gjk(i, 465),i=1,2)/
     &  3.326913052452555D-04,
     &  2.381094362890328D-01, 1.468263551238858D-01/
      data wleb( 466),(gjk(i, 466),i=1,2)/
     &  3.537334711890037D-04,
     &  2.838121707936760D-01, 1.894486108187886D-01/
      data wleb( 467),(gjk(i, 467),i=1,2)/
     &  3.700567500783129D-04,
     &  3.291323133373415D-01, 2.326374238761579D-01/
      data wleb( 468),(gjk(i, 468),i=1,2)/
     &  3.825245372589122D-04,
     &  3.736896978741460D-01, 2.758485808485768D-01/
      data wleb( 469),(gjk(i, 469),i=1,2)/
     &  3.918125171518296D-04,
     &  4.171406040760013D-01, 3.186179331996921D-01/
      data wleb( 470),(gjk(i, 470),i=1,2)/
     &  3.984720419937579D-04,
     &  4.591677985256915D-01, 3.605329796303794D-01/
      data wleb( 471),(gjk(i, 471),i=1,2)/
     &  4.029746003338211D-04,
     &  4.994733831718418D-01, 4.012147253586509D-01/
      data wleb( 472),(gjk(i, 472),i=1,2)/
     &  4.057428632156627D-04,
     &  5.377731830445096D-01, 4.403050025570692D-01/
      data wleb( 473),(gjk(i, 473),i=1,2)/
     &  4.071719274114857D-04,
     &  5.737917830001331D-01, 4.774565904277483D-01/
      data wleb( 474),(gjk(i, 474),i=1,2)/
     &  2.990236950664119D-04,
     &  2.027323586271389D-01, 3.544122504976147D-02/
      data wleb( 475),(gjk(i, 475),i=1,2)/
     &  3.262951734212878D-04,
     &  2.516942375187273D-01, 7.418304388646328D-02/
      data wleb( 476),(gjk(i, 476),i=1,2)/
     &  3.482634608242413D-04,
     &  3.000227995257181D-01, 1.150502745727186D-01/
      data wleb( 477),(gjk(i, 477),i=1,2)/
     &  3.656596681700892D-04,
     &  3.474806691046342D-01, 1.571963371209364D-01/
      data wleb( 478),(gjk(i, 478),i=1,2)/
     &  3.791740467794218D-04,
     &  3.938103180359209D-01, 1.999631877247100D-01/
      data wleb( 479),(gjk(i, 479),i=1,2)/
     &  3.894034450156905D-04,
     &  4.387519590455703D-01, 2.428073457846535D-01/
      data wleb( 480),(gjk(i, 480),i=1,2)/
     &  3.968600245508371D-04,
     &  4.820503960077787D-01, 2.852575132906155D-01/
      data wleb( 481),(gjk(i, 481),i=1,2)/
     &  4.019931351420050D-04,
     &  5.234573778475101D-01, 3.268884208674639D-01/
      data wleb( 482),(gjk(i, 482),i=1,2)/
     &  4.052108801278599D-04,
     &  5.627318647235282D-01, 3.673033321675939D-01/
      data wleb( 483),(gjk(i, 483),i=1,2)/
     &  4.068978613940934D-04,
     &  5.996390607156954D-01, 4.061211551830290D-01/
      data wleb( 484),(gjk(i, 484),i=1,2)/
     &  3.454275351319704D-04,
     &  3.084780753791947D-01, 3.860125523100059D-02/
      data wleb( 485),(gjk(i, 485),i=1,2)/
     &  3.629963537007920D-04,
     &  3.589988275920223D-01, 7.928938987104867D-02/
      data wleb( 486),(gjk(i, 486),i=1,2)/
     &  3.770187233889873D-04,
     &  4.078628415881973D-01, 1.212614643030087D-01/
      data wleb( 487),(gjk(i, 487),i=1,2)/
     &  3.878608613694378D-04,
     &  4.549287258889735D-01, 1.638770827382693D-01/
      data wleb( 488),(gjk(i, 488),i=1,2)/
     &  3.959065270221274D-04,
     &  5.000278512957279D-01, 2.065965798260176D-01/
      data wleb( 489),(gjk(i, 489),i=1,2)/
     &  4.015286975463570D-04,
     &  5.429785044928199D-01, 2.489436378852235D-01/
      data wleb( 490),(gjk(i, 490),i=1,2)/
     &  4.050866785614717D-04,
     &  5.835939850491711D-01, 2.904811368946891D-01/
      data wleb( 491),(gjk(i, 491),i=1,2)/
     &  4.069320185051913D-04,
     &  6.216870353444856D-01, 3.307941957666609D-01/
      data wleb( 492),(gjk(i, 492),i=1,2)/
     &  3.760120964062763D-04,
     &  4.151104662709091D-01, 4.064829146052554D-02/
      data wleb( 493),(gjk(i, 493),i=1,2)/
     &  3.870969564418064D-04,
     &  4.649804275009218D-01, 8.258424547294756D-02/
      data wleb( 494),(gjk(i, 494),i=1,2)/
     &  3.955287790534055D-04,
     &  5.124695757009662D-01, 1.251841962027289D-01/
      data wleb( 495),(gjk(i, 495),i=1,2)/
     &  4.015361911302668D-04,
     &  5.574711100606224D-01, 1.679107505976331D-01/
      data wleb( 496),(gjk(i, 496),i=1,2)/
     &  4.053836986719548D-04,
     &  5.998597333287227D-01, 2.102805057358715D-01/
      data wleb( 497),(gjk(i, 497),i=1,2)/
     &  4.073578673299117D-04,
     &  6.395007148516600D-01, 2.518418087774107D-01/
      data wleb( 498),(gjk(i, 498),i=1,2)/
     &  3.954628379231406D-04,
     &  5.188456224746252D-01, 4.194321676077518D-02/
      data wleb( 499),(gjk(i, 499),i=1,2)/
     &  4.017645508847530D-04,
     &  5.664190707942778D-01, 8.457661551921498D-02/
      data wleb( 500),(gjk(i, 500),i=1,2)/
     &  4.059030348651293D-04,
     &  6.110464353283153D-01, 1.273652932519396D-01/
      data wleb( 501),(gjk(i, 501),i=1,2)/
     &  4.080565809484880D-04,
     &  6.526430302051563D-01, 1.698173239076354D-01/
      data wleb( 502),(gjk(i, 502),i=1,2)/
     &  4.063018753664651D-04,
     &  6.167551880377548D-01, 4.266398851548864D-02/
      data wleb( 503),(gjk(i, 503),i=1,2)/
     &  4.087191292799671D-04,
     &  6.607195418355383D-01, 8.551925814238349D-02/
C
C   n =  95
C
      data wleb( 504),(gjk(i, 504),i=1,2)/
     &  2.599095953754734D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 505),(gjk(i, 505),i=1,2)/
     &  3.603134089687541D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 506),(gjk(i, 506),i=1,2)/
     &  3.586067974412447D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 507),(gjk(i, 507),i=1,2)/
     &  9.831528474385880D-05,
     &  1.886108518723392D-02, 1.886108518723392D-02/
      data wleb( 508),(gjk(i, 508),i=1,2)/
     &  1.605023107954450D-04,
     &  4.800217244625303D-02, 4.800217244625303D-02/
      data wleb( 509),(gjk(i, 509),i=1,2)/
     &  2.072200131464099D-04,
     &  8.244922058397242D-02, 8.244922058397242D-02/
      data wleb( 510),(gjk(i, 510),i=1,2)/
     &  2.431297618814187D-04,
     &  1.200408362484023D-01, 1.200408362484023D-01/
      data wleb( 511),(gjk(i, 511),i=1,2)/
     &  2.711819064496707D-04,
     &  1.595773530809965D-01, 1.595773530809965D-01/
      data wleb( 512),(gjk(i, 512),i=1,2)/
     &  2.932762038321116D-04,
     &  2.002635973434064D-01, 2.002635973434064D-01/
      data wleb( 513),(gjk(i, 513),i=1,2)/
     &  3.107032514197368D-04,
     &  2.415127590139982D-01, 2.415127590139982D-01/
      data wleb( 514),(gjk(i, 514),i=1,2)/
     &  3.243808058921213D-04,
     &  2.828584158458477D-01, 2.828584158458477D-01/
      data wleb( 515),(gjk(i, 515),i=1,2)/
     &  3.349899091374030D-04,
     &  3.239091015338138D-01, 3.239091015338138D-01/
      data wleb( 516),(gjk(i, 516),i=1,2)/
     &  3.430580688505218D-04,
     &  3.643225097962194D-01, 3.643225097962194D-01/
      data wleb( 517),(gjk(i, 517),i=1,2)/
     &  3.490124109290343D-04,
     &  4.037897083691802D-01, 4.037897083691802D-01/
      data wleb( 518),(gjk(i, 518),i=1,2)/
     &  3.532148948561955D-04,
     &  4.420247515194127D-01, 4.420247515194127D-01/
      data wleb( 519),(gjk(i, 519),i=1,2)/
     &  3.559862669062833D-04,
     &  4.787572538464938D-01, 4.787572538464938D-01/
      data wleb( 520),(gjk(i, 520),i=1,2)/
     &  3.576224317551411D-04,
     &  5.137265251275234D-01, 5.137265251275234D-01/
      data wleb( 521),(gjk(i, 521),i=1,2)/
     &  3.584050533086076D-04,
     &  5.466764056654611D-01, 5.466764056654611D-01/
      data wleb( 522),(gjk(i, 522),i=1,2)/
     &  3.584903581373224D-04,
     &  6.054859420813535D-01, 6.054859420813535D-01/
      data wleb( 523),(gjk(i, 523),i=1,2)/
     &  3.582991879040586D-04,
     &  6.308106701764562D-01, 6.308106701764562D-01/
      data wleb( 524),(gjk(i, 524),i=1,2)/
     &  3.582371187963125D-04,
     &  6.530369230179583D-01, 6.530369230179583D-01/
      data wleb( 525),(gjk(i, 525),i=1,2)/
     &  3.584353631122350D-04,
     &  6.718609524611158D-01, 6.718609524611158D-01/
      data wleb( 526),(gjk(i, 526),i=1,2)/
     &  3.589120166517785D-04,
     &  6.869676499894013D-01, 6.869676499894013D-01/
      data wleb( 527),(gjk(i, 527),i=1,2)/
     &  3.595445704531601D-04,
     &  6.980467077240748D-01, 6.980467077240748D-01/
      data wleb( 528),(gjk(i, 528),i=1,2)/
     &  3.600943557111074D-04,
     &  7.048241721250522D-01, 7.048241721250522D-01/
      data wleb( 529),(gjk(i, 529),i=1,2)/
     &  1.456447096742039D-04,
     &  5.591105222058232D-02, 0.000000000000000D+00/
      data wleb( 530),(gjk(i, 530),i=1,2)/
     &  2.252370188283782D-04,
     &  1.407384078513916D-01, 0.000000000000000D+00/
      data wleb( 531),(gjk(i, 531),i=1,2)/
     &  2.766135443474897D-04,
     &  2.364035438976309D-01, 0.000000000000000D+00/
      data wleb( 532),(gjk(i, 532),i=1,2)/
     &  3.110729491500851D-04,
     &  3.360602737818170D-01, 0.000000000000000D+00/
      data wleb( 533),(gjk(i, 533),i=1,2)/
     &  3.342506712303391D-04,
     &  4.356292630054665D-01, 0.000000000000000D+00/
      data wleb( 534),(gjk(i, 534),i=1,2)/
     &  3.491981834026860D-04,
     &  5.321569415256174D-01, 0.000000000000000D+00/
      data wleb( 535),(gjk(i, 535),i=1,2)/
     &  3.576003604348932D-04,
     &  6.232956305040555D-01, 0.000000000000000D+00/
      data wleb( 536),(gjk(i, 536),i=1,2)/
     &  1.921921305788564D-04,
     &  9.469870086838469D-02, 2.778748387309470D-02/
      data wleb( 537),(gjk(i, 537),i=1,2)/
     &  2.301458216495632D-04,
     &  1.353170300568141D-01, 6.076569878628364D-02/
      data wleb( 538),(gjk(i, 538),i=1,2)/
     &  2.604248549522893D-04,
     &  1.771679481726077D-01, 9.703072762711040D-02/
      data wleb( 539),(gjk(i, 539),i=1,2)/
     &  2.845275425870697D-04,
     &  2.197066664231751D-01, 1.354112458524762D-01/
      data wleb( 540),(gjk(i, 540),i=1,2)/
     &  3.036870897974840D-04,
     &  2.624783557374927D-01, 1.750996479744100D-01/
      data wleb( 541),(gjk(i, 541),i=1,2)/
     &  3.188414832298066D-04,
     &  3.050969521214442D-01, 2.154896907449802D-01/
      data wleb( 542),(gjk(i, 542),i=1,2)/
     &  3.307046414722089D-04,
     &  3.472252637196021D-01, 2.560954625740152D-01/
      data wleb( 543),(gjk(i, 543),i=1,2)/
     &  3.398330969031360D-04,
     &  3.885610219026360D-01, 2.965070050624096D-01/
      data wleb( 544),(gjk(i, 544),i=1,2)/
     &  3.466757899705373D-04,
     &  4.288273776062765D-01, 3.363641488734497D-01/
      data wleb( 545),(gjk(i, 545),i=1,2)/
     &  3.516095923230054D-04,
     &  4.677662471302948D-01, 3.753400029836788D-01/
      data wleb( 546),(gjk(i, 546),i=1,2)/
     &  3.549645184048486D-04,
     &  5.051333589553360D-01, 4.131297522144286D-01/
      data wleb( 547),(gjk(i, 547),i=1,2)/
     &  3.570415969441392D-04,
     &  5.406942145810492D-01, 4.494423776081795D-01/
      data wleb( 548),(gjk(i, 548),i=1,2)/
     &  3.581251798496118D-04,
     &  5.742204122576458D-01, 4.839938958841502D-01/
      data wleb( 549),(gjk(i, 549),i=1,2)/
     &  2.543491329913348D-04,
     &  1.865407027225188D-01, 3.259144851070796D-02/
      data wleb( 550),(gjk(i, 550),i=1,2)/
     &  2.786711051330776D-04,
     &  2.321186453689432D-01, 6.835679505297343D-02/
      data wleb( 551),(gjk(i, 551),i=1,2)/
     &  2.985552361083679D-04,
     &  2.773159142523882D-01, 1.062284864451989D-01/
      data wleb( 552),(gjk(i, 552),i=1,2)/
     &  3.145867929154039D-04,
     &  3.219200192237254D-01, 1.454404409323047D-01/
      data wleb( 553),(gjk(i, 553),i=1,2)/
     &  3.273290662067609D-04,
     &  3.657032593944029D-01, 1.854018282582510D-01/
      data wleb( 554),(gjk(i, 554),i=1,2)/
     &  3.372705511943501D-04,
     &  4.084376778363622D-01, 2.256297412014750D-01/
      data wleb( 555),(gjk(i, 555),i=1,2)/
     &  3.448274437851510D-04,
     &  4.499004945751427D-01, 2.657104425000896D-01/
      data wleb( 556),(gjk(i, 556),i=1,2)/
     &  3.503592783048583D-04,
     &  4.898758141326335D-01, 3.052755487631557D-01/
      data wleb( 557),(gjk(i, 557),i=1,2)/
     &  3.541854792663162D-04,
     &  5.281547442266309D-01, 3.439863920645423D-01/
      data wleb( 558),(gjk(i, 558),i=1,2)/
     &  3.565995517909428D-04,
     &  5.645346989813992D-01, 3.815229456121914D-01/
      data wleb( 559),(gjk(i, 559),i=1,2)/
     &  3.578802078302898D-04,
     &  5.988181252159848D-01, 4.175752420966734D-01/
      data wleb( 560),(gjk(i, 560),i=1,2)/
     &  2.958644592860982D-04,
     &  2.850425424471603D-01, 3.562149509862536D-02/
      data wleb( 561),(gjk(i, 561),i=1,2)/
     &  3.119548129116835D-04,
     &  3.324619433027876D-01, 7.330318886871096D-02/
      data wleb( 562),(gjk(i, 562),i=1,2)/
     &  3.250745225005984D-04,
     &  3.785848333076282D-01, 1.123226296008472D-01/
      data wleb( 563),(gjk(i, 563),i=1,2)/
     &  3.355153415935208D-04,
     &  4.232891028562115D-01, 1.521084193337708D-01/
      data wleb( 564),(gjk(i, 564),i=1,2)/
     &  3.435847568549328D-04,
     &  4.664287050829722D-01, 1.921844459223610D-01/
      data wleb( 565),(gjk(i, 565),i=1,2)/
     &  3.495786831622488D-04,
     &  5.078458493735726D-01, 2.321360989678303D-01/
      data wleb( 566),(gjk(i, 566),i=1,2)/
     &  3.537767805534621D-04,
     &  5.473779816204180D-01, 2.715886486360520D-01/
      data wleb( 567),(gjk(i, 567),i=1,2)/
     &  3.564459815421428D-04,
     &  5.848617133811376D-01, 3.101924707571355D-01/
      data wleb( 568),(gjk(i, 568),i=1,2)/
     &  3.578464061225468D-04,
     &  6.201348281584887D-01, 3.476121052890973D-01/
      data wleb( 569),(gjk(i, 569),i=1,2)/
     &  3.239748762836212D-04,
     &  3.852191185387871D-01, 3.763224880035108D-02/
      data wleb( 570),(gjk(i, 570),i=1,2)/
     &  3.345491784174287D-04,
     &  4.325025061073423D-01, 7.659581935637134D-02/
      data wleb( 571),(gjk(i, 571),i=1,2)/
     &  3.429126177301782D-04,
     &  4.778486229734490D-01, 1.163381306083900D-01/
      data wleb( 572),(gjk(i, 572),i=1,2)/
     &  3.492420343097421D-04,
     &  5.211663693009000D-01, 1.563890598752899D-01/
      data wleb( 573),(gjk(i, 573),i=1,2)/
     &  3.537399050235257D-04,
     &  5.623469504853703D-01, 1.963320810149200D-01/
      data wleb( 574),(gjk(i, 574),i=1,2)/
     &  3.566209152659172D-04,
     &  6.012718188659246D-01, 2.357847407258738D-01/
      data wleb( 575),(gjk(i, 575),i=1,2)/
     &  3.581084321919782D-04,
     &  6.378179206390117D-01, 2.743846121244060D-01/
      data wleb( 576),(gjk(i, 576),i=1,2)/
     &  3.426522117591512D-04,
     &  4.836936460214534D-01, 3.895902610739024D-02/
      data wleb( 577),(gjk(i, 577),i=1,2)/
     &  3.491848770121379D-04,
     &  5.293792562683797D-01, 7.871246819312640D-02/
      data wleb( 578),(gjk(i, 578),i=1,2)/
     &  3.539318235231476D-04,
     &  5.726281253100033D-01, 1.187963808202981D-01/
      data wleb( 579),(gjk(i, 579),i=1,2)/
     &  3.570231438458694D-04,
     &  6.133658776169068D-01, 1.587914708061787D-01/
      data wleb( 580),(gjk(i, 580),i=1,2)/
     &  3.586207335051714D-04,
     &  6.515085491865307D-01, 1.983058575227646D-01/
      data wleb( 581),(gjk(i, 581),i=1,2)/
     &  3.541196205164025D-04,
     &  5.778692716064976D-01, 3.977209689791542D-02/
      data wleb( 582),(gjk(i, 582),i=1,2)/
     &  3.574296911573953D-04,
     &  6.207904288086192D-01, 7.990157592981152D-02/
      data wleb( 583),(gjk(i, 583),i=1,2)/
     &  3.591993279818963D-04,
     &  6.608688171046802D-01, 1.199671308754309D-01/
      data wleb( 584),(gjk(i, 584),i=1,2)/
     &  3.595855034661997D-04,
     &  6.656263089489129D-01, 4.015955957805969D-02/
C
C   n = 101
C
      data wleb( 585),(gjk(i, 585),i=1,2)/
     &  2.040382730826330D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 586),(gjk(i, 586),i=1,2)/
     &  3.178149703889544D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 587),(gjk(i, 587),i=1,2)/
     &  8.288115128076111D-05,
     &  1.721420832906233D-02, 1.721420832906233D-02/
      data wleb( 588),(gjk(i, 588),i=1,2)/
     &  1.360883192522954D-04,
     &  4.408875374981770D-02, 4.408875374981770D-02/
      data wleb( 589),(gjk(i, 589),i=1,2)/
     &  1.766854454542662D-04,
     &  7.594680813878681D-02, 7.594680813878681D-02/
      data wleb( 590),(gjk(i, 590),i=1,2)/
     &  2.083153161230153D-04,
     &  1.108335359204799D-01, 1.108335359204799D-01/
      data wleb( 591),(gjk(i, 591),i=1,2)/
     &  2.333279544657158D-04,
     &  1.476517054388567D-01, 1.476517054388567D-01/
      data wleb( 592),(gjk(i, 592),i=1,2)/
     &  2.532809539930247D-04,
     &  1.856731870860615D-01, 1.856731870860615D-01/
      data wleb( 593),(gjk(i, 593),i=1,2)/
     &  2.692472184211158D-04,
     &  2.243634099428821D-01, 2.243634099428821D-01/
      data wleb( 594),(gjk(i, 594),i=1,2)/
     &  2.819949946811885D-04,
     &  2.633006881662727D-01, 2.633006881662727D-01/
      data wleb( 595),(gjk(i, 595),i=1,2)/
     &  2.920953593973030D-04,
     &  3.021340904916283D-01, 3.021340904916283D-01/
      data wleb( 596),(gjk(i, 596),i=1,2)/
     &  2.999889782948352D-04,
     &  3.405594048030089D-01, 3.405594048030089D-01/
      data wleb( 597),(gjk(i, 597),i=1,2)/
     &  3.060292120496902D-04,
     &  3.783044434007372D-01, 3.783044434007372D-01/
      data wleb( 598),(gjk(i, 598),i=1,2)/
     &  3.105109167522192D-04,
     &  4.151194767407910D-01, 4.151194767407910D-01/
      data wleb( 599),(gjk(i, 599),i=1,2)/
     &  3.136902387550312D-04,
     &  4.507705766443257D-01, 4.507705766443257D-01/
      data wleb( 600),(gjk(i, 600),i=1,2)/
     &  3.157984652454632D-04,
     &  4.850346056573187D-01, 4.850346056573187D-01/
      data wleb( 601),(gjk(i, 601),i=1,2)/
     &  3.170516518425422D-04,
     &  5.176950817792469D-01, 5.176950817792469D-01/
      data wleb( 602),(gjk(i, 602),i=1,2)/
     &  3.176568425633755D-04,
     &  5.485384240820989D-01, 5.485384240820989D-01/
      data wleb( 603),(gjk(i, 603),i=1,2)/
     &  3.177198411207062D-04,
     &  6.039117238943308D-01, 6.039117238943308D-01/
      data wleb( 604),(gjk(i, 604),i=1,2)/
     &  3.175519492394733D-04,
     &  6.279956655573113D-01, 6.279956655573113D-01/
      data wleb( 605),(gjk(i, 605),i=1,2)/
     &  3.174654952634756D-04,
     &  6.493636169568952D-01, 6.493636169568952D-01/
      data wleb( 606),(gjk(i, 606),i=1,2)/
     &  3.175676415467654D-04,
     &  6.677644117704504D-01, 6.677644117704504D-01/
      data wleb( 607),(gjk(i, 607),i=1,2)/
     &  3.178923417835410D-04,
     &  6.829368572115624D-01, 6.829368572115624D-01/
      data wleb( 608),(gjk(i, 608),i=1,2)/
     &  3.183788287531909D-04,
     &  6.946195818184121D-01, 6.946195818184121D-01/
      data wleb( 609),(gjk(i, 609),i=1,2)/
     &  3.188755151918807D-04,
     &  7.025711542057026D-01, 7.025711542057026D-01/
      data wleb( 610),(gjk(i, 610),i=1,2)/
     &  3.191916889313849D-04,
     &  7.066004767140119D-01, 7.066004767140119D-01/
      data wleb( 611),(gjk(i, 611),i=1,2)/
     &  1.231779611744508D-04,
     &  5.132537689946062D-02, 0.000000000000000D+00/
      data wleb( 612),(gjk(i, 612),i=1,2)/
     &  1.924661373839880D-04,
     &  1.297994661331225D-01, 0.000000000000000D+00/
      data wleb( 613),(gjk(i, 613),i=1,2)/
     &  2.380881867403424D-04,
     &  2.188852049401307D-01, 0.000000000000000D+00/
      data wleb( 614),(gjk(i, 614),i=1,2)/
     &  2.693100663037885D-04,
     &  3.123174824903457D-01, 0.000000000000000D+00/
      data wleb( 615),(gjk(i, 615),i=1,2)/
     &  2.908673382834366D-04,
     &  4.064037620738195D-01, 0.000000000000000D+00/
      data wleb( 616),(gjk(i, 616),i=1,2)/
     &  3.053914619381535D-04,
     &  4.984958396944782D-01, 0.000000000000000D+00/
      data wleb( 617),(gjk(i, 617),i=1,2)/
     &  3.143916684147777D-04,
     &  5.864975046021365D-01, 0.000000000000000D+00/
      data wleb( 618),(gjk(i, 618),i=1,2)/
     &  3.187042244055363D-04,
     &  6.686711634580175D-01, 0.000000000000000D+00/
      data wleb( 619),(gjk(i, 619),i=1,2)/
     &  1.635219535869790D-04,
     &  8.715738780835949D-02, 2.557175233367578D-02/
      data wleb( 620),(gjk(i, 620),i=1,2)/
     &  1.968109917696070D-04,
     &  1.248383123134007D-01, 5.604823383376681D-02/
      data wleb( 621),(gjk(i, 621),i=1,2)/
     &  2.236754342249974D-04,
     &  1.638062693383378D-01, 8.968568601900764D-02/
      data wleb( 622),(gjk(i, 622),i=1,2)/
     &  2.453186687017181D-04,
     &  2.035586203373176D-01, 1.254086651976279D-01/
      data wleb( 623),(gjk(i, 623),i=1,2)/
     &  2.627551791580541D-04,
     &  2.436798975293774D-01, 1.624780150162012D-01/
      data wleb( 624),(gjk(i, 624),i=1,2)/
     &  2.767654860152220D-04,
     &  2.838207507773806D-01, 2.003422342683208D-01/
      data wleb( 625),(gjk(i, 625),i=1,2)/
     &  2.879467027765895D-04,
     &  3.236787502217692D-01, 2.385628026255263D-01/
      data wleb( 626),(gjk(i, 626),i=1,2)/
     &  2.967639918918702D-04,
     &  3.629849554840691D-01, 2.767731148783578D-01/
      data wleb( 627),(gjk(i, 627),i=1,2)/
     &  3.035900684660351D-04,
     &  4.014948081992087D-01, 3.146542308245309D-01/
      data wleb( 628),(gjk(i, 628),i=1,2)/
     &  3.087338237298308D-04,
     &  4.389818379260225D-01, 3.519196415895088D-01/
      data wleb( 629),(gjk(i, 629),i=1,2)/
     &  3.124608838860167D-04,
     &  4.752331143674377D-01, 3.883050984023654D-01/
      data wleb( 630),(gjk(i, 630),i=1,2)/
     &  3.150084294226743D-04,
     &  5.100457318374018D-01, 4.235613423908649D-01/
      data wleb( 631),(gjk(i, 631),i=1,2)/
     &  3.165958398598402D-04,
     &  5.432238388954868D-01, 4.574484717196220D-01/
      data wleb( 632),(gjk(i, 632),i=1,2)/
     &  3.174320440957372D-04,
     &  5.745758685072442D-01, 4.897311639255524D-01/
      data wleb( 633),(gjk(i, 633),i=1,2)/
     &  2.182188909812599D-04,
     &  1.723981437592809D-01, 3.010630597881105D-02/
      data wleb( 634),(gjk(i, 634),i=1,2)/
     &  2.399727933921445D-04,
     &  2.149553257844597D-01, 6.326031554204695D-02/
      data wleb( 635),(gjk(i, 635),i=1,2)/
     &  2.579796133514652D-04,
     &  2.573256081247422D-01, 9.848566980258631D-02/
      data wleb( 636),(gjk(i, 636),i=1,2)/
     &  2.727114052623535D-04,
     &  2.993163751238106D-01, 1.350835952384266D-01/
      data wleb( 637),(gjk(i, 637),i=1,2)/
     &  2.846327656281355D-04,
     &  3.407238005148000D-01, 1.725184055442181D-01/
      data wleb( 638),(gjk(i, 638),i=1,2)/
     &  2.941491102051334D-04,
     &  3.813454978483264D-01, 2.103559279730725D-01/
      data wleb( 639),(gjk(i, 639),i=1,2)/
     &  3.016049492136107D-04,
     &  4.209848104423343D-01, 2.482278774554860D-01/
      data wleb( 640),(gjk(i, 640),i=1,2)/
     &  3.072949726175648D-04,
     &  4.594519699996300D-01, 2.858099509982883D-01/
      data wleb( 641),(gjk(i, 641),i=1,2)/
     &  3.114768142886460D-04,
     &  4.965640166185930D-01, 3.228075659915428D-01/
      data wleb( 642),(gjk(i, 642),i=1,2)/
     &  3.143823673666223D-04,
     &  5.321441655571562D-01, 3.589459907204151D-01/
      data wleb( 643),(gjk(i, 643),i=1,2)/
     &  3.162269764661535D-04,
     &  5.660208438582166D-01, 3.939630088864310D-01/
      data wleb( 644),(gjk(i, 644),i=1,2)/
     &  3.172164663759821D-04,
     &  5.980264315964364D-01, 4.276029922949089D-01/
      data wleb( 645),(gjk(i, 645),i=1,2)/
     &  2.554575398967435D-04,
     &  2.644215852350733D-01, 3.300939429072552D-02/
      data wleb( 646),(gjk(i, 646),i=1,2)/
     &  2.701704069135677D-04,
     &  3.090113743443063D-01, 6.803887650078501D-02/
      data wleb( 647),(gjk(i, 647),i=1,2)/
     &  2.823693413468940D-04,
     &  3.525871079197808D-01, 1.044326136206709D-01/
      data wleb( 648),(gjk(i, 648),i=1,2)/
     &  2.922898463214289D-04,
     &  3.950418005354029D-01, 1.416751597517679D-01/
      data wleb( 649),(gjk(i, 649),i=1,2)/
     &  3.001829062162428D-04,
     &  4.362475663430163D-01, 1.793408610504821D-01/
      data wleb( 650),(gjk(i, 650),i=1,2)/
     &  3.062890864542953D-04,
     &  4.760661812145854D-01, 2.170630750175722D-01/
      data wleb( 651),(gjk(i, 651),i=1,2)/
     &  3.108328279264746D-04,
     &  5.143551042512103D-01, 2.545145157815807D-01/
      data wleb( 652),(gjk(i, 652),i=1,2)/
     &  3.140243146201245D-04,
     &  5.509709026935597D-01, 2.913940101706601D-01/
      data wleb( 653),(gjk(i, 653),i=1,2)/
     &  3.160638030977130D-04,
     &  5.857711030329428D-01, 3.274169910910705D-01/
      data wleb( 654),(gjk(i, 654),i=1,2)/
     &  3.171462882206275D-04,
     &  6.186149917404392D-01, 3.623081329317265D-01/
      data wleb( 655),(gjk(i, 655),i=1,2)/
     &  2.812388416031796D-04,
     &  3.586894569557064D-01, 3.497354386450040D-02/
      data wleb( 656),(gjk(i, 656),i=1,2)/
     &  2.912137500288045D-04,
     &  4.035266610019441D-01, 7.129736739757095D-02/
      data wleb( 657),(gjk(i, 657),i=1,2)/
     &  2.993241256502206D-04,
     &  4.467775312332510D-01, 1.084758620193165D-01/
      data wleb( 658),(gjk(i, 658),i=1,2)/
     &  3.057101738983822D-04,
     &  4.883638346608543D-01, 1.460915689241772D-01/
      data wleb( 659),(gjk(i, 659),i=1,2)/
     &  3.105319326251432D-04,
     &  5.281908348434601D-01, 1.837790832369980D-01/
      data wleb( 660),(gjk(i, 660),i=1,2)/
     &  3.139565514428167D-04,
     &  5.661542687149311D-01, 2.212075390874021D-01/
      data wleb( 661),(gjk(i, 661),i=1,2)/
     &  3.161543006806366D-04,
     &  6.021450102031451D-01, 2.580682841160985D-01/
      data wleb( 662),(gjk(i, 662),i=1,2)/
     &  3.172985960613294D-04,
     &  6.360520783610050D-01, 2.940656362094121D-01/
      data wleb( 663),(gjk(i, 663),i=1,2)/
     &  2.989400336901431D-04,
     &  4.521611065087196D-01, 3.631055365867002D-02/
      data wleb( 664),(gjk(i, 664),i=1,2)/
     &  3.054555883947677D-04,
     &  4.959365651560963D-01, 7.348318468484349D-02/
      data wleb( 665),(gjk(i, 665),i=1,2)/
     &  3.104764960807702D-04,
     &  5.376815804038283D-01, 1.111087643812648D-01/
      data wleb( 666),(gjk(i, 666),i=1,2)/
     &  3.141015825977616D-04,
     &  5.773314480243767D-01, 1.488226085145408D-01/
      data wleb( 667),(gjk(i, 667),i=1,2)/
     &  3.164520621159896D-04,
     &  6.148113245575056D-01, 1.862892274135151D-01/
      data wleb( 668),(gjk(i, 668),i=1,2)/
     &  3.176652305912204D-04,
     &  6.500407462842380D-01, 2.231909701714456D-01/
      data wleb( 669),(gjk(i, 669),i=1,2)/
     &  3.105097161023939D-04,
     &  5.425151448707213D-01, 3.718201306118944D-02/
      data wleb( 670),(gjk(i, 670),i=1,2)/
     &  3.143014117890550D-04,
     &  5.841860556907931D-01, 7.483616335067346D-02/
      data wleb( 671),(gjk(i, 671),i=1,2)/
     &  3.168172866287200D-04,
     &  6.234632186851500D-01, 1.125990834266120D-01/
      data wleb( 672),(gjk(i, 672),i=1,2)/
     &  3.181401865570968D-04,
     &  6.602934551848842D-01, 1.501303813157619D-01/
      data wleb( 673),(gjk(i, 673),i=1,2)/
     &  3.170663659156037D-04,
     &  6.278573968375105D-01, 3.767559930245720D-02/
      data wleb( 674),(gjk(i, 674),i=1,2)/
     &  3.185447944625510D-04,
     &  6.665611711264577D-01, 7.548443301360158D-02/
C
C   n = 113
C
      data wleb( 675),(gjk(i, 675),i=1,2)/
     &  1.807395252196920D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 676),(gjk(i, 676),i=1,2)/
     &  2.848008782238827D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 677),(gjk(i, 677),i=1,2)/
     &  2.836065837530581D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 678),(gjk(i, 678),i=1,2)/
     &  7.013149266673816D-05,
     &  1.587876419858352D-02, 1.587876419858352D-02/
      data wleb( 679),(gjk(i, 679),i=1,2)/
     &  1.162798021956766D-04,
     &  4.069193593751206D-02, 4.069193593751206D-02/
      data wleb( 680),(gjk(i, 680),i=1,2)/
     &  1.518728583972105D-04,
     &  7.025888115257997D-02, 7.025888115257997D-02/
      data wleb( 681),(gjk(i, 681),i=1,2)/
     &  1.798796108216934D-04,
     &  1.027495450028704D-01, 1.027495450028704D-01/
      data wleb( 682),(gjk(i, 682),i=1,2)/
     &  2.022593385972785D-04,
     &  1.371457730893426D-01, 1.371457730893426D-01/
      data wleb( 683),(gjk(i, 683),i=1,2)/
     &  2.203093105575464D-04,
     &  1.727758532671953D-01, 1.727758532671953D-01/
      data wleb( 684),(gjk(i, 684),i=1,2)/
     &  2.349294234299855D-04,
     &  2.091492038929037D-01, 2.091492038929037D-01/
      data wleb( 685),(gjk(i, 685),i=1,2)/
     &  2.467682058747003D-04,
     &  2.458813281751915D-01, 2.458813281751915D-01/
      data wleb( 686),(gjk(i, 686),i=1,2)/
     &  2.563092683572224D-04,
     &  2.826545859450066D-01, 2.826545859450066D-01/
      data wleb( 687),(gjk(i, 687),i=1,2)/
     &  2.639253896763318D-04,
     &  3.191957291799622D-01, 3.191957291799622D-01/
      data wleb( 688),(gjk(i, 688),i=1,2)/
     &  2.699137479265108D-04,
     &  3.552621469299578D-01, 3.552621469299578D-01/
      data wleb( 689),(gjk(i, 689),i=1,2)/
     &  2.745196420166739D-04,
     &  3.906329503406230D-01, 3.906329503406230D-01/
      data wleb( 690),(gjk(i, 690),i=1,2)/
     &  2.779529197397593D-04,
     &  4.251028614093031D-01, 4.251028614093031D-01/
      data wleb( 691),(gjk(i, 691),i=1,2)/
     &  2.803996086684265D-04,
     &  4.584777520111870D-01, 4.584777520111870D-01/
      data wleb( 692),(gjk(i, 692),i=1,2)/
     &  2.820302356715842D-04,
     &  4.905711358710193D-01, 4.905711358710193D-01/
      data wleb( 693),(gjk(i, 693),i=1,2)/
     &  2.830056747491068D-04,
     &  5.212011669847385D-01, 5.212011669847385D-01/
      data wleb( 694),(gjk(i, 694),i=1,2)/
     &  2.834808950776839D-04,
     &  5.501878488737995D-01, 5.501878488737995D-01/
      data wleb( 695),(gjk(i, 695),i=1,2)/
     &  2.835282339078929D-04,
     &  6.025037877479342D-01, 6.025037877479342D-01/
      data wleb( 696),(gjk(i, 696),i=1,2)/
     &  2.833819267065800D-04,
     &  6.254572689549016D-01, 6.254572689549016D-01/
      data wleb( 697),(gjk(i, 697),i=1,2)/
     &  2.832858336906784D-04,
     &  6.460107179528248D-01, 6.460107179528248D-01/
      data wleb( 698),(gjk(i, 698),i=1,2)/
     &  2.833268235451244D-04,
     &  6.639541138154251D-01, 6.639541138154251D-01/
      data wleb( 699),(gjk(i, 699),i=1,2)/
     &  2.835432677029253D-04,
     &  6.790688515667495D-01, 6.790688515667495D-01/
      data wleb( 700),(gjk(i, 700),i=1,2)/
     &  2.839091722743049D-04,
     &  6.911338580371512D-01, 6.911338580371512D-01/
      data wleb( 701),(gjk(i, 701),i=1,2)/
     &  2.843308178875841D-04,
     &  6.999385956126490D-01, 6.999385956126490D-01/
      data wleb( 702),(gjk(i, 702),i=1,2)/
     &  2.846703550533846D-04,
     &  7.053037748656896D-01, 7.053037748656896D-01/
      data wleb( 703),(gjk(i, 703),i=1,2)/
     &  1.051193406971900D-04,
     &  4.732224387180115D-02, 0.000000000000000D+00/
      data wleb( 704),(gjk(i, 704),i=1,2)/
     &  1.657871838796974D-04,
     &  1.202100529326803D-01, 0.000000000000000D+00/
      data wleb( 705),(gjk(i, 705),i=1,2)/
     &  2.064648113714232D-04,
     &  2.034304820664855D-01, 0.000000000000000D+00/
      data wleb( 706),(gjk(i, 706),i=1,2)/
     &  2.347942745819741D-04,
     &  2.912285643573002D-01, 0.000000000000000D+00/
      data wleb( 707),(gjk(i, 707),i=1,2)/
     &  2.547775326597726D-04,
     &  3.802361792726768D-01, 0.000000000000000D+00/
      data wleb( 708),(gjk(i, 708),i=1,2)/
     &  2.686876684847025D-04,
     &  4.680598511056146D-01, 0.000000000000000D+00/
      data wleb( 709),(gjk(i, 709),i=1,2)/
     &  2.778665755515867D-04,
     &  5.528151052155599D-01, 0.000000000000000D+00/
      data wleb( 710),(gjk(i, 710),i=1,2)/
     &  2.830996616782929D-04,
     &  6.329386307803041D-01, 0.000000000000000D+00/
      data wleb( 711),(gjk(i, 711),i=1,2)/
     &  1.403063340168372D-04,
     &  8.056516651369069D-02, 2.363454684003124D-02/
      data wleb( 712),(gjk(i, 712),i=1,2)/
     &  1.696504125939477D-04,
     &  1.156476077139389D-01, 5.191291632545936D-02/
      data wleb( 713),(gjk(i, 713),i=1,2)/
     &  1.935787242745390D-04,
     &  1.520473382760421D-01, 8.322715736994520D-02/
      data wleb( 714),(gjk(i, 714),i=1,2)/
     &  2.130614510521968D-04,
     &  1.892986699745931D-01, 1.165855667993712D-01/
      data wleb( 715),(gjk(i, 715),i=1,2)/
     &  2.289381265931048D-04,
     &  2.270194446777792D-01, 1.513077167409504D-01/
      data wleb( 716),(gjk(i, 716),i=1,2)/
     &  2.418630292816186D-04,
     &  2.648908185093273D-01, 1.868882025807859D-01/
      data wleb( 717),(gjk(i, 717),i=1,2)/
     &  2.523400495631193D-04,
     &  3.026389259574136D-01, 2.229277629776224D-01/
      data wleb( 718),(gjk(i, 718),i=1,2)/
     &  2.607623973449605D-04,
     &  3.400220296151384D-01, 2.590951840746235D-01/
      data wleb( 719),(gjk(i, 719),i=1,2)/
     &  2.674441032689209D-04,
     &  3.768217953335510D-01, 2.951047291750847D-01/
      data wleb( 720),(gjk(i, 720),i=1,2)/
     &  2.726432360343356D-04,
     &  4.128372900921884D-01, 3.307019714169930D-01/
      data wleb( 721),(gjk(i, 721),i=1,2)/
     &  2.765787685924545D-04,
     &  4.478807131815630D-01, 3.656544101087634D-01/
      data wleb( 722),(gjk(i, 722),i=1,2)/
     &  2.794428690642224D-04,
     &  4.817742034089257D-01, 3.997448951939695D-01/
      data wleb( 723),(gjk(i, 723),i=1,2)/
     &  2.814099002062895D-04,
     &  5.143472814653344D-01, 4.327667110812024D-01/
      data wleb( 724),(gjk(i, 724),i=1,2)/
     &  2.826429531578994D-04,
     &  5.454346213905650D-01, 4.645196123532293D-01/
      data wleb( 725),(gjk(i, 725),i=1,2)/
     &  2.832983542550884D-04,
     &  5.748739313170252D-01, 4.948063555703345D-01/
      data wleb( 726),(gjk(i, 726),i=1,2)/
     &  1.886695565284976D-04,
     &  1.599598738286342D-01, 2.792357590048985D-02/
      data wleb( 727),(gjk(i, 727),i=1,2)/
     &  2.081867882748234D-04,
     &  1.998097412500951D-01, 5.877141038139065D-02/
      data wleb( 728),(gjk(i, 728),i=1,2)/
     &  2.245148680600796D-04,
     &  2.396228952566202D-01, 9.164573914691378D-02/
      data wleb( 729),(gjk(i, 729),i=1,2)/
     &  2.380370491511872D-04,
     &  2.792228341097746D-01, 1.259049641962687D-01/
      data wleb( 730),(gjk(i, 730),i=1,2)/
     &  2.491398041852455D-04,
     &  3.184251107546741D-01, 1.610594823400863D-01/
      data wleb( 731),(gjk(i, 731),i=1,2)/
     &  2.581632405881230D-04,
     &  3.570481164426244D-01, 1.967151653460898D-01/
      data wleb( 732),(gjk(i, 732),i=1,2)/
     &  2.653965506227417D-04,
     &  3.949164710492144D-01, 2.325404606175168D-01/
      data wleb( 733),(gjk(i, 733),i=1,2)/
     &  2.710857216747087D-04,
     &  4.318617293970503D-01, 2.682461141151439D-01/
      data wleb( 734),(gjk(i, 734),i=1,2)/
     &  2.754434093903659D-04,
     &  4.677221009931678D-01, 3.035720116011973D-01/
      data wleb( 735),(gjk(i, 735),i=1,2)/
     &  2.786579932519380D-04,
     &  5.023417939270955D-01, 3.382781859197439D-01/
      data wleb( 736),(gjk(i, 736),i=1,2)/
     &  2.809011080679474D-04,
     &  5.355701836636128D-01, 3.721383065625942D-01/
      data wleb( 737),(gjk(i, 737),i=1,2)/
     &  2.823336184560987D-04,
     &  5.672608451328771D-01, 4.049346360466055D-01/
      data wleb( 738),(gjk(i, 738),i=1,2)/
     &  2.831101175806309D-04,
     &  5.972704202540162D-01, 4.364538098633802D-01/
      data wleb( 739),(gjk(i, 739),i=1,2)/
     &  2.221679970354546D-04,
     &  2.461687022333596D-01, 3.070423166833368D-02/
      data wleb( 740),(gjk(i, 740),i=1,2)/
     &  2.356185734270703D-04,
     &  2.881774566286831D-01, 6.338034669281885D-02/
      data wleb( 741),(gjk(i, 741),i=1,2)/
     &  2.469228344805590D-04,
     &  3.293963604116978D-01, 9.742862487067941D-02/
      data wleb( 742),(gjk(i, 742),i=1,2)/
     &  2.562726348642046D-04,
     &  3.697303822241377D-01, 1.323799532282290D-01/
      data wleb( 743),(gjk(i, 743),i=1,2)/
     &  2.638756726753028D-04,
     &  4.090663023135127D-01, 1.678497018129336D-01/
      data wleb( 744),(gjk(i, 744),i=1,2)/
     &  2.699311157390862D-04,
     &  4.472819355411712D-01, 2.035095105326114D-01/
      data wleb( 745),(gjk(i, 745),i=1,2)/
     &  2.746233268403837D-04,
     &  4.842513377231437D-01, 2.390692566672091D-01/
      data wleb( 746),(gjk(i, 746),i=1,2)/
     &  2.781225674454771D-04,
     &  5.198477629962928D-01, 2.742649818076149D-01/
      data wleb( 747),(gjk(i, 747),i=1,2)/
     &  2.805881254045684D-04,
     &  5.539453011883145D-01, 3.088503806580094D-01/
      data wleb( 748),(gjk(i, 748),i=1,2)/
     &  2.821719877004913D-04,
     &  5.864196762401251D-01, 3.425904245906614D-01/
      data wleb( 749),(gjk(i, 749),i=1,2)/
     &  2.830222502333124D-04,
     &  6.171484466668390D-01, 3.752562294789468D-01/
      data wleb( 750),(gjk(i, 750),i=1,2)/
     &  2.457995956744870D-04,
     &  3.350337830565727D-01, 3.261589934634747D-02/
      data wleb( 751),(gjk(i, 751),i=1,2)/
     &  2.551474407503706D-04,
     &  3.775773224758284D-01, 6.658438928081573D-02/
      data wleb( 752),(gjk(i, 752),i=1,2)/
     &  2.629065335195311D-04,
     &  4.188155229848973D-01, 1.014565797157954D-01/
      data wleb( 753),(gjk(i, 753),i=1,2)/
     &  2.691900449925075D-04,
     &  4.586805892009344D-01, 1.368573320843822D-01/
      data wleb( 754),(gjk(i, 754),i=1,2)/
     &  2.741275485754276D-04,
     &  4.970895714224235D-01, 1.724614851951608D-01/
      data wleb( 755),(gjk(i, 755),i=1,2)/
     &  2.778530970122595D-04,
     &  5.339505133960747D-01, 2.079779381416412D-01/
      data wleb( 756),(gjk(i, 756),i=1,2)/
     &  2.805010567646741D-04,
     &  5.691665792531440D-01, 2.431385788322288D-01/
      data wleb( 757),(gjk(i, 757),i=1,2)/
     &  2.822055834031040D-04,
     &  6.026387682680377D-01, 2.776901883049853D-01/
      data wleb( 758),(gjk(i, 758),i=1,2)/
     &  2.831016901243473D-04,
     &  6.342676150163307D-01, 3.113881356386632D-01/
      data wleb( 759),(gjk(i, 759),i=1,2)/
     &  2.624474901131803D-04,
     &  4.237951119537067D-01, 3.394877848664351D-02/
      data wleb( 760),(gjk(i, 760),i=1,2)/
     &  2.688034163039377D-04,
     &  4.656918683234929D-01, 6.880219556291448D-02/
      data wleb( 761),(gjk(i, 761),i=1,2)/
     &  2.738932751287636D-04,
     &  5.058857069185980D-01, 1.041946859721635D-01/
      data wleb( 762),(gjk(i, 762),i=1,2)/
     &  2.777944791242523D-04,
     &  5.443204666713995D-01, 1.398039738736393D-01/
      data wleb( 763),(gjk(i, 763),i=1,2)/
     &  2.806011661660987D-04,
     &  5.809298813759742D-01, 1.753373381196155D-01/
      data wleb( 764),(gjk(i, 764),i=1,2)/
     &  2.824181456597460D-04,
     &  6.156416039447128D-01, 2.105215793514010D-01/
      data wleb( 765),(gjk(i, 765),i=1,2)/
     &  2.833585216577828D-04,
     &  6.483801351066604D-01, 2.450953312157051D-01/
      data wleb( 766),(gjk(i, 766),i=1,2)/
     &  2.738165236962878D-04,
     &  5.103616577251688D-01, 3.485560643800719D-02/
      data wleb( 767),(gjk(i, 767),i=1,2)/
     &  2.778365208203180D-04,
     &  5.506738792580681D-01, 7.026308631512033D-02/
      data wleb( 768),(gjk(i, 768),i=1,2)/
     &  2.807852940418966D-04,
     &  5.889573040995292D-01, 1.059035061296403D-01/
      data wleb( 769),(gjk(i, 769),i=1,2)/
     &  2.827245949674705D-04,
     &  6.251641589516930D-01, 1.414823925236026D-01/
      data wleb( 770),(gjk(i, 770),i=1,2)/
     &  2.837342344829828D-04,
     &  6.592414921570178D-01, 1.767207908214530D-01/
      data wleb( 771),(gjk(i, 771),i=1,2)/
     &  2.809233907610981D-04,
     &  5.930314017533383D-01, 3.542189339561672D-02/
      data wleb( 772),(gjk(i, 772),i=1,2)/
     &  2.829930809742694D-04,
     &  6.309812253390175D-01, 7.109574040369548D-02/
      data wleb( 773),(gjk(i, 773),i=1,2)/
     &  2.841097874111479D-04,
     &  6.666296011353230D-01, 1.067259792282730D-01/
      data wleb( 774),(gjk(i, 774),i=1,2)/
     &  2.843455206008783D-04,
     &  6.703715271049921D-01, 3.569455268820809D-02/
C
C   n = 119
C
      data wleb( 775),(gjk(i, 775),i=1,2)/
     &  1.449063022537883D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 776),(gjk(i, 776),i=1,2)/
     &  2.546377329828424D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 777),(gjk(i, 777),i=1,2)/
     &  6.018432961087496D-05,
     &  1.462896151831013D-02, 1.462896151831013D-02/
      data wleb( 778),(gjk(i, 778),i=1,2)/
     &  1.002286583263673D-04,
     &  3.769840812493139D-02, 3.769840812493139D-02/
      data wleb( 779),(gjk(i, 779),i=1,2)/
     &  1.315222931028093D-04,
     &  6.524701904096891D-02, 6.524701904096891D-02/
      data wleb( 780),(gjk(i, 780),i=1,2)/
     &  1.564213746876724D-04,
     &  9.560543416134648D-02, 9.560543416134648D-02/
      data wleb( 781),(gjk(i, 781),i=1,2)/
     &  1.765118841507736D-04,
     &  1.278335898929198D-01, 1.278335898929198D-01/
      data wleb( 782),(gjk(i, 782),i=1,2)/
     &  1.928737099311080D-04,
     &  1.613096104466031D-01, 1.613096104466031D-01/
      data wleb( 783),(gjk(i, 783),i=1,2)/
     &  2.062658534263270D-04,
     &  1.955806225745371D-01, 1.955806225745371D-01/
      data wleb( 784),(gjk(i, 784),i=1,2)/
     &  2.172395445953787D-04,
     &  2.302935218498028D-01, 2.302935218498028D-01/
      data wleb( 785),(gjk(i, 785),i=1,2)/
     &  2.262076188876047D-04,
     &  2.651584344113027D-01, 2.651584344113027D-01/
      data wleb( 786),(gjk(i, 786),i=1,2)/
     &  2.334885699462397D-04,
     &  2.999276825183209D-01, 2.999276825183209D-01/
      data wleb( 787),(gjk(i, 787),i=1,2)/
     &  2.393355273179203D-04,
     &  3.343828669718798D-01, 3.343828669718798D-01/
      data wleb( 788),(gjk(i, 788),i=1,2)/
     &  2.439559200468863D-04,
     &  3.683265013750518D-01, 3.683265013750518D-01/
      data wleb( 789),(gjk(i, 789),i=1,2)/
     &  2.475251866060002D-04,
     &  4.015763206518108D-01, 4.015763206518108D-01/
      data wleb( 790),(gjk(i, 790),i=1,2)/
     &  2.501965558158773D-04,
     &  4.339612026399770D-01, 4.339612026399770D-01/
      data wleb( 791),(gjk(i, 791),i=1,2)/
     &  2.521081407925925D-04,
     &  4.653180651114582D-01, 4.653180651114582D-01/
      data wleb( 792),(gjk(i, 792),i=1,2)/
     &  2.533881002388081D-04,
     &  4.954893331080803D-01, 4.954893331080803D-01/
      data wleb( 793),(gjk(i, 793),i=1,2)/
     &  2.541582900848261D-04,
     &  5.243207068924930D-01, 5.243207068924930D-01/
      data wleb( 794),(gjk(i, 794),i=1,2)/
     &  2.545365737525860D-04,
     &  5.516590479041704D-01, 5.516590479041704D-01/
      data wleb( 795),(gjk(i, 795),i=1,2)/
     &  2.545726993066799D-04,
     &  6.012371927804177D-01, 6.012371927804177D-01/
      data wleb( 796),(gjk(i, 796),i=1,2)/
     &  2.544456197465555D-04,
     &  6.231574466449818D-01, 6.231574466449818D-01/
      data wleb( 797),(gjk(i, 797),i=1,2)/
     &  2.543481596881064D-04,
     &  6.429416514181271D-01, 6.429416514181271D-01/
      data wleb( 798),(gjk(i, 798),i=1,2)/
     &  2.543506451429194D-04,
     &  6.604124272943594D-01, 6.604124272943594D-01/
      data wleb( 799),(gjk(i, 799),i=1,2)/
     &  2.544905675493763D-04,
     &  6.753851470408250D-01, 6.753851470408250D-01/
      data wleb( 800),(gjk(i, 800),i=1,2)/
     &  2.547611407344429D-04,
     &  6.876717970626161D-01, 6.876717970626161D-01/
      data wleb( 801),(gjk(i, 801),i=1,2)/
     &  2.551060375448869D-04,
     &  6.970895061319234D-01, 6.970895061319234D-01/
      data wleb( 802),(gjk(i, 802),i=1,2)/
     &  2.554291933816039D-04,
     &  7.034746912553310D-01, 7.034746912553310D-01/
      data wleb( 803),(gjk(i, 803),i=1,2)/
     &  2.556255710686343D-04,
     &  7.067017217542295D-01, 7.067017217542295D-01/
      data wleb( 804),(gjk(i, 804),i=1,2)/
     &  9.041339695118196D-05,
     &  4.382223501131123D-02, 0.000000000000000D+00/
      data wleb( 805),(gjk(i, 805),i=1,2)/
     &  1.438426330079022D-04,
     &  1.117474077400006D-01, 0.000000000000000D+00/
      data wleb( 806),(gjk(i, 806),i=1,2)/
     &  1.802523089820518D-04,
     &  1.897153252911440D-01, 0.000000000000000D+00/
      data wleb( 807),(gjk(i, 807),i=1,2)/
     &  2.060052290565496D-04,
     &  2.724023009910331D-01, 0.000000000000000D+00/
      data wleb( 808),(gjk(i, 808),i=1,2)/
     &  2.245002248967466D-04,
     &  3.567163308709902D-01, 0.000000000000000D+00/
      data wleb( 809),(gjk(i, 809),i=1,2)/
     &  2.377059847731150D-04,
     &  4.404784483028087D-01, 0.000000000000000D+00/
      data wleb( 810),(gjk(i, 810),i=1,2)/
     &  2.468118955882525D-04,
     &  5.219833154161411D-01, 0.000000000000000D+00/
      data wleb( 811),(gjk(i, 811),i=1,2)/
     &  2.525410872966528D-04,
     &  5.998179868977553D-01, 0.000000000000000D+00/
      data wleb( 812),(gjk(i, 812),i=1,2)/
     &  2.553101409933397D-04,
     &  6.727803154548222D-01, 0.000000000000000D+00/
      data wleb( 813),(gjk(i, 813),i=1,2)/
     &  1.212879733668632D-04,
     &  7.476563943166085D-02, 2.193168509461185D-02/
      data wleb( 814),(gjk(i, 814),i=1,2)/
     &  1.472872881270931D-04,
     &  1.075341482001416D-01, 4.826419281533887D-02/
      data wleb( 815),(gjk(i, 815),i=1,2)/
     &  1.686846601010828D-04,
     &  1.416344885203259D-01, 7.751191883575742D-02/
      data wleb( 816),(gjk(i, 816),i=1,2)/
     &  1.862698414660208D-04,
     &  1.766325315388586D-01, 1.087558139247680D-01/
      data wleb( 817),(gjk(i, 817),i=1,2)/
     &  2.007430956991861D-04,
     &  2.121744174481514D-01, 1.413661374253096D-01/
      data wleb( 818),(gjk(i, 818),i=1,2)/
     &  2.126568125394796D-04,
     &  2.479669443408145D-01, 1.748768214258880D-01/
      data wleb( 819),(gjk(i, 819),i=1,2)/
     &  2.224394603372113D-04,
     &  2.837600452294113D-01, 2.089216406612073D-01/
      data wleb( 820),(gjk(i, 820),i=1,2)/
     &  2.304264522673135D-04,
     &  3.193344933193984D-01, 2.431987685545972D-01/
      data wleb( 821),(gjk(i, 821),i=1,2)/
     &  2.368854288424087D-04,
     &  3.544935442438745D-01, 2.774497054377770D-01/
      data wleb( 822),(gjk(i, 822),i=1,2)/
     &  2.420352089461772D-04,
     &  3.890571932288154D-01, 3.114460356156915D-01/
      data wleb( 823),(gjk(i, 823),i=1,2)/
     &  2.460597113081295D-04,
     &  4.228581214259090D-01, 3.449806851913012D-01/
      data wleb( 824),(gjk(i, 824),i=1,2)/
     &  2.491181912257687D-04,
     &  4.557387211304052D-01, 3.778618641248256D-01/
      data wleb( 825),(gjk(i, 825),i=1,2)/
     &  2.513528194205857D-04,
     &  4.875487950541643D-01, 4.099086391698978D-01/
      data wleb( 826),(gjk(i, 826),i=1,2)/
     &  2.528943096693220D-04,
     &  5.181436529962997D-01, 4.409474925853973D-01/
      data wleb( 827),(gjk(i, 827),i=1,2)/
     &  2.538660368488136D-04,
     &  5.473824095600661D-01, 4.708094517711291D-01/
      data wleb( 828),(gjk(i, 828),i=1,2)/
     &  2.543868648299022D-04,
     &  5.751263398976174D-01, 4.993275140354637D-01/
      data wleb( 829),(gjk(i, 829),i=1,2)/
     &  1.642595537825183D-04,
     &  1.489515746840028D-01, 2.599381993267017D-02/
      data wleb( 830),(gjk(i, 830),i=1,2)/
     &  1.818246659849308D-04,
     &  1.863656444351767D-01, 5.479286532462190D-02/
      data wleb( 831),(gjk(i, 831),i=1,2)/
     &  1.966565649492420D-04,
     &  2.238602880356348D-01, 8.556763251425253D-02/
      data wleb( 832),(gjk(i, 832),i=1,2)/
     &  2.090677905657991D-04,
     &  2.612723375728160D-01, 1.177257802267011D-01/
      data wleb( 833),(gjk(i, 833),i=1,2)/
     &  2.193820409510504D-04,
     &  2.984332990206190D-01, 1.508168456192700D-01/
      data wleb( 834),(gjk(i, 834),i=1,2)/
     &  2.278870827661928D-04,
     &  3.351786584663333D-01, 1.844801892177727D-01/
      data wleb( 835),(gjk(i, 835),i=1,2)/
     &  2.348283192282090D-04,
     &  3.713505522209120D-01, 2.184145236087598D-01/
      data wleb( 836),(gjk(i, 836),i=1,2)/
     &  2.404139755581477D-04,
     &  4.067981098954663D-01, 2.523590641486229D-01/
      data wleb( 837),(gjk(i, 837),i=1,2)/
     &  2.448227407760734D-04,
     &  4.413769993687534D-01, 2.860812976901373D-01/
      data wleb( 838),(gjk(i, 838),i=1,2)/
     &  2.482110455592573D-04,
     &  4.749487182516394D-01, 3.193686757808996D-01/
      data wleb( 839),(gjk(i, 839),i=1,2)/
     &  2.507192397774103D-04,
     &  5.073798105075426D-01, 3.520226949547602D-01/
      data wleb( 840),(gjk(i, 840),i=1,2)/
     &  2.524765968534880D-04,
     &  5.385410448878654D-01, 3.838544395667890D-01/
      data wleb( 841),(gjk(i, 841),i=1,2)/
     &  2.536052388539425D-04,
     &  5.683065353670530D-01, 4.146810037640963D-01/
      data wleb( 842),(gjk(i, 842),i=1,2)/
     &  2.542230588033068D-04,
     &  5.965527620663510D-01, 4.443224094681121D-01/
      data wleb( 843),(gjk(i, 843),i=1,2)/
     &  1.944817013047896D-04,
     &  2.299227700856157D-01, 2.865757664057584D-02/
      data wleb( 844),(gjk(i, 844),i=1,2)/
     &  2.067862362746635D-04,
     &  2.695752998553267D-01, 5.923421684485993D-02/
      data wleb( 845),(gjk(i, 845),i=1,2)/
     &  2.172440734649114D-04,
     &  3.086178716611389D-01, 9.117817776057716D-02/
      data wleb( 846),(gjk(i, 846),i=1,2)/
     &  2.260125991723423D-04,
     &  3.469649871659077D-01, 1.240593814082605D-01/
      data wleb( 847),(gjk(i, 847),i=1,2)/
     &  2.332655008689523D-04,
     &  3.845153566319655D-01, 1.575272058259175D-01/
      data wleb( 848),(gjk(i, 848),i=1,2)/
     &  2.391699681532458D-04,
     &  4.211600033403215D-01, 1.912845163525413D-01/
      data wleb( 849),(gjk(i, 849),i=1,2)/
     &  2.438801528273928D-04,
     &  4.567867834329882D-01, 2.250710177858171D-01/
      data wleb( 850),(gjk(i, 850),i=1,2)/
     &  2.475370504260665D-04,
     &  4.912829319232061D-01, 2.586521303440910D-01/
      data wleb( 851),(gjk(i, 851),i=1,2)/
     &  2.502707235640574D-04,
     &  5.245364793303812D-01, 2.918112242865407D-01/
      data wleb( 852),(gjk(i, 852),i=1,2)/
     &  2.522031701054241D-04,
     &  5.564369788915756D-01, 3.243439239067890D-01/
      data wleb( 853),(gjk(i, 853),i=1,2)/
     &  2.534511269978784D-04,
     &  5.868757697775288D-01, 3.560536787835351D-01/
      data wleb( 854),(gjk(i, 854),i=1,2)/
     &  2.541284914955151D-04,
     &  6.157458853519617D-01, 3.867480821242581D-01/
      data wleb( 855),(gjk(i, 855),i=1,2)/
     &  2.161509250688394D-04,
     &  3.138461110672113D-01, 3.051374637507278D-02/
      data wleb( 856),(gjk(i, 856),i=1,2)/
     &  2.248778513437852D-04,
     &  3.542495872050569D-01, 6.237111233730755D-02/
      data wleb( 857),(gjk(i, 857),i=1,2)/
     &  2.322388803404617D-04,
     &  3.935751553120181D-01, 9.516223952401907D-02/
      data wleb( 858),(gjk(i, 858),i=1,2)/
     &  2.383265471001355D-04,
     &  4.317634668111147D-01, 1.285467341508517D-01/
      data wleb( 859),(gjk(i, 859),i=1,2)/
     &  2.432476675019525D-04,
     &  4.687413842250821D-01, 1.622318931656033D-01/
      data wleb( 860),(gjk(i, 860),i=1,2)/
     &  2.471122223750674D-04,
     &  5.044274237060283D-01, 1.959581153836453D-01/
      data wleb( 861),(gjk(i, 861),i=1,2)/
     &  2.500291752486870D-04,
     &  5.387354077925727D-01, 2.294888081183837D-01/
      data wleb( 862),(gjk(i, 862),i=1,2)/
     &  2.521055942764682D-04,
     &  5.715768898356105D-01, 2.626031152713945D-01/
      data wleb( 863),(gjk(i, 863),i=1,2)/
     &  2.534472785575503D-04,
     &  6.028627200136111D-01, 2.950904075286713D-01/
      data wleb( 864),(gjk(i, 864),i=1,2)/
     &  2.541599713080121D-04,
     &  6.325039812653463D-01, 3.267458451113286D-01/
      data wleb( 865),(gjk(i, 865),i=1,2)/
     &  2.317380975862936D-04,
     &  3.981986708423407D-01, 3.183291458749821D-02/
      data wleb( 866),(gjk(i, 866),i=1,2)/
     &  2.378550733719775D-04,
     &  4.382791182133300D-01, 6.459548193880908D-02/
      data wleb( 867),(gjk(i, 867),i=1,2)/
     &  2.428884456739118D-04,
     &  4.769233057218166D-01, 9.795757037087952D-02/
      data wleb( 868),(gjk(i, 868),i=1,2)/
     &  2.469002655757292D-04,
     &  5.140823911194238D-01, 1.316307235126655D-01/
      data wleb( 869),(gjk(i, 869),i=1,2)/
     &  2.499657574265851D-04,
     &  5.496977833862983D-01, 1.653556486358704D-01/
      data wleb( 870),(gjk(i, 870),i=1,2)/
     &  2.521676168486082D-04,
     &  5.837047306512727D-01, 1.988931724126510D-01/
      data wleb( 871),(gjk(i, 871),i=1,2)/
     &  2.535935662645334D-04,
     &  6.160349566926879D-01, 2.320174581438950D-01/
      data wleb( 872),(gjk(i, 872),i=1,2)/
     &  2.543356743363214D-04,
     &  6.466185353209440D-01, 2.645106562168662D-01/
      data wleb( 873),(gjk(i, 873),i=1,2)/
     &  2.427353285201535D-04,
     &  4.810835158795404D-01, 3.275917807743992D-02/
      data wleb( 874),(gjk(i, 874),i=1,2)/
     &  2.468258039744386D-04,
     &  5.199925041324341D-01, 6.612546183967181D-02/
      data wleb( 875),(gjk(i, 875),i=1,2)/
     &  2.500060956440310D-04,
     &  5.571717692207494D-01, 9.981498331474142D-02/
      data wleb( 876),(gjk(i, 876),i=1,2)/
     &  2.523238365420979D-04,
     &  5.925789250836379D-01, 1.335687001410374D-01/
      data wleb( 877),(gjk(i, 877),i=1,2)/
     &  2.538399260252846D-04,
     &  6.261658523859670D-01, 1.671444402896463D-01/
      data wleb( 878),(gjk(i, 878),i=1,2)/
     &  2.546255927268069D-04,
     &  6.578811126669331D-01, 2.003106382156076D-01/
      data wleb( 879),(gjk(i, 879),i=1,2)/
     &  2.500583360048449D-04,
     &  5.609624612998100D-01, 3.337500940231335D-02/
      data wleb( 880),(gjk(i, 880),i=1,2)/
     &  2.524777638260203D-04,
     &  5.979959659984670D-01, 6.708750335901803D-02/
      data wleb( 881),(gjk(i, 881),i=1,2)/
     &  2.540951193860656D-04,
     &  6.330523711054002D-01, 1.008792126424850D-01/
      data wleb( 882),(gjk(i, 882),i=1,2)/
     &  2.549524085027472D-04,
     &  6.660960998103972D-01, 1.345050343171794D-01/
      data wleb( 883),(gjk(i, 883),i=1,2)/
     &  2.542569507009158D-04,
     &  6.365384364585819D-01, 3.372799460737052D-02/
      data wleb( 884),(gjk(i, 884),i=1,2)/
     &  2.552114127580376D-04,
     &  6.710994302899275D-01, 6.755249309678028D-02/
C
C   n = 125
C
      data wleb( 885),(gjk(i, 885),i=1,2)/
     &  9.687521879420705D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb( 886),(gjk(i, 886),i=1,2)/
     &  2.307897895367918D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 887),(gjk(i, 887),i=1,2)/
     &  2.297310852498558D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb( 888),(gjk(i, 888),i=1,2)/
     &  7.386265944001918D-05,
     &  2.335728608887064D-02, 2.335728608887064D-02/
      data wleb( 889),(gjk(i, 889),i=1,2)/
     &  8.257977698542210D-05,
     &  4.352987836550653D-02, 4.352987836550653D-02/
      data wleb( 890),(gjk(i, 890),i=1,2)/
     &  9.706044762057630D-05,
     &  6.439200521088800D-02, 6.439200521088800D-02/
      data wleb( 891),(gjk(i, 891),i=1,2)/
     &  1.302393847117003D-04,
     &  9.003943631993180D-02, 9.003943631993180D-02/
      data wleb( 892),(gjk(i, 892),i=1,2)/
     &  1.541957004600968D-04,
     &  1.196706615548473D-01, 1.196706615548473D-01/
      data wleb( 893),(gjk(i, 893),i=1,2)/
     &  1.704459770092199D-04,
     &  1.511715412838134D-01, 1.511715412838134D-01/
      data wleb( 894),(gjk(i, 894),i=1,2)/
     &  1.827374890942906D-04,
     &  1.835982828503801D-01, 1.835982828503801D-01/
      data wleb( 895),(gjk(i, 895),i=1,2)/
     &  1.926360817436107D-04,
     &  2.165081259155405D-01, 2.165081259155405D-01/
      data wleb( 896),(gjk(i, 896),i=1,2)/
     &  2.008010239494833D-04,
     &  2.496208720417563D-01, 2.496208720417563D-01/
      data wleb( 897),(gjk(i, 897),i=1,2)/
     &  2.075635983209175D-04,
     &  2.827200673567900D-01, 2.827200673567900D-01/
      data wleb( 898),(gjk(i, 898),i=1,2)/
     &  2.131306638690909D-04,
     &  3.156190823994346D-01, 3.156190823994346D-01/
      data wleb( 899),(gjk(i, 899),i=1,2)/
     &  2.176562329937335D-04,
     &  3.481476793749115D-01, 3.481476793749115D-01/
      data wleb( 900),(gjk(i, 900),i=1,2)/
     &  2.212682262991018D-04,
     &  3.801466086947226D-01, 3.801466086947226D-01/
      data wleb( 901),(gjk(i, 901),i=1,2)/
     &  2.240799515668565D-04,
     &  4.114652119634011D-01, 4.114652119634011D-01/
      data wleb( 902),(gjk(i, 902),i=1,2)/
     &  2.261959816187525D-04,
     &  4.419598786519751D-01, 4.419598786519751D-01/
      data wleb( 903),(gjk(i, 903),i=1,2)/
     &  2.277156368808855D-04,
     &  4.714925949329543D-01, 4.714925949329543D-01/
      data wleb( 904),(gjk(i, 904),i=1,2)/
     &  2.287351772128336D-04,
     &  4.999293972879466D-01, 4.999293972879466D-01/
      data wleb( 905),(gjk(i, 905),i=1,2)/
     &  2.293490814084085D-04,
     &  5.271387221431248D-01, 5.271387221431248D-01/
      data wleb( 906),(gjk(i, 906),i=1,2)/
     &  2.296505312376273D-04,
     &  5.529896780837761D-01, 5.529896780837761D-01/
      data wleb( 907),(gjk(i, 907),i=1,2)/
     &  2.296793832318756D-04,
     &  6.000856099481712D-01, 6.000856099481712D-01/
      data wleb( 908),(gjk(i, 908),i=1,2)/
     &  2.295785443842974D-04,
     &  6.210562192785175D-01, 6.210562192785175D-01/
      data wleb( 909),(gjk(i, 909),i=1,2)/
     &  2.295017931529102D-04,
     &  6.401165879934240D-01, 6.401165879934240D-01/
      data wleb( 910),(gjk(i, 910),i=1,2)/
     &  2.295059638184868D-04,
     &  6.571144029244333D-01, 6.571144029244333D-01/
      data wleb( 911),(gjk(i, 911),i=1,2)/
     &  2.296232343237362D-04,
     &  6.718910821718863D-01, 6.718910821718863D-01/
      data wleb( 912),(gjk(i, 912),i=1,2)/
     &  2.298530178740771D-04,
     &  6.842845591099010D-01, 6.842845591099010D-01/
      data wleb( 913),(gjk(i, 913),i=1,2)/
     &  2.301579790280501D-04,
     &  6.941353476269816D-01, 6.941353476269816D-01/
      data wleb( 914),(gjk(i, 914),i=1,2)/
     &  2.304690404996513D-04,
     &  7.012965242212991D-01, 7.012965242212991D-01/
      data wleb( 915),(gjk(i, 915),i=1,2)/
     &  2.307027995907102D-04,
     &  7.056471428242644D-01, 7.056471428242644D-01/
      data wleb( 916),(gjk(i, 916),i=1,2)/
     &  9.312274696671092D-05,
     &  4.595557643585895D-02, 0.000000000000000D+00/
      data wleb( 917),(gjk(i, 917),i=1,2)/
     &  1.199919385876926D-04,
     &  1.049316742435023D-01, 0.000000000000000D+00/
      data wleb( 918),(gjk(i, 918),i=1,2)/
     &  1.598039138877690D-04,
     &  1.773548879549274D-01, 0.000000000000000D+00/
      data wleb( 919),(gjk(i, 919),i=1,2)/
     &  1.822253763574900D-04,
     &  2.559071411236127D-01, 0.000000000000000D+00/
      data wleb( 920),(gjk(i, 920),i=1,2)/
     &  1.988579593655040D-04,
     &  3.358156837985898D-01, 0.000000000000000D+00/
      data wleb( 921),(gjk(i, 921),i=1,2)/
     &  2.112620102533307D-04,
     &  4.155835743763893D-01, 0.000000000000000D+00/
      data wleb( 922),(gjk(i, 922),i=1,2)/
     &  2.201594887699007D-04,
     &  4.937894296167472D-01, 0.000000000000000D+00/
      data wleb( 923),(gjk(i, 923),i=1,2)/
     &  2.261622590895036D-04,
     &  5.691569694793316D-01, 0.000000000000000D+00/
      data wleb( 924),(gjk(i, 924),i=1,2)/
     &  2.296458453435705D-04,
     &  6.405840854894251D-01, 0.000000000000000D+00/
      data wleb( 925),(gjk(i, 925),i=1,2)/
     &  1.006006990267000D-04,
     &  7.345133894143348D-02, 2.177844081486067D-02/
      data wleb( 926),(gjk(i, 926),i=1,2)/
     &  1.227676689635876D-04,
     &  1.009859834044931D-01, 4.590362185775188D-02/
      data wleb( 927),(gjk(i, 927),i=1,2)/
     &  1.467864280270117D-04,
     &  1.324289619748758D-01, 7.255063095690877D-02/
      data wleb( 928),(gjk(i, 928),i=1,2)/
     &  1.644178912101232D-04,
     &  1.654272109607127D-01, 1.017825451960684D-01/
      data wleb( 929),(gjk(i, 929),i=1,2)/
     &  1.777664890718961D-04,
     &  1.990767186776461D-01, 1.325652320980364D-01/
      data wleb( 930),(gjk(i, 930),i=1,2)/
     &  1.884825664516690D-04,
     &  2.330125945523278D-01, 1.642765374496765D-01/
      data wleb( 931),(gjk(i, 931),i=1,2)/
     &  1.973269246453848D-04,
     &  2.670080611108287D-01, 1.965360374337889D-01/
      data wleb( 932),(gjk(i, 932),i=1,2)/
     &  2.046767775855328D-04,
     &  3.008753376294316D-01, 2.290726770542238D-01/
      data wleb( 933),(gjk(i, 933),i=1,2)/
     &  2.107600125918040D-04,
     &  3.344475596167860D-01, 2.616645495370823D-01/
      data wleb( 934),(gjk(i, 934),i=1,2)/
     &  2.157416362266829D-04,
     &  3.675709724070786D-01, 2.941150728843141D-01/
      data wleb( 935),(gjk(i, 935),i=1,2)/
     &  2.197557816920721D-04,
     &  4.001000887587812D-01, 3.262440400919066D-01/
      data wleb( 936),(gjk(i, 936),i=1,2)/
     &  2.229192611835437D-04,
     &  4.318956350436028D-01, 3.578835350611916D-01/
      data wleb( 937),(gjk(i, 937),i=1,2)/
     &  2.253385110212775D-04,
     &  4.628239056795531D-01, 3.888751854043678D-01/
      data wleb( 938),(gjk(i, 938),i=1,2)/
     &  2.271137107548774D-04,
     &  4.927563229773636D-01, 4.190678003222840D-01/
      data wleb( 939),(gjk(i, 939),i=1,2)/
     &  2.283414092917525D-04,
     &  5.215687136707969D-01, 4.483151836883852D-01/
      data wleb( 940),(gjk(i, 940),i=1,2)/
     &  2.291161673130077D-04,
     &  5.491402346984905D-01, 4.764740676087880D-01/
      data wleb( 941),(gjk(i, 941),i=1,2)/
     &  2.295313908576598D-04,
     &  5.753520160126075D-01, 5.034021310998277D-01/
      data wleb( 942),(gjk(i, 942),i=1,2)/
     &  1.438204721359031D-04,
     &  1.388326356417754D-01, 2.435436510372806D-02/
      data wleb( 943),(gjk(i, 943),i=1,2)/
     &  1.607738025495257D-04,
     &  1.743686900537244D-01, 5.118897057342652D-02/
      data wleb( 944),(gjk(i, 944),i=1,2)/
     &  1.741483853528379D-04,
     &  2.099737037950268D-01, 8.014695048539634D-02/
      data wleb( 945),(gjk(i, 945),i=1,2)/
     &  1.851918467519151D-04,
     &  2.454492590908548D-01, 1.105117874155699D-01/
      data wleb( 946),(gjk(i, 946),i=1,2)/
     &  1.944628638070613D-04,
     &  2.807219257864278D-01, 1.417950531570966D-01/
      data wleb( 947),(gjk(i, 947),i=1,2)/
     &  2.022495446275152D-04,
     &  3.156842271975842D-01, 1.736604945719597D-01/
      data wleb( 948),(gjk(i, 948),i=1,2)/
     &  2.087462382438514D-04,
     &  3.502090945177752D-01, 2.058466324693981D-01/
      data wleb( 949),(gjk(i, 949),i=1,2)/
     &  2.141074754818308D-04,
     &  3.841684849519686D-01, 2.381284261195919D-01/
      data wleb( 950),(gjk(i, 950),i=1,2)/
     &  2.184640913748162D-04,
     &  4.174372367906016D-01, 2.703031270422569D-01/
      data wleb( 951),(gjk(i, 951),i=1,2)/
     &  2.219309165220329D-04,
     &  4.498926465011892D-01, 3.021845683091309D-01/
      data wleb( 952),(gjk(i, 952),i=1,2)/
     &  2.246123118340624D-04,
     &  4.814146229807701D-01, 3.335993355165720D-01/
      data wleb( 953),(gjk(i, 953),i=1,2)/
     &  2.266062766915125D-04,
     &  5.118863625734701D-01, 3.643833735518232D-01/
      data wleb( 954),(gjk(i, 954),i=1,2)/
     &  2.280072952230796D-04,
     &  5.411947455119144D-01, 3.943789541958179D-01/
      data wleb( 955),(gjk(i, 955),i=1,2)/
     &  2.289082025202583D-04,
     &  5.692301500357246D-01, 4.234320144403542D-01/
      data wleb( 956),(gjk(i, 956),i=1,2)/
     &  2.294012695120025D-04,
     &  5.958857204139576D-01, 4.513897947419260D-01/
      data wleb( 957),(gjk(i, 957),i=1,2)/
     &  1.722434488736947D-04,
     &  2.156270284785766D-01, 2.681225755444491D-02/
      data wleb( 958),(gjk(i, 958),i=1,2)/
     &  1.830237421455091D-04,
     &  2.532385054909710D-01, 5.557495747805614D-02/
      data wleb( 959),(gjk(i, 959),i=1,2)/
     &  1.923855349997633D-04,
     &  2.902564617771537D-01, 8.569368062950249D-02/
      data wleb( 960),(gjk(i, 960),i=1,2)/
     &  2.004067861936271D-04,
     &  3.266979823143256D-01, 1.167367450324135D-01/
      data wleb( 961),(gjk(i, 961),i=1,2)/
     &  2.071817297354263D-04,
     &  3.625039627493614D-01, 1.483861994003304D-01/
      data wleb( 962),(gjk(i, 962),i=1,2)/
     &  2.128250834102103D-04,
     &  3.975838937548699D-01, 1.803821503011405D-01/
      data wleb( 963),(gjk(i, 963),i=1,2)/
     &  2.174513719440102D-04,
     &  4.318396099009774D-01, 2.124962965666424D-01/
      data wleb( 964),(gjk(i, 964),i=1,2)/
     &  2.211661839150214D-04,
     &  4.651706555732742D-01, 2.445221837805913D-01/
      data wleb( 965),(gjk(i, 965),i=1,2)/
     &  2.240665257813102D-04,
     &  4.974752649620969D-01, 2.762701224322987D-01/
      data wleb( 966),(gjk(i, 966),i=1,2)/
     &  2.262439516632620D-04,
     &  5.286517579627517D-01, 3.075627775211328D-01/
      data wleb( 967),(gjk(i, 967),i=1,2)/
     &  2.277874557231869D-04,
     &  5.586001195731894D-01, 3.382311089826877D-01/
      data wleb( 968),(gjk(i, 968),i=1,2)/
     &  2.287854314454994D-04,
     &  5.872229902021319D-01, 3.681108834741399D-01/
      data wleb( 969),(gjk(i, 969),i=1,2)/
     &  2.293268499615575D-04,
     &  6.144258616235123D-01, 3.970397446872839D-01/
      data wleb( 970),(gjk(i, 970),i=1,2)/
     &  1.912628201529828D-04,
     &  2.951676508064861D-01, 2.867499538750441D-02/
      data wleb( 971),(gjk(i, 971),i=1,2)/
     &  1.992499672238701D-04,
     &  3.335085485472725D-01, 5.867879341903510D-02/
      data wleb( 972),(gjk(i, 972),i=1,2)/
     &  2.061275533454027D-04,
     &  3.709561760636381D-01, 8.961099205022284D-02/
      data wleb( 973),(gjk(i, 973),i=1,2)/
     &  2.119318215968572D-04,
     &  4.074722861667498D-01, 1.211627927626297D-01/
      data wleb( 974),(gjk(i, 974),i=1,2)/
     &  2.167416581882652D-04,
     &  4.429923648839117D-01, 1.530748903554898D-01/
      data wleb( 975),(gjk(i, 975),i=1,2)/
     &  2.206430730516600D-04,
     &  4.774428052721736D-01, 1.851176436721877D-01/
      data wleb( 976),(gjk(i, 976),i=1,2)/
     &  2.237186938699523D-04,
     &  5.107446539535904D-01, 2.170829107658179D-01/
      data wleb( 977),(gjk(i, 977),i=1,2)/
     &  2.260480075032884D-04,
     &  5.428151370542935D-01, 2.487786689026271D-01/
      data wleb( 978),(gjk(i, 978),i=1,2)/
     &  2.277098884558542D-04,
     &  5.735699292556964D-01, 2.800239952795016D-01/
      data wleb( 979),(gjk(i, 979),i=1,2)/
     &  2.287845715109671D-04,
     &  6.029253794562865D-01, 3.106445702878119D-01/
      data wleb( 980),(gjk(i, 980),i=1,2)/
     &  2.293547268236294D-04,
     &  6.307998987073145D-01, 3.404689500841194D-01/
      data wleb( 981),(gjk(i, 981),i=1,2)/
     &  2.056073839852528D-04,
     &  3.752652273692719D-01, 2.997145098184479D-02/
      data wleb( 982),(gjk(i, 982),i=1,2)/
     &  2.114235865831876D-04,
     &  4.135383879344028D-01, 6.086725898678011D-02/
      data wleb( 983),(gjk(i, 983),i=1,2)/
     &  2.163175629770551D-04,
     &  4.506113885153907D-01, 9.238849548435643D-02/
      data wleb( 984),(gjk(i, 984),i=1,2)/
     &  2.203392158111650D-04,
     &  4.864401554606072D-01, 1.242786603851851D-01/
      data wleb( 985),(gjk(i, 985),i=1,2)/
     &  2.235473176847839D-04,
     &  5.209708076611709D-01, 1.563086731483386D-01/
      data wleb( 986),(gjk(i, 986),i=1,2)/
     &  2.260024141501235D-04,
     &  5.541422135830122D-01, 1.882696509388506D-01/
      data wleb( 987),(gjk(i, 987),i=1,2)/
     &  2.277675929329182D-04,
     &  5.858880915113817D-01, 2.199672979126059D-01/
      data wleb( 988),(gjk(i, 988),i=1,2)/
     &  2.289102112284834D-04,
     &  6.161399390603444D-01, 2.512165482924867D-01/
      data wleb( 989),(gjk(i, 989),i=1,2)/
     &  2.295027954625118D-04,
     &  6.448296482255090D-01, 2.818368701871888D-01/
      data wleb( 990),(gjk(i, 990),i=1,2)/
     &  2.161281589879992D-04,
     &  4.544796274917948D-01, 3.088970405060312D-02/
      data wleb( 991),(gjk(i, 991),i=1,2)/
     &  2.201980477395102D-04,
     &  4.919389072146628D-01, 6.240947677636835D-02/
      data wleb( 992),(gjk(i, 992),i=1,2)/
     &  2.234952066593166D-04,
     &  5.279313026985183D-01, 9.430706144280313D-02/
      data wleb( 993),(gjk(i, 993),i=1,2)/
     &  2.260540098520838D-04,
     &  5.624169925571135D-01, 1.263547818770374D-01/
      data wleb( 994),(gjk(i, 994),i=1,2)/
     &  2.279157981899988D-04,
     &  5.953484627093287D-01, 1.583430788822594D-01/
      data wleb( 995),(gjk(i, 995),i=1,2)/
     &  2.291296918565571D-04,
     &  6.266730715339185D-01, 1.900748462555988D-01/
      data wleb( 996),(gjk(i, 996),i=1,2)/
     &  2.297533752536649D-04,
     &  6.563363204278871D-01, 2.213599519592567D-01/
      data wleb( 997),(gjk(i, 997),i=1,2)/
     &  2.234927356465995D-04,
     &  5.314574716585696D-01, 3.152508811515374D-02/
      data wleb( 998),(gjk(i, 998),i=1,2)/
     &  2.261288012985219D-04,
     &  5.674614932298185D-01, 6.343865291465561D-02/
      data wleb( 999),(gjk(i, 999),i=1,2)/
     &  2.280818160923688D-04,
     &  6.017706004970264D-01, 9.551503504223952D-02/
      data wleb(1000),(gjk(i,1000),i=1,2)/
     &  2.293773295180159D-04,
     &  6.343471270264178D-01, 1.275440099801196D-01/
      data wleb(1001),(gjk(i,1001),i=1,2)/
     &  2.300528767338634D-04,
     &  6.651494599127802D-01, 1.593252037671960D-01/
      data wleb(1002),(gjk(i,1002),i=1,2)/
     &  2.281893855065666D-04,
     &  6.050184986005704D-01, 3.192538338496105D-02/
      data wleb(1003),(gjk(i,1003),i=1,2)/
     &  2.295720444840727D-04,
     &  6.390163550880400D-01, 6.402824353962305D-02/
      data wleb(1004),(gjk(i,1004),i=1,2)/
     &  2.303227649026753D-04,
     &  6.711199107088448D-01, 9.609805077002909D-02/
      data wleb(1005),(gjk(i,1005),i=1,2)/
     &  2.304831913227114D-04,
     &  6.741354429572275D-01, 3.211853196273233D-02/
C
C   n = 125
C
      data wleb(1006),(gjk(i,1006),i=1,2)/
     &  9.080510764308163D-05,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(1007),(gjk(i,1007),i=1,2)/
     &  2.084824361987793D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(1008),(gjk(i,1008),i=1,2)/
     &  5.011105657239616D-05,
     &  2.303261686261450D-02, 2.303261686261450D-02/
      data wleb(1009),(gjk(i,1009),i=1,2)/
     &  5.942520409683854D-05,
     &  3.757208620162394D-02, 3.757208620162394D-02/
      data wleb(1010),(gjk(i,1010),i=1,2)/
     &  9.564394826109721D-05,
     &  5.821912033821852D-02, 5.821912033821852D-02/
      data wleb(1011),(gjk(i,1011),i=1,2)/
     &  1.185530657126338D-04,
     &  8.403127529194872D-02, 8.403127529194872D-02/
      data wleb(1012),(gjk(i,1012),i=1,2)/
     &  1.364510114230331D-04,
     &  1.122927798060578D-01, 1.122927798060578D-01/
      data wleb(1013),(gjk(i,1013),i=1,2)/
     &  1.505828825605415D-04,
     &  1.420125319192987D-01, 1.420125319192987D-01/
      data wleb(1014),(gjk(i,1014),i=1,2)/
     &  1.619298749867023D-04,
     &  1.726396437341978D-01, 1.726396437341978D-01/
      data wleb(1015),(gjk(i,1015),i=1,2)/
     &  1.712450504267789D-04,
     &  2.038170058115696D-01, 2.038170058115696D-01/
      data wleb(1016),(gjk(i,1016),i=1,2)/
     &  1.789891098164999D-04,
     &  2.352849892876508D-01, 2.352849892876508D-01/
      data wleb(1017),(gjk(i,1017),i=1,2)/
     &  1.854474955629795D-04,
     &  2.668363354312461D-01, 2.668363354312461D-01/
      data wleb(1018),(gjk(i,1018),i=1,2)/
     &  1.908148636673661D-04,
     &  2.982941279900452D-01, 2.982941279900452D-01/
      data wleb(1019),(gjk(i,1019),i=1,2)/
     &  1.952377405281833D-04,
     &  3.295002922087076D-01, 3.295002922087076D-01/
      data wleb(1020),(gjk(i,1020),i=1,2)/
     &  1.988349254282232D-04,
     &  3.603094918363593D-01, 3.603094918363593D-01/
      data wleb(1021),(gjk(i,1021),i=1,2)/
     &  2.017079807160050D-04,
     &  3.905857895173920D-01, 3.905857895173920D-01/
      data wleb(1022),(gjk(i,1022),i=1,2)/
     &  2.039473082709094D-04,
     &  4.202005758160837D-01, 4.202005758160837D-01/
      data wleb(1023),(gjk(i,1023),i=1,2)/
     &  2.056360279288953D-04,
     &  4.490310061597227D-01, 4.490310061597227D-01/
      data wleb(1024),(gjk(i,1024),i=1,2)/
     &  2.068525823066865D-04,
     &  4.769586160311491D-01, 4.769586160311491D-01/
      data wleb(1025),(gjk(i,1025),i=1,2)/
     &  2.076724877534488D-04,
     &  5.038679887049750D-01, 5.038679887049750D-01/
      data wleb(1026),(gjk(i,1026),i=1,2)/
     &  2.081694278237885D-04,
     &  5.296454286519962D-01, 5.296454286519962D-01/
      data wleb(1027),(gjk(i,1027),i=1,2)/
     &  2.084157631219326D-04,
     &  5.541776207164850D-01, 5.541776207164850D-01/
      data wleb(1028),(gjk(i,1028),i=1,2)/
     &  2.084381531128593D-04,
     &  5.990467321921213D-01, 5.990467321921213D-01/
      data wleb(1029),(gjk(i,1029),i=1,2)/
     &  2.083476277129307D-04,
     &  6.191467096294587D-01, 6.191467096294587D-01/
      data wleb(1030),(gjk(i,1030),i=1,2)/
     &  2.082686194459732D-04,
     &  6.375251212901849D-01, 6.375251212901849D-01/
      data wleb(1031),(gjk(i,1031),i=1,2)/
     &  2.082475686112415D-04,
     &  6.540514381131168D-01, 6.540514381131168D-01/
      data wleb(1032),(gjk(i,1032),i=1,2)/
     &  2.083139860289915D-04,
     &  6.685899064391509D-01, 6.685899064391509D-01/
      data wleb(1033),(gjk(i,1033),i=1,2)/
     &  2.084745561831237D-04,
     &  6.810013009681648D-01, 6.810013009681648D-01/
      data wleb(1034),(gjk(i,1034),i=1,2)/
     &  2.087091313375890D-04,
     &  6.911469578730340D-01, 6.911469578730340D-01/
      data wleb(1035),(gjk(i,1035),i=1,2)/
     &  2.089718413297697D-04,
     &  6.988956915141736D-01, 6.988956915141736D-01/
      data wleb(1036),(gjk(i,1036),i=1,2)/
     &  2.092003303479793D-04,
     &  7.041335794868721D-01, 7.041335794868721D-01/
      data wleb(1037),(gjk(i,1037),i=1,2)/
     &  2.093336148263241D-04,
     &  7.067754398018568D-01, 7.067754398018568D-01/
      data wleb(1038),(gjk(i,1038),i=1,2)/
     &  7.591708117365266D-05,
     &  3.840368707853623D-02, 0.000000000000000D+00/
      data wleb(1039),(gjk(i,1039),i=1,2)/
     &  1.083383968169186D-04,
     &  9.835485954117398D-02, 0.000000000000000D+00/
      data wleb(1040),(gjk(i,1040),i=1,2)/
     &  1.403019395292510D-04,
     &  1.665774947612998D-01, 0.000000000000000D+00/
      data wleb(1041),(gjk(i,1041),i=1,2)/
     &  1.615970179286436D-04,
     &  2.405702335362910D-01, 0.000000000000000D+00/
      data wleb(1042),(gjk(i,1042),i=1,2)/
     &  1.771144187504911D-04,
     &  3.165270770189046D-01, 0.000000000000000D+00/
      data wleb(1043),(gjk(i,1043),i=1,2)/
     &  1.887760022988168D-04,
     &  3.927386145645443D-01, 0.000000000000000D+00/
      data wleb(1044),(gjk(i,1044),i=1,2)/
     &  1.973474670768214D-04,
     &  4.678825918374656D-01, 0.000000000000000D+00/
      data wleb(1045),(gjk(i,1045),i=1,2)/
     &  2.033787661234659D-04,
     &  5.408022024266935D-01, 0.000000000000000D+00/
      data wleb(1046),(gjk(i,1046),i=1,2)/
     &  2.072343626517331D-04,
     &  6.104967445752438D-01, 0.000000000000000D+00/
      data wleb(1047),(gjk(i,1047),i=1,2)/
     &  2.091177834226918D-04,
     &  6.760910702685738D-01, 0.000000000000000D+00/
      data wleb(1048),(gjk(i,1048),i=1,2)/
     &  9.316684484675566D-05,
     &  6.655644120217392D-02, 1.936508874588424D-02/
      data wleb(1049),(gjk(i,1049),i=1,2)/
     &  1.116193688682976D-04,
     &  9.446246161270182D-02, 4.252442002115869D-02/
      data wleb(1050),(gjk(i,1050),i=1,2)/
     &  1.298623551559414D-04,
     &  1.242651925452509D-01, 6.806529315354375D-02/
      data wleb(1051),(gjk(i,1051),i=1,2)/
     &  1.450236832456426D-04,
     &  1.553438064846751D-01, 9.560957491205369D-02/
      data wleb(1052),(gjk(i,1052),i=1,2)/
     &  1.572719958149914D-04,
     &  1.871137110542670D-01, 1.245931657452888D-01/
      data wleb(1053),(gjk(i,1053),i=1,2)/
     &  1.673234785867195D-04,
     &  2.192612628836257D-01, 1.545385828778978D-01/
      data wleb(1054),(gjk(i,1054),i=1,2)/
     &  1.756860118725188D-04,
     &  2.515682807206955D-01, 1.851004249723368D-01/
      data wleb(1055),(gjk(i,1055),i=1,2)/
     &  1.826776290439367D-04,
     &  2.838535866287290D-01, 2.160182608272384D-01/
      data wleb(1056),(gjk(i,1056),i=1,2)/
     &  1.885116347992865D-04,
     &  3.159578817528521D-01, 2.470799012277111D-01/
      data wleb(1057),(gjk(i,1057),i=1,2)/
     &  1.933457860170574D-04,
     &  3.477370882791392D-01, 2.781014208986402D-01/
      data wleb(1058),(gjk(i,1058),i=1,2)/
     &  1.973060671902064D-04,
     &  3.790576960890540D-01, 3.089172523515731D-01/
      data wleb(1059),(gjk(i,1059),i=1,2)/
     &  2.004987099616311D-04,
     &  4.097938317810200D-01, 3.393750055472244D-01/
      data wleb(1060),(gjk(i,1060),i=1,2)/
     &  2.030170909281499D-04,
     &  4.398256572859637D-01, 3.693322470987730D-01/
      data wleb(1061),(gjk(i,1061),i=1,2)/
     &  2.049461460119080D-04,
     &  4.690384114718480D-01, 3.986541005609877D-01/
      data wleb(1062),(gjk(i,1062),i=1,2)/
     &  2.063653565200186D-04,
     &  4.973216048301053D-01, 4.272112491408562D-01/
      data wleb(1063),(gjk(i,1063),i=1,2)/
     &  2.073507927381027D-04,
     &  5.245681526132446D-01, 4.548781735309936D-01/
      data wleb(1064),(gjk(i,1064),i=1,2)/
     &  2.079764593256122D-04,
     &  5.506733911803888D-01, 4.815315355023251D-01/
      data wleb(1065),(gjk(i,1065),i=1,2)/
     &  2.083150534968778D-04,
     &  5.755339829522474D-01, 5.070486445801855D-01/
      data wleb(1066),(gjk(i,1066),i=1,2)/
     &  1.262715121590664D-04,
     &  1.305472386056362D-01, 2.284970375722366D-02/
      data wleb(1067),(gjk(i,1067),i=1,2)/
     &  1.414386128545972D-04,
     &  1.637327908216477D-01, 4.812254338288384D-02/
      data wleb(1068),(gjk(i,1068),i=1,2)/
     &  1.538740401313898D-04,
     &  1.972734634149637D-01, 7.531734457511935D-02/
      data wleb(1069),(gjk(i,1069),i=1,2)/
     &  1.642434942331432D-04,
     &  2.308694653110130D-01, 1.039043639882017D-01/
      data wleb(1070),(gjk(i,1070),i=1,2)/
     &  1.729790609237496D-04,
     &  2.643899218338160D-01, 1.334526587117626D-01/
      data wleb(1071),(gjk(i,1071),i=1,2)/
     &  1.803505190260828D-04,
     &  2.977171599622171D-01, 1.636414868936382D-01/
      data wleb(1072),(gjk(i,1072),i=1,2)/
     &  1.865475350079657D-04,
     &  3.307293903032310D-01, 1.942195406166568D-01/
      data wleb(1073),(gjk(i,1073),i=1,2)/
     &  1.917182669679069D-04,
     &  3.633069198219073D-01, 2.249752879943753D-01/
      data wleb(1074),(gjk(i,1074),i=1,2)/
     &  1.959851709034382D-04,
     &  3.953346955922727D-01, 2.557218821820032D-01/
      data wleb(1075),(gjk(i,1075),i=1,2)/
     &  1.994529548117882D-04,
     &  4.267018394184914D-01, 2.862897925213193D-01/
      data wleb(1076),(gjk(i,1076),i=1,2)/
     &  2.022138911146548D-04,
     &  4.573009622571704D-01, 3.165224536636518D-01/
      data wleb(1077),(gjk(i,1077),i=1,2)/
     &  2.043518024208592D-04,
     &  4.870279559856109D-01, 3.462730221636496D-01/
      data wleb(1078),(gjk(i,1078),i=1,2)/
     &  2.059450313018110D-04,
     &  5.157819581450322D-01, 3.754016870282835D-01/
      data wleb(1079),(gjk(i,1079),i=1,2)/
     &  2.070685715318472D-04,
     &  5.434651666465393D-01, 4.037733784993613D-01/
      data wleb(1080),(gjk(i,1080),i=1,2)/
     &  2.077955310694373D-04,
     &  5.699823887764627D-01, 4.312557784139123D-01/
      data wleb(1081),(gjk(i,1081),i=1,2)/
     &  2.081980387824712D-04,
     &  5.952403350947741D-01, 4.577175367122110D-01/
      data wleb(1082),(gjk(i,1082),i=1,2)/
     &  1.521318610377956D-04,
     &  2.025152599210369D-01, 2.520253617719557D-02/
      data wleb(1083),(gjk(i,1083),i=1,2)/
     &  1.622772720185755D-04,
     &  2.381066653274425D-01, 5.223254506119000D-02/
      data wleb(1084),(gjk(i,1084),i=1,2)/
     &  1.710498139420709D-04,
     &  2.732823383651612D-01, 8.060669688588620D-02/
      data wleb(1085),(gjk(i,1085),i=1,2)/
     &  1.785911149448736D-04,
     &  3.080137692611118D-01, 1.099335754081255D-01/
      data wleb(1086),(gjk(i,1086),i=1,2)/
     &  1.850125313687736D-04,
     &  3.422405614587601D-01, 1.399120955959857D-01/
      data wleb(1087),(gjk(i,1087),i=1,2)/
     &  1.904229703933298D-04,
     &  3.758808773890420D-01, 1.702977801651705D-01/
      data wleb(1088),(gjk(i,1088),i=1,2)/
     &  1.949259956121987D-04,
     &  4.088458383438932D-01, 2.008799256601680D-01/
      data wleb(1089),(gjk(i,1089),i=1,2)/
     &  1.986161545363960D-04,
     &  4.410450550841152D-01, 2.314703052180836D-01/
      data wleb(1090),(gjk(i,1090),i=1,2)/
     &  2.015790585641370D-04,
     &  4.723879420561312D-01, 2.618972111375892D-01/
      data wleb(1091),(gjk(i,1091),i=1,2)/
     &  2.038934198707418D-04,
     &  5.027843561874343D-01, 2.920013195600270D-01/
      data wleb(1092),(gjk(i,1092),i=1,2)/
     &  2.056334060538251D-04,
     &  5.321453674452458D-01, 3.216322555190551D-01/
      data wleb(1093),(gjk(i,1093),i=1,2)/
     &  2.068705959462289D-04,
     &  5.603839113834030D-01, 3.506456615934198D-01/
      data wleb(1094),(gjk(i,1094),i=1,2)/
     &  2.076753906106002D-04,
     &  5.874150706875146D-01, 3.789007181306267D-01/
      data wleb(1095),(gjk(i,1095),i=1,2)/
     &  2.081179391734803D-04,
     &  6.131559381660038D-01, 4.062580170572782D-01/
      data wleb(1096),(gjk(i,1096),i=1,2)/
     &  1.700345216228943D-04,
     &  2.778497016394506D-01, 2.696271276876226D-02/
      data wleb(1097),(gjk(i,1097),i=1,2)/
     &  1.774906779990410D-04,
     &  3.143733562261912D-01, 5.523469316960465D-02/
      data wleb(1098),(gjk(i,1098),i=1,2)/
     &  1.839659377002642D-04,
     &  3.501485810261827D-01, 8.445193201626464D-02/
      data wleb(1099),(gjk(i,1099),i=1,2)/
     &  1.894987462975169D-04,
     &  3.851430322303653D-01, 1.143263119336083D-01/
      data wleb(1100),(gjk(i,1100),i=1,2)/
     &  1.941548809452595D-04,
     &  4.193013979470415D-01, 1.446177898344475D-01/
      data wleb(1101),(gjk(i,1101),i=1,2)/
     &  1.980078427252384D-04,
     &  4.525585960458567D-01, 1.751165438438091D-01/
      data wleb(1102),(gjk(i,1102),i=1,2)/
     &  2.011296284744488D-04,
     &  4.848447779622947D-01, 2.056338306745660D-01/
      data wleb(1103),(gjk(i,1103),i=1,2)/
     &  2.035888456966776D-04,
     &  5.160871208276894D-01, 2.359965487229226D-01/
      data wleb(1104),(gjk(i,1104),i=1,2)/
     &  2.054516325352142D-04,
     &  5.462112185696926D-01, 2.660430223139146D-01/
      data wleb(1105),(gjk(i,1105),i=1,2)/
     &  2.067831033092635D-04,
     &  5.751425068101756D-01, 2.956193664498032D-01/
      data wleb(1106),(gjk(i,1106),i=1,2)/
     &  2.076485320284876D-04,
     &  6.028073872853597D-01, 3.245763905312779D-01/
      data wleb(1107),(gjk(i,1107),i=1,2)/
     &  2.081141439525255D-04,
     &  6.291338275278409D-01, 3.527670026206972D-01/
      data wleb(1108),(gjk(i,1108),i=1,2)/
     &  1.834383015469222D-04,
     &  3.541797528439391D-01, 2.823853479435550D-02/
      data wleb(1109),(gjk(i,1109),i=1,2)/
     &  1.889540591777677D-04,
     &  3.908234972074657D-01, 5.741296374713106D-02/
      data wleb(1110),(gjk(i,1110),i=1,2)/
     &  1.936677023597375D-04,
     &  4.264408450107590D-01, 8.724646633650199D-02/
      data wleb(1111),(gjk(i,1111),i=1,2)/
     &  1.976176495066504D-04,
     &  4.609949666553286D-01, 1.175034422915616D-01/
      data wleb(1112),(gjk(i,1112),i=1,2)/
     &  2.008536004560983D-04,
     &  4.944389496536006D-01, 1.479755652628428D-01/
      data wleb(1113),(gjk(i,1113),i=1,2)/
     &  2.034280351712291D-04,
     &  5.267194884346086D-01, 1.784740659484352D-01/
      data wleb(1114),(gjk(i,1114),i=1,2)/
     &  2.053944466027758D-04,
     &  5.577787810220990D-01, 2.088245700431244D-01/
      data wleb(1115),(gjk(i,1115),i=1,2)/
     &  2.068077642882360D-04,
     &  5.875563763536670D-01, 2.388628136570763D-01/
      data wleb(1116),(gjk(i,1116),i=1,2)/
     &  2.077250949661599D-04,
     &  6.159910016391269D-01, 2.684308928769185D-01/
      data wleb(1117),(gjk(i,1117),i=1,2)/
     &  2.082062440705320D-04,
     &  6.430219602956267D-01, 2.973740761960252D-01/
      data wleb(1118),(gjk(i,1118),i=1,2)/
     &  1.934374486546626D-04,
     &  4.300647036213646D-01, 2.916399920493977D-02/
      data wleb(1119),(gjk(i,1119),i=1,2)/
     &  1.974107010484300D-04,
     &  4.661486308935531D-01, 5.898803024755659D-02/
      data wleb(1120),(gjk(i,1120),i=1,2)/
     &  2.007129290388658D-04,
     &  5.009658555287261D-01, 8.924162698525409D-02/
      data wleb(1121),(gjk(i,1121),i=1,2)/
     &  2.033736947471293D-04,
     &  5.344824270447704D-01, 1.197185199637321D-01/
      data wleb(1122),(gjk(i,1122),i=1,2)/
     &  2.054287125902493D-04,
     &  5.666575997416371D-01, 1.502300756161382D-01/
      data wleb(1123),(gjk(i,1123),i=1,2)/
     &  2.069184936818894D-04,
     &  5.974457471404752D-01, 1.806004191913564D-01/
      data wleb(1124),(gjk(i,1124),i=1,2)/
     &  2.078883689808782D-04,
     &  6.267984444116886D-01, 2.106621764786252D-01/
      data wleb(1125),(gjk(i,1125),i=1,2)/
     &  2.083886366116359D-04,
     &  6.546664713575417D-01, 2.402526932671914D-01/
      data wleb(1126),(gjk(i,1126),i=1,2)/
     &  2.006593275470817D-04,
     &  5.042711004437253D-01, 2.982529203607657D-02/
      data wleb(1127),(gjk(i,1127),i=1,2)/
     &  2.033728426135397D-04,
     &  5.392127456774380D-01, 6.008728062339922D-02/
      data wleb(1128),(gjk(i,1128),i=1,2)/
     &  2.055008781377608D-04,
     &  5.726819437668618D-01, 9.058227674571398D-02/
      data wleb(1129),(gjk(i,1129),i=1,2)/
     &  2.070651783518502D-04,
     &  6.046469254207278D-01, 1.211219235803400D-01/
      data wleb(1130),(gjk(i,1130),i=1,2)/
     &  2.080953335094320D-04,
     &  6.350716157434952D-01, 1.515286404791580D-01/
      data wleb(1131),(gjk(i,1131),i=1,2)/
     &  2.086284998988521D-04,
     &  6.639177679185454D-01, 1.816314681255552D-01/
      data wleb(1132),(gjk(i,1132),i=1,2)/
     &  2.055549387644668D-04,
     &  5.757276040972253D-01, 3.026991752575440D-02/
      data wleb(1133),(gjk(i,1133),i=1,2)/
     &  2.071871850267654D-04,
     &  6.090265823139756D-01, 6.078402297870770D-02/
      data wleb(1134),(gjk(i,1134),i=1,2)/
     &  2.082856600431965D-04,
     &  6.406735344387661D-01, 9.135459984176636D-02/
      data wleb(1135),(gjk(i,1135),i=1,2)/
     &  2.088705858819358D-04,
     &  6.706397927793709D-01, 1.218024155966590D-01/
      data wleb(1136),(gjk(i,1136),i=1,2)/
     &  2.083995867536322D-04,
     &  6.435019674426665D-01, 3.052608357660639D-02/
      data wleb(1137),(gjk(i,1137),i=1,2)/
     &  2.090509712889637D-04,
     &  6.747218676375681D-01, 6.112185773983089D-02/
C
C   n = 131
C
      data wleb(1138),(gjk(i,1138),i=1,2)/
     &  9.735347946175486D-06,
     &  1.000000000000000D+00, 0.000000000000000D+00/
      data wleb(1139),(gjk(i,1139),i=1,2)/
     &  1.907581241803167D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(1140),(gjk(i,1140),i=1,2)/
     &  1.901059546737578D-04,
     &  1.000000000000000D+00, 1.000000000000000D+00/
      data wleb(1141),(gjk(i,1141),i=1,2)/
     &  3.926424538919212D-05,
     &  1.182361662400277D-02, 1.182361662400277D-02/
      data wleb(1142),(gjk(i,1142),i=1,2)/
     &  6.667905467294381D-05,
     &  3.062145009138958D-02, 3.062145009138958D-02/
      data wleb(1143),(gjk(i,1143),i=1,2)/
     &  8.868891315019136D-05,
     &  5.329794036834243D-02, 5.329794036834243D-02/
      data wleb(1144),(gjk(i,1144),i=1,2)/
     &  1.066306000958872D-04,
     &  7.848165532862220D-02, 7.848165532862220D-02/
      data wleb(1145),(gjk(i,1145),i=1,2)/
     &  1.214506743336128D-04,
     &  1.054038157636201D-01, 1.054038157636201D-01/
      data wleb(1146),(gjk(i,1146),i=1,2)/
     &  1.338054681640871D-04,
     &  1.335577797766211D-01, 1.335577797766211D-01/
      data wleb(1147),(gjk(i,1147),i=1,2)/
     &  1.441677023628504D-04,
     &  1.625769955502252D-01, 1.625769955502252D-01/
      data wleb(1148),(gjk(i,1148),i=1,2)/
     &  1.528880200826557D-04,
     &  1.921787193412792D-01, 1.921787193412792D-01/
      data wleb(1149),(gjk(i,1149),i=1,2)/
     &  1.602330623773609D-04,
     &  2.221340534690548D-01, 2.221340534690548D-01/
      data wleb(1150),(gjk(i,1150),i=1,2)/
     &  1.664102653445244D-04,
     &  2.522504912791132D-01, 2.522504912791132D-01/
      data wleb(1151),(gjk(i,1151),i=1,2)/
     &  1.715845854011323D-04,
     &  2.823610860679697D-01, 2.823610860679697D-01/
      data wleb(1152),(gjk(i,1152),i=1,2)/
     &  1.758901000133069D-04,
     &  3.123173966267560D-01, 3.123173966267560D-01/
      data wleb(1153),(gjk(i,1153),i=1,2)/
     &  1.794382485256736D-04,
     &  3.419847036953789D-01, 3.419847036953789D-01/
      data wleb(1154),(gjk(i,1154),i=1,2)/
     &  1.823238106757407D-04,
     &  3.712386456999758D-01, 3.712386456999758D-01/
      data wleb(1155),(gjk(i,1155),i=1,2)/
     &  1.846293252959976D-04,
     &  3.999627649876828D-01, 3.999627649876828D-01/
      data wleb(1156),(gjk(i,1156),i=1,2)/
     &  1.864284079323098D-04,
     &  4.280466458648093D-01, 4.280466458648093D-01/
      data wleb(1157),(gjk(i,1157),i=1,2)/
     &  1.877882694626914D-04,
     &  4.553844360185711D-01, 4.553844360185711D-01/
      data wleb(1158),(gjk(i,1158),i=1,2)/
     &  1.887716321852025D-04,
     &  4.818736094437834D-01, 4.818736094437834D-01/
      data wleb(1159),(gjk(i,1159),i=1,2)/
     &  1.894381638175673D-04,
     &  5.074138709260629D-01, 5.074138709260629D-01/
      data wleb(1160),(gjk(i,1160),i=1,2)/
     &  1.898454899533629D-04,
     &  5.319061304570707D-01, 5.319061304570707D-01/
      data wleb(1161),(gjk(i,1161),i=1,2)/
     &  1.900497929577815D-04,
     &  5.552514978677286D-01, 5.552514978677286D-01/
      data wleb(1162),(gjk(i,1162),i=1,2)/
     &  1.900671501924092D-04,
     &  5.981009025246183D-01, 5.981009025246183D-01/
      data wleb(1163),(gjk(i,1163),i=1,2)/
     &  1.899837555533510D-04,
     &  6.173990192228116D-01, 6.173990192228116D-01/
      data wleb(1164),(gjk(i,1164),i=1,2)/
     &  1.899014113156229D-04,
     &  6.351365239411131D-01, 6.351365239411131D-01/
      data wleb(1165),(gjk(i,1165),i=1,2)/
     &  1.898581257705106D-04,
     &  6.512010228227200D-01, 6.512010228227200D-01/
      data wleb(1166),(gjk(i,1166),i=1,2)/
     &  1.898804756095753D-04,
     &  6.654758363948120D-01, 6.654758363948120D-01/
      data wleb(1167),(gjk(i,1167),i=1,2)/
     &  1.899793610426402D-04,
     &  6.778410414853370D-01, 6.778410414853370D-01/
      data wleb(1168),(gjk(i,1168),i=1,2)/
     &  1.901464554844117D-04,
     &  6.881760887484110D-01, 6.881760887484110D-01/
      data wleb(1169),(gjk(i,1169),i=1,2)/
     &  1.903533246259542D-04,
     &  6.963645267094598D-01, 6.963645267094598D-01/
      data wleb(1170),(gjk(i,1170),i=1,2)/
     &  1.905556158463228D-04,
     &  7.023010617153579D-01, 7.023010617153579D-01/
      data wleb(1171),(gjk(i,1171),i=1,2)/
     &  1.907037155663528D-04,
     &  7.059004636628753D-01, 7.059004636628753D-01/
      data wleb(1172),(gjk(i,1172),i=1,2)/
     &  5.992997844249967D-05,
     &  3.552470312472575D-02, 0.000000000000000D+00/
      data wleb(1173),(gjk(i,1173),i=1,2)/
     &  9.749059382456977D-05,
     &  9.151176620841284D-02, 0.000000000000000D+00/
      data wleb(1174),(gjk(i,1174),i=1,2)/
     &  1.241680804599158D-04,
     &  1.566197930068980D-01, 0.000000000000000D+00/
      data wleb(1175),(gjk(i,1175),i=1,2)/
     &  1.437626154299360D-04,
     &  2.265467599271907D-01, 0.000000000000000D+00/
      data wleb(1176),(gjk(i,1176),i=1,2)/
     &  1.584200054793902D-04,
     &  2.988242318581361D-01, 0.000000000000000D+00/
      data wleb(1177),(gjk(i,1177),i=1,2)/
     &  1.694436550982744D-04,
     &  3.717482419703886D-01, 0.000000000000000D+00/
      data wleb(1178),(gjk(i,1178),i=1,2)/
     &  1.776617014018108D-04,
     &  4.440094491758889D-01, 0.000000000000000D+00/
      data wleb(1179),(gjk(i,1179),i=1,2)/
     &  1.836132434440077D-04,
     &  5.145337096756643D-01, 0.000000000000000D+00/
      data wleb(1180),(gjk(i,1180),i=1,2)/
     &  1.876494727075983D-04,
     &  5.824053672860230D-01, 0.000000000000000D+00/
      data wleb(1181),(gjk(i,1181),i=1,2)/
     &  1.899906535336482D-04,
     &  6.468283961043370D-01, 0.000000000000000D+00/
      data wleb(1182),(gjk(i,1182),i=1,2)/
     &  8.143252820767350D-05,
     &  6.095964259104373D-02, 1.787828275342931D-02/
      data wleb(1183),(gjk(i,1183),i=1,2)/
     &  9.998859890887728D-05,
     &  8.811962270959388D-02, 3.953888740792096D-02/
      data wleb(1184),(gjk(i,1184),i=1,2)/
     &  1.156199403068359D-04,
     &  1.165936722428831D-01, 6.378121797722990D-02/
      data wleb(1185),(gjk(i,1185),i=1,2)/
     &  1.287632092635513D-04,
     &  1.460232857031785D-01, 8.985890813745037D-02/
      data wleb(1186),(gjk(i,1186),i=1,2)/
     &  1.398378643365139D-04,
     &  1.761197110181755D-01, 1.172606510576162D-01/
      data wleb(1187),(gjk(i,1187),i=1,2)/
     &  1.491876468417391D-04,
     &  2.066471190463718D-01, 1.456102876970995D-01/
      data wleb(1188),(gjk(i,1188),i=1,2)/
     &  1.570855679175456D-04,
     &  2.374076026328152D-01, 1.746153823011775D-01/
      data wleb(1189),(gjk(i,1189),i=1,2)/
     &  1.637483948103775D-04,
     &  2.682305474337051D-01, 2.040383070295584D-01/
      data wleb(1190),(gjk(i,1190),i=1,2)/
     &  1.693500566632843D-04,
     &  2.989653312142369D-01, 2.336788634003698D-01/
      data wleb(1191),(gjk(i,1191),i=1,2)/
     &  1.740322769393633D-04,
     &  3.294762752772209D-01, 2.633632752654219D-01/
      data wleb(1192),(gjk(i,1192),i=1,2)/
     &  1.779126637278296D-04,
     &  3.596390887276086D-01, 2.929369098051601D-01/
      data wleb(1193),(gjk(i,1193),i=1,2)/
     &  1.810908108835412D-04,
     &  3.893383046398812D-01, 3.222592785275512D-01/
      data wleb(1194),(gjk(i,1194),i=1,2)/
     &  1.836529132600190D-04,
     &  4.184653789358347D-01, 3.512004791195743D-01/
      data wleb(1195),(gjk(i,1195),i=1,2)/
     &  1.856752841777379D-04,
     &  4.469172319076166D-01, 3.796385677684537D-01/
      data wleb(1196),(gjk(i,1196),i=1,2)/
     &  1.872270566606832D-04,
     &  4.745950813276976D-01, 4.074575378263879D-01/
      data wleb(1197),(gjk(i,1197),i=1,2)/
     &  1.883722645591307D-04,
     &  5.014034601410262D-01, 4.345456906027828D-01/
      data wleb(1198),(gjk(i,1198),i=1,2)/
     &  1.891714324525297D-04,
     &  5.272493404551239D-01, 4.607942515205134D-01/
      data wleb(1199),(gjk(i,1199),i=1,2)/
     &  1.896827480450146D-04,
     &  5.520413051846366D-01, 4.860961284181720D-01/
      data wleb(1200),(gjk(i,1200),i=1,2)/
     &  1.899628417059528D-04,
     &  5.756887237503077D-01, 5.103447395342789D-01/
      data wleb(1201),(gjk(i,1201),i=1,2)/
     &  1.123301829001669D-04,
     &  1.225039430588352D-01, 2.136455922655793D-02/
      data wleb(1202),(gjk(i,1202),i=1,2)/
     &  1.253698826711277D-04,
     &  1.539113217321372D-01, 4.520926166137188D-02/
      data wleb(1203),(gjk(i,1203),i=1,2)/
     &  1.366266117678531D-04,
     &  1.856213098637712D-01, 7.086468177864819D-02/
      data wleb(1204),(gjk(i,1204),i=1,2)/
     &  1.462736856106918D-04,
     &  2.174998728035131D-01, 9.785239488772918D-02/
      data wleb(1205),(gjk(i,1205),i=1,2)/
     &  1.545076466685412D-04,
     &  2.494128336938330D-01, 1.258106396267210D-01/
      data wleb(1206),(gjk(i,1206),i=1,2)/
     &  1.615096280814007D-04,
     &  2.812321562143480D-01, 1.544529125047001D-01/
      data wleb(1207),(gjk(i,1207),i=1,2)/
     &  1.674366639741759D-04,
     &  3.128372276456111D-01, 1.835433512202753D-01/
      data wleb(1208),(gjk(i,1208),i=1,2)/
     &  1.724225002437900D-04,
     &  3.441145160177973D-01, 2.128813258619585D-01/
      data wleb(1209),(gjk(i,1209),i=1,2)/
     &  1.765810822987288D-04,
     &  3.749567714853510D-01, 2.422913734880829D-01/
      data wleb(1210),(gjk(i,1210),i=1,2)/
     &  1.800104126010751D-04,
     &  4.052621732015610D-01, 2.716163748391453D-01/
      data wleb(1211),(gjk(i,1211),i=1,2)/
     &  1.827960437331284D-04,
     &  4.349335453522385D-01, 3.007127671240280D-01/
      data wleb(1212),(gjk(i,1212),i=1,2)/
     &  1.850140300716308D-04,
     &  4.638776641524965D-01, 3.294470677216479D-01/
      data wleb(1213),(gjk(i,1213),i=1,2)/
     &  1.867333507394938D-04,
     &  4.920046410462687D-01, 3.576932543699155D-01/
      data wleb(1214),(gjk(i,1214),i=1,2)/
     &  1.880178688638289D-04,
     &  5.192273554861704D-01, 3.853307059757764D-01/
      data wleb(1215),(gjk(i,1215),i=1,2)/
     &  1.889278925654758D-04,
     &  5.454609081136522D-01, 4.122425044452694D-01/
      data wleb(1216),(gjk(i,1216),i=1,2)/
     &  1.895213832507346D-04,
     &  5.706220661424140D-01, 4.383139587781027D-01/
      data wleb(1217),(gjk(i,1217),i=1,2)/
     &  1.898548277397420D-04,
     &  5.946286755181518D-01, 4.634312536300553D-01/
      data wleb(1218),(gjk(i,1218),i=1,2)/
     &  1.349105935937341D-04,
     &  1.905370790924295D-01, 2.371311537781979D-02/
      data wleb(1219),(gjk(i,1219),i=1,2)/
     &  1.444060068369326D-04,
     &  2.242518717748009D-01, 4.917878059254806D-02/
      data wleb(1220),(gjk(i,1220),i=1,2)/
     &  1.526797390930008D-04,
     &  2.577190808025936D-01, 7.595498960495142D-02/
      data wleb(1221),(gjk(i,1221),i=1,2)/
     &  1.598208771406474D-04,
     &  2.908724534927187D-01, 1.036991083191100D-01/
      data wleb(1222),(gjk(i,1222),i=1,2)/
     &  1.659354368615331D-04,
     &  3.236354020056219D-01, 1.321348584450234D-01/
      data wleb(1223),(gjk(i,1223),i=1,2)/
     &  1.711279910946440D-04,
     &  3.559267359304543D-01, 1.610316571314789D-01/
      data wleb(1224),(gjk(i,1224),i=1,2)/
     &  1.754952725601440D-04,
     &  3.876637123676956D-01, 1.901912080395707D-01/
      data wleb(1225),(gjk(i,1225),i=1,2)/
     &  1.791247850802529D-04,
     &  4.187636705218842D-01, 2.194384950137950D-01/
      data wleb(1226),(gjk(i,1226),i=1,2)/
     &  1.820954300877716D-04,
     &  4.491449019883107D-01, 2.486155334763858D-01/
      data wleb(1227),(gjk(i,1227),i=1,2)/
     &  1.844788524548449D-04,
     &  4.787270932425445D-01, 2.775768931812335D-01/
      data wleb(1228),(gjk(i,1228),i=1,2)/
     &  1.863409481706220D-04,
     &  5.074315153055574D-01, 3.061863786591120D-01/
      data wleb(1229),(gjk(i,1229),i=1,2)/
     &  1.877433008795068D-04,
     &  5.351810507738336D-01, 3.343144718152556D-01/
      data wleb(1230),(gjk(i,1230),i=1,2)/
     &  1.887444543705232D-04,
     &  5.619001025975381D-01, 3.618362729028427D-01/
      data wleb(1231),(gjk(i,1231),i=1,2)/
     &  1.894009829375006D-04,
     &  5.875144035268046D-01, 3.886297583620408D-01/
      data wleb(1232),(gjk(i,1232),i=1,2)/
     &  1.897683345035198D-04,
     &  6.119507308734495D-01, 4.145742277792031D-01/
      data wleb(1233),(gjk(i,1233),i=1,2)/
     &  1.517327037467653D-04,
     &  2.619733870119463D-01, 2.540047186389353D-02/
      data wleb(1234),(gjk(i,1234),i=1,2)/
     &  1.587740557483543D-04,
     &  2.968149743237949D-01, 5.208107018543989D-02/
      data wleb(1235),(gjk(i,1235),i=1,2)/
     &  1.649093382274097D-04,
     &  3.310451504860488D-01, 7.971828470885599D-02/
      data wleb(1236),(gjk(i,1236),i=1,2)/
     &  1.701915216193265D-04,
     &  3.646215567376676D-01, 1.080465999177927D-01/
      data wleb(1237),(gjk(i,1237),i=1,2)/
     &  1.746847753144065D-04,
     &  3.974916785279360D-01, 1.368413849366629D-01/
      data wleb(1238),(gjk(i,1238),i=1,2)/
     &  1.784555512007570D-04,
     &  4.295967403772029D-01, 1.659073184763559D-01/
      data wleb(1239),(gjk(i,1239),i=1,2)/
     &  1.815687562112174D-04,
     &  4.608742854473447D-01, 1.950703730454614D-01/
      data wleb(1240),(gjk(i,1240),i=1,2)/
     &  1.840864370663302D-04,
     &  4.912598858949903D-01, 2.241721144376724D-01/
      data wleb(1241),(gjk(i,1241),i=1,2)/
     &  1.860676785390006D-04,
     &  5.206882758945558D-01, 2.530655255406489D-01/
      data wleb(1242),(gjk(i,1242),i=1,2)/
     &  1.875690583743703D-04,
     &  5.490940914019820D-01, 2.816118409731066D-01/
      data wleb(1243),(gjk(i,1243),i=1,2)/
     &  1.886453236347225D-04,
     &  5.764123302025542D-01, 3.096780504593238D-01/
      data wleb(1244),(gjk(i,1244),i=1,2)/
     &  1.893501123329645D-04,
     &  6.025786004213506D-01, 3.371348366394987D-01/
      data wleb(1245),(gjk(i,1245),i=1,2)/
     &  1.897366184519868D-04,
     &  6.275291964794956D-01, 3.638547827694396D-01/
      data wleb(1246),(gjk(i,1246),i=1,2)/
     &  1.643908815152736D-04,
     &  3.348189479861771D-01, 2.664841935537443D-02/
      data wleb(1247),(gjk(i,1247),i=1,2)/
     &  1.696300350907768D-04,
     &  3.699515545855295D-01, 5.424000066843495D-02/
      data wleb(1248),(gjk(i,1248),i=1,2)/
     &  1.741553103844483D-04,
     &  4.042003071474669D-01, 8.251992715430854D-02/
      data wleb(1249),(gjk(i,1249),i=1,2)/
     &  1.780015282386092D-04,
     &  4.375320100182624D-01, 1.112695182483710D-01/
      data wleb(1250),(gjk(i,1250),i=1,2)/
     &  1.812116787077125D-04,
     &  4.699054490335947D-01, 1.402964116467816D-01/
      data wleb(1251),(gjk(i,1251),i=1,2)/
     &  1.838323158085421D-04,
     &  5.012739879431952D-01, 1.694275117584291D-01/
      data wleb(1252),(gjk(i,1252),i=1,2)/
     &  1.859113119837737D-04,
     &  5.315874883754966D-01, 1.985038235312689D-01/
      data wleb(1253),(gjk(i,1253),i=1,2)/
     &  1.874969220221698D-04,
     &  5.607937109622116D-01, 2.273765660020893D-01/
      data wleb(1254),(gjk(i,1254),i=1,2)/
     &  1.886375612681076D-04,
     &  5.888393223495521D-01, 2.559041492849764D-01/
      data wleb(1255),(gjk(i,1255),i=1,2)/
     &  1.893819575809276D-04,
     &  6.156705979160163D-01, 2.839497251976899D-01/
      data wleb(1256),(gjk(i,1256),i=1,2)/
     &  1.897794748256767D-04,
     &  6.412338809078123D-01, 3.113791060500690D-01/
      data wleb(1257),(gjk(i,1257),i=1,2)/
     &  1.738963926584846D-04,
     &  4.076051259257167D-01, 2.757792290858463D-02/
      data wleb(1258),(gjk(i,1258),i=1,2)/
     &  1.777442359873466D-04,
     &  4.423788125791520D-01, 5.584136834984293D-02/
      data wleb(1259),(gjk(i,1259),i=1,2)/
     &  1.810010815068719D-04,
     &  4.760480917328258D-01, 8.457772087727143D-02/
      data wleb(1260),(gjk(i,1260),i=1,2)/
     &  1.836920318248129D-04,
     &  5.085838725946297D-01, 1.135975846359248D-01/
      data wleb(1261),(gjk(i,1261),i=1,2)/
     &  1.858489473214328D-04,
     &  5.399513637391218D-01, 1.427286904765053D-01/
      data wleb(1262),(gjk(i,1262),i=1,2)/
     &  1.875079342496592D-04,
     &  5.701118433636380D-01, 1.718112740057635D-01/
      data wleb(1263),(gjk(i,1263),i=1,2)/
     &  1.887080239102310D-04,
     &  5.990240530606021D-01, 2.006944855985351D-01/
      data wleb(1264),(gjk(i,1264),i=1,2)/
     &  1.894905752176822D-04,
     &  6.266452685139695D-01, 2.292335090598907D-01/
      data wleb(1265),(gjk(i,1265),i=1,2)/
     &  1.898991061200695D-04,
     &  6.529320971415942D-01, 2.572871512353714D-01/
      data wleb(1266),(gjk(i,1266),i=1,2)/
     &  1.809065016458791D-04,
     &  4.791583834610126D-01, 2.826094197735932D-02/
      data wleb(1267),(gjk(i,1267),i=1,2)/
     &  1.836297121596799D-04,
     &  5.130373952796941D-01, 5.699871359683649D-02/
      data wleb(1268),(gjk(i,1268),i=1,2)/
     &  1.858426916241869D-04,
     &  5.456252429628476D-01, 8.602712528554395D-02/
      data wleb(1269),(gjk(i,1269),i=1,2)/
     &  1.875654101134641D-04,
     &  5.768956329682385D-01, 1.151748137221281D-01/
      data wleb(1270),(gjk(i,1270),i=1,2)/
     &  1.888240751833503D-04,
     &  6.068186944699046D-01, 1.442811654136362D-01/
      data wleb(1271),(gjk(i,1271),i=1,2)/
     &  1.896497383866979D-04,
     &  6.353622248024907D-01, 1.731930321657680D-01/
      data wleb(1272),(gjk(i,1272),i=1,2)/
     &  1.900775530219121D-04,
     &  6.624927035731797D-01, 2.017619958756061D-01/
      data wleb(1273),(gjk(i,1273),i=1,2)/
     &  1.858525041478814D-04,
     &  5.484933508028488D-01, 2.874219755907391D-02/
      data wleb(1274),(gjk(i,1274),i=1,2)/
     &  1.876248690077947D-04,
     &  5.810207682142106D-01, 5.778312123713695D-02/
      data wleb(1275),(gjk(i,1275),i=1,2)/
     &  1.889404439064607D-04,
     &  6.120955197181353D-01, 8.695262371439526D-02/
      data wleb(1276),(gjk(i,1276),i=1,2)/
     &  1.898168539265290D-04,
     &  6.416944284294319D-01, 1.160893767057166D-01/
      data wleb(1277),(gjk(i,1277),i=1,2)/
     &  1.902779940661772D-04,
     &  6.697926391731260D-01, 1.450378826743251D-01/
      data wleb(1278),(gjk(i,1278),i=1,2)/
     &  1.890125641731815D-04,
     &  6.147594390585488D-01, 2.904957622341456D-02/
      data wleb(1279),(gjk(i,1279),i=1,2)/
     &  1.899434637795751D-04,
     &  6.455390026356783D-01, 5.823809152617197D-02/
      data wleb(1280),(gjk(i,1280),i=1,2)/
     &  1.904520856831751D-04,
     &  6.747258588365477D-01, 8.740384899884715D-02/
      data wleb(1281),(gjk(i,1281),i=1,2)/
     &  1.905534498734563D-04,
     &  6.772135750395347D-01, 2.919946135808105D-02/
c
c
c     
      data fasf/6*1.0d0/
c
c      data jkv/0, 3, 7, 13, 22, 33, 45, 61, 81, 106, 136, 172/
      data jkv/0, 3, 7,12, 17, 23, 30, 38, 47, 57, 
     1     68, 80, 93, 109, 129,154,184,220,262, 311,
     2     367,431,503,584,674,774,884,1005,1137,1281/          

c     
c      data  njk/1, 0, 1, 0, 1, 0,  1, 1, 1, 1, 0, 0,  1, 0, 1, 3, 1, 0,  
c     &          1, 1, 1, 4, 1, 1,  1, 1, 1, 5, 1, 2,  1, 0, 1, 6, 2, 2,  
c     &          1, 1, 1, 7, 2, 4,  1, 0, 1, 8, 4, 6,  1, 1, 1, 9, 4, 9,
c     &          1, 0, 1,12, 4,12,  1, 1, 1,13, 4, 16/
c
c     symmetry classification of the set of points
c
      data (njk(i, 1),i=1,6)/ 1, 0, 1, 0, 1, 0/!38
      data (njk(i, 2),i=1,6)/ 1, 1, 1, 1, 0, 0/!50
      data (njk(i, 3),i=1,6)/ 1, 1, 1, 1, 1, 0/!74
      data (njk(i, 4),i=1,6)/ 1, 0, 1, 2, 1, 0/!86
      data (njk(i, 5),i=1,6)/ 1, 0, 1, 3, 1, 0/!110
      data (njk(i, 6),i=1,6)/ 1, 1, 1, 3, 0, 1/!146
      data (njk(i, 7),i=1,6)/ 1, 1, 1, 3, 1, 1/!170
      data (njk(i, 8),i=1,6)/ 1, 1, 1, 4, 1, 1/!194
      data (njk(i, 9),i=1,6)/ 1, 0, 1, 5, 2, 1/!230
      data (njk(i,10),i=1,6)/ 1, 1, 1, 5, 1, 2/!266
      data (njk(i,11),i=1,6)/ 1, 0, 1, 6, 2, 2/!302
      data (njk(i,12),i=1,6)/ 1, 0, 1, 6, 2, 3/!350
      data (njk(i,13),i=1,6)/ 1, 1, 1, 7, 2, 4/!434
      data (njk(i,14),i=1,6)/ 1, 0, 1, 9, 3, 6/!590
      data (njk(i,15),i=1,6)/ 1, 1, 1,10, 3, 9/!770
      data (njk(i,16),i=1,6)/ 1, 0, 1,12, 4,12/!974
      data (njk(i,17),i=1,6)/ 1, 1, 1,13, 4,16/!1202
      data (njk(i,18),i=1,6)/ 1, 0, 1,15, 5,20/!1454
      data (njk(i,19),i=1,6)/ 1, 1, 1,16, 5,25/!1730
      data (njk(i,20),i=1,6)/ 1, 0, 1,18, 6,30/!2030
      data (njk(i,21),i=1,6)/ 1, 1, 1,19, 6,36/!2354
      data (njk(i,22),i=1,6)/ 1, 0, 1,21, 7,42/!2702
      data (njk(i,23),i=1,6)/ 1, 1, 1,22, 7,49/!3074
      data (njk(i,24),i=1,6)/ 1, 0, 1,24, 8,56/!3470
      data (njk(i,25),i=1,6)/ 1, 1, 1,25, 8,64/!3890
      data (njk(i,26),i=1,6)/ 1, 0, 1,27, 9,72/!4334
      data (njk(i,27),i=1,6)/ 1, 1, 1,28, 9,81/!4802
      data (njk(i,28),i=1,6)/ 1, 0, 1,30,10,90/!5294
      data (njk(i,29),i=1,6)/ 1, 1, 1,31,10,100/!5810
c
      data  nvj/6, 12, 8, 24, 24, 48/
c
      data (ivj(i,1), i = 1, 6)/1, 2, 17, 19, 25, 28/
c
      data (ivj(i,2), i = 1, 12)/
     &     1, 2, 3, 8, 9, 10, 12, 15, 25, 27, 28, 30/
c
      data (ivj(i,3), i = 1, 8)/1, 2, 3, 4, 5, 6, 7, 8/
c
      data (ivj(i,4), i = 1, 24)/
     &      1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 
     &     13, 14, 15, 16, 25, 26, 27, 28, 29, 30, 31, 32/
c
      data (ivj(i,5), i = 1, 24)/
     &      1,  2,  4,  5,  9, 10, 11, 13, 17, 19, 20, 21,
     &     25, 26, 28, 29, 33, 34, 35, 37, 41, 43, 44, 45/
c
      data (ivj(i,6), i = 1, 48)/
     &      1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 
     &     13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 
     &     25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
     &     37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48/
c
cedo      data nridv/38, 50, 74, 86, 110, 146, 170, 194,  
cedo     .     230, 266, 302, 350, 434, 590, 770, 
cedo     &     974, 1202, 1454,1730,2030,2354,2702,3074,3470,
cedo     .     3890,4334,4802,5294,5810/
c
      if (oprint)write(LuOut,201)
      fourpi=4.0d0*dacos(-1.d0)
      nop = 0
      n48 = 1
      do 57 iv = 1, 6
         do 57 ks = 1, 8
            nop = nop + 1
            do 57  i = 1, 3
               isi = isig(i,ks)
               do 57  j = 1, 3
57    goh(i,j,nop) = isi*itop(i,j,iv)
      fasf(2) = sqrt(2.d0)
      fasf(3) = sqrt(3.d0)
c
      do ia = 1,iangquad
c
         if (ia.le.0) then
            l_ang = 1
            za_leb(1,1,ia) = 1.0d0
            za_leb(2,1,ia) = 0.0d0
            za_leb(3,1,ia) = 0.0d0
            wa_leb(1,ia) = fourpi
         else
            iaz = min(ia,IAC_MAX)
            l_ang = 0
            wtest = 0.d0
            jk = jkv(iaz)
            jk1 = 0
            do 20  j = 1,6
               nvjj = nvj(j)
               fasfj = fasf(j)
               do 20 k = 1,njk(j,iaz)
                  jk = jk + 1
                  jk1 = jk1 + 1
                  if(fasfj.ne.1d0) then
                     x0 = gjk(1,jk)/fasfj
                     y0 = gjk(2,jk)/fasfj
                     gjkt1=x0*x0+y0*y0
                     if(abs(gjkt1-1.d0).gt.1d-8) then
                        z0=sqrt(fasfj*fasfj-gjk(1,jk)*gjk(1,jk)-
     -                       gjk(2,jk)*gjk(2,jk))/fasfj
                     else
                        z0=0.d0
                     endif
                  else
                     x0 = gjk(1,jk)
                     y0 = gjk(2,jk)
                     gjkt1=x0*x0+y0*y0
                     if(abs(gjkt1-1.d0).gt.1d-8) then
                        z0=sqrt(1d0-gjkt1)
                     else
                        z0=0.d0
                     endif
                  endif
C                  if (oprint)write(LuOut,207)
                     if (oprint)write(LuOut,209)wleb(jk),
     &                  x0,y0,z0
                  do l = 1,nvjj
                     iv = ivj(l,j)
                     gjkt1 = goh(1,1,iv)*x0 + goh(1,2,iv)*y0 + 
     &                       goh(1,3,iv)*z0
                     gjkt2 = goh(2,1,iv)*x0 + goh(2,2,iv)*y0 + 
     &                       goh(2,3,iv)*z0
                     gjkt3 = goh(3,1,iv)*x0 + goh(3,2,iv)*y0 + 
     &                       goh(3,3,iv)*z0
                     l_ang = l_ang + 1
                     za_leb(1,l_ang,iaz) = gjkt1
                     za_leb(2,l_ang,iaz) = gjkt2
                     za_leb(3,l_ang,iaz) = gjkt3
                     wa_leb(l_ang,iaz) = wleb(jk)*fourpi
                     wtest = wtest + wa_leb(l_ang,ia)
c                     if (oprint)write(LuOut,209)wa_leb(l_ang,iaz),
c     &                  (za_leb(i,l_ang,iaz),i = 1,3)
C			write(LuOut,*) ' wtest ', wtest/fourpi
                  enddo
   20       continue
            if (oprint)write(LuOut,410)l_ang, wtest/fourpi
         endif
         ntheta(ia) = l_ang
         nphi(ia) = -99
      enddo
      return
 201  format('     irreducible set of Lebedev Angular points ;')
  208 format(t10,3f10.5)
c  207 format('     Irreducible set of points ;')
  209 format(4f19.15)
  410 format('   total no. of   reducible points:',i4,'; test:',f12.8)
      end
      integer function xc_leb_acc2nrd(acc)
      implicit none
#include "errquit.fh"
      integer acc
      integer nridv(29)
      data nridv/38, 50, 74, 86, 110, 146, 170, 194,  
     .     230, 266, 302, 350, 434, 590, 770, 
     &     974, 1202, 1454,1730,2030,2354,2702,3074,3470,
     .     3890,4334,4802,5294,5810/
c     
      if(acc.lt.1.or.acc.gt.29)
     . call errquit('xclebacc2: invalid acc',acc, UNKNOWN_ERR)
      xc_leb_acc2nrd=nridv(acc)

      return
      end
      integer function xc_leb_nrd2acc(nrad)
      implicit none
#include "errquit.fh"
      integer nrad
      integer i
      integer nridv(29)
      data nridv/38, 50, 74, 86, 110, 146, 170, 194,  
     .     230, 266, 302, 350, 434, 590, 770, 
     &     974, 1202, 1454,1730,2030,2354,2702,3074,3470,
     .     3890,4334,4802,5294,5810/
c
c 
      xc_leb_nrd2acc=0
      if (nrad.eq.0) return
      do i=1,29
         if(nrad.eq.nridv(i)) then
            xc_leb_nrd2acc=i
            return
         endif
      enddo
      call errquit('xclebnrd2: invalid nrad',nrad, UNKNOWN_ERR)
      return
      end
