#include "defaultmcpserver.h"
#include "dbwrapper.h"
#include <QLoggingCategory>

Q_DECLARE_LOGGING_CATEGORY(logAgent)
using namespace uos_ai;

DefaultMcpServer::DefaultMcpServer(const QString &agentName, QObject *parent) : MCPServer(agentName, parent)
{

}

void DefaultMcpServer::scanServers()
{
    if (DbWrapper::localDbWrapper().getThirdPartyMcpAgreement()) {
        MCPServer::scanServers();
        qCDebug(logAgent) << "Enable third party mcp server. ";
    } else {
        qInfo(logAgent) << "User disable third party mcp server.";
    }

    // add fixed mcp server name.
    m_servers.insert("uos-mcp", "");
    return;
}
