// Code generated by "./generator ./discard/org.freedesktop.miracle.wifi"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package wifi

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus/v5"
	"github.com/linuxdeepin/go-dbus-factory/object_manager"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type Wifi interface {
	object_manager.ObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.Object
}

type objectWifi struct {
	object_manager.InterfaceObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.ImplObject
}

func NewWifi(conn *dbus.Conn) Wifi {
	obj := new(objectWifi)
	obj.ImplObject.Init_(conn, "org.freedesktop.miracle.wifi", "/org/freedesktop/miracle/wifi")
	return obj
}

type Link interface {
	link // interface org.freedesktop.miracle.wifi.Link
	proxy.Object
}

type objectLink struct {
	interfaceLink // interface org.freedesktop.miracle.wifi.Link
	proxy.ImplObject
}

func NewLink(conn *dbus.Conn, path dbus.ObjectPath) (Link, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectLink)
	obj.ImplObject.Init_(conn, "org.freedesktop.miracle.wifi", path)
	return obj, nil
}

type link interface {
	GoManage(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Manage(flags dbus.Flags) error
	GoUnmanage(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Unmanage(flags dbus.Flags) error
	InterfaceIndex() proxy.PropUint32
	MACAddress() proxy.PropString
	InterfaceName() proxy.PropString
	FriendlyName() proxy.PropString
	Managed() proxy.PropBool
	P2PState() proxy.PropInt32
	P2PScanning() proxy.PropBool
	WfdSubelements() proxy.PropString
}

type interfaceLink struct{}

func (v *interfaceLink) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceLink) GetInterfaceName_() string {
	return "org.freedesktop.miracle.wifi.Link"
}

// method Manage

func (v *interfaceLink) GoManage(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Manage", flags, ch)
}

func (v *interfaceLink) Manage(flags dbus.Flags) error {
	return (<-v.GoManage(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Unmanage

func (v *interfaceLink) GoUnmanage(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Unmanage", flags, ch)
}

func (v *interfaceLink) Unmanage(flags dbus.Flags) error {
	return (<-v.GoUnmanage(flags, make(chan *dbus.Call, 1)).Done).Err
}

// property InterfaceIndex u

func (v *interfaceLink) InterfaceIndex() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "InterfaceIndex",
	}
}

// property MACAddress s

func (v *interfaceLink) MACAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "MACAddress",
	}
}

// property InterfaceName s

func (v *interfaceLink) InterfaceName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "InterfaceName",
	}
}

// property FriendlyName s

func (v *interfaceLink) FriendlyName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FriendlyName",
	}
}

// property Managed b

func (v *interfaceLink) Managed() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Managed",
	}
}

// property P2PState i

func (v *interfaceLink) P2PState() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "P2PState",
	}
}

// property P2PScanning b

func (v *interfaceLink) P2PScanning() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "P2PScanning",
	}
}

// property WfdSubelements s

func (v *interfaceLink) WfdSubelements() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WfdSubelements",
	}
}

type Peer interface {
	peer // interface org.freedesktop.miracle.wifi.Peer
	proxy.Object
}

type objectPeer struct {
	interfacePeer // interface org.freedesktop.miracle.wifi.Peer
	proxy.ImplObject
}

func NewPeer(conn *dbus.Conn, path dbus.ObjectPath) (Peer, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectPeer)
	obj.ImplObject.Init_(conn, "org.freedesktop.miracle.wifi", path)
	return obj, nil
}

type peer interface {
	GoConnect(flags dbus.Flags, ch chan *dbus.Call, arg0 string, arg1 string) *dbus.Call
	Connect(flags dbus.Flags, arg0 string, arg1 string) error
	GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Disconnect(flags dbus.Flags) error
	ConnectProvisionDiscovery(cb func(arg0 string, arg1 string)) (dbusutil.SignalHandlerId, error)
	ConnectGoNegRequest(cb func(arg0 string, arg1 string)) (dbusutil.SignalHandlerId, error)
	ConnectFormationFailure(cb func(arg0 string)) (dbusutil.SignalHandlerId, error)
	Link() proxy.PropObjectPath
	P2PMac() proxy.PropString
	FriendlyName() proxy.PropString
	Connected() proxy.PropBool
	Interface() proxy.PropString
	LocalAddress() proxy.PropString
	RemoteAddress() proxy.PropString
	WfdSubelements() proxy.PropString
}

type interfacePeer struct{}

func (v *interfacePeer) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfacePeer) GetInterfaceName_() string {
	return "org.freedesktop.miracle.wifi.Peer"
}

// method Connect

func (v *interfacePeer) GoConnect(flags dbus.Flags, ch chan *dbus.Call, arg0 string, arg1 string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Connect", flags, ch, arg0, arg1)
}

func (v *interfacePeer) Connect(flags dbus.Flags, arg0 string, arg1 string) error {
	return (<-v.GoConnect(flags, make(chan *dbus.Call, 1), arg0, arg1).Done).Err
}

// method Disconnect

func (v *interfacePeer) GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Disconnect", flags, ch)
}

func (v *interfacePeer) Disconnect(flags dbus.Flags) error {
	return (<-v.GoDisconnect(flags, make(chan *dbus.Call, 1)).Done).Err
}

// signal ProvisionDiscovery

func (v *interfacePeer) ConnectProvisionDiscovery(cb func(arg0 string, arg1 string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ProvisionDiscovery", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ProvisionDiscovery",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var arg0 string
		var arg1 string
		err := dbus.Store(sig.Body, &arg0, &arg1)
		if err == nil {
			cb(arg0, arg1)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal GoNegRequest

func (v *interfacePeer) ConnectGoNegRequest(cb func(arg0 string, arg1 string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "GoNegRequest", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".GoNegRequest",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var arg0 string
		var arg1 string
		err := dbus.Store(sig.Body, &arg0, &arg1)
		if err == nil {
			cb(arg0, arg1)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal FormationFailure

func (v *interfacePeer) ConnectFormationFailure(cb func(arg0 string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "FormationFailure", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".FormationFailure",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var arg0 string
		err := dbus.Store(sig.Body, &arg0)
		if err == nil {
			cb(arg0)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Link o

func (v *interfacePeer) Link() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Link",
	}
}

// property P2PMac s

func (v *interfacePeer) P2PMac() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "P2PMac",
	}
}

// property FriendlyName s

func (v *interfacePeer) FriendlyName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "FriendlyName",
	}
}

// property Connected b

func (v *interfacePeer) Connected() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Connected",
	}
}

// property Interface s

func (v *interfacePeer) Interface() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Interface",
	}
}

// property LocalAddress s

func (v *interfacePeer) LocalAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "LocalAddress",
	}
}

// property RemoteAddress s

func (v *interfacePeer) RemoteAddress() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "RemoteAddress",
	}
}

// property WfdSubelements s

func (v *interfacePeer) WfdSubelements() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WfdSubelements",
	}
}
