% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_handler-httr2.R
\name{RequestHandlerHttr2}
\alias{RequestHandlerHttr2}
\title{RequestHandlerHttr2}
\description{
Methods for the httr2 package, building on \link{RequestHandler}
}
\examples{
\dontrun{
# GET request
library(httr2)
req <- request("https://hb.opencpu.org/post") \%>\%
   req_body_json(list(foo = "bar"))
x <- RequestHandlerHttr2$new(req)
# x$handle()

# POST request
library(httr2)
mydir <- file.path(tempdir(), "testing_httr2")
invisible(vcr_configure(dir = mydir))
req <- request("https://hb.opencpu.org/post") \%>\%
  req_body_json(list(foo = "bar"))
use_cassette(name = "testing3", {
  response <- req_perform(req)
}, match_requests_on = c("method", "uri", "body"))
use_cassette(name = "testing3", {
  response2 <- req_perform(req)
}, match_requests_on = c("method", "uri", "body"))
}
}
\section{Super class}{
\code{\link[vcr:RequestHandler]{vcr::RequestHandler}} -> \code{RequestHandlerHttr2}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RequestHandlerHttr2-new}{\code{RequestHandlerHttr2$new()}}
\item \href{#method-RequestHandlerHttr2-clone}{\code{RequestHandlerHttr2$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="vcr" data-topic="RequestHandler" data-id="handle"><a href='../../vcr/html/RequestHandler.html#method-RequestHandler-handle'><code>vcr::RequestHandler$handle()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestHandlerHttr2-new"></a>}}
\if{latex}{\out{\hypertarget{method-RequestHandlerHttr2-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{RequestHandlerHttr2} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestHandlerHttr2$new(request)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request from an object of class \code{HttpInteraction}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{RequestHandlerHttr2} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RequestHandlerHttr2-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RequestHandlerHttr2-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestHandlerHttr2$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
