% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{c,meta-method}
\alias{c,meta-method}
\alias{c-meta}
\alias{c,ListOfmeta-method}
\alias{c-ListOfmeta}
\title{Concatenate meta elements into a ListOfmeta}
\usage{
\S4method{c}{meta}(x, ..., recursive = TRUE)

\S4method{c}{ListOfmeta}(x, ..., recursive = TRUE)
}
\arguments{
\item{x, ...}{\code{meta} and \code{ListOfmeta} elements to be concatenated, see \code{\link{meta}}}

\item{recursive}{logical, if 'recursive=TRUE', the function recursively
descends through lists and combines their elements into a flat vector.
This method does not support \code{recursive=FALSE}, use \link[base:list]{list}
instead.}
}
\value{
a ListOfmeta object containing a flat list of meta elements.
}
\description{
Concatenate meta elements into a ListOfmeta

Concatenate ListOfmeta elements into a flat ListOfmeta
}
\examples{
c(meta(content="example", property="dc:title"),
  meta(content="Carl", property="dc:creator"))
metalist <- c(meta(content="example", property="dc:title"),
              meta(content="Carl", property="dc:creator"))
out <- c(metalist, metalist) 
out <- c(metalist, meta(content="a", property="b")) 
}
