% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-function.R
\name{write_disk}
\alias{write_disk}
\alias{write_memory}
\title{Control where the response body is written.}
\usage{
write_disk(path, overwrite = FALSE)

write_memory()
}
\arguments{
\item{path}{Path to content to.}

\item{overwrite}{Will only overwrite existing \code{path} if TRUE.}
}
\description{
The default behaviour is to use \code{write_memory()}, which caches
the response locally in memory. This is useful when talking to APIs as
it avoids a round-trip to disk. If you want to save a file that's bigger
than memory, use \code{write_disk()} to save it to a known path.
}
\examples{
tmp <- tempfile()
r1 <- GET("https://www.google.com", write_disk(tmp))
readLines(tmp)

# The default
r2 <- GET("https://www.google.com", write_memory())

# Save a very large file
\dontrun{
GET(
  "http://www2.census.gov/acs2011_5yr/pums/csv_pus.zip",
  write_disk("csv_pus.zip"), progress()
)
}
}
