% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stemness.R
\name{TCGAanalyze_Stemness}
\alias{TCGAanalyze_Stemness}
\title{Generate Stemness Score based on RNASeq (mRNAsi stemness index) Malta et al., Cell, 2018}
\usage{
TCGAanalyze_Stemness(stemSig, dataGE, colname.score = "stemness_score")
}
\arguments{
\item{stemSig}{is a vector of the stemness Signature generated using gelnet package.
Please check the data from https://www.ncbi.nlm.nih.gov/pmc/articles/PMC5902191/
\itemize{
\item \link[TCGAbiolinks]{SC_PCBC_stemSig} - Stemness Score
\item \link[TCGAbiolinks]{DE_PCBC_stemSig} - endoderm score
\item \link[TCGAbiolinks]{EB_PCBC_stemSig} -  embryoid bodies score
\item \link[TCGAbiolinks]{ECTO_PCBC_stemSig} - ectoderm score
\item \link[TCGAbiolinks]{MESO_PCBC_stemSig} - mesoderm score
}}

\item{dataGE}{is a matrix of Gene expression (genes in rows, samples in cols) from TCGAprepare}

\item{colname.score}{Column name of the output. Default "stemness_score"}
}
\value{
table with samples and selected score
}
\description{
TCGAanalyze_Stemness generate the mRNAsi score
}
\examples{
 # Selecting TCGA breast cancer (10 samples) for example stored in dataBRCA
 dataNorm <- TCGAanalyze_Normalization(
     tabDF = dataBRCA,
     geneInfo =  geneInfo
 )

 # quantile filter of genes
 dataFilt <- TCGAanalyze_Filtering(
   tabDF = dataNorm,
   method = "quantile",
   qnt.cut =  0.25
 )
 Stemness_score <- TCGAanalyze_Stemness(
     stemSig = SC_PCBC_stemSig,
     dataGE = dataFilt,
     colname.score = "SC_PCBC_stem_score"
  )
 ECTO_score <- TCGAanalyze_Stemness(
     stemSig = ECTO_PCBC_stemSig,
     dataGE = dataFilt,
     colname.score = "ECTO_PCBC_stem_score"
  )
  MESO_score <- TCGAanalyze_Stemness(
     stemSig = MESO_PCBC_stemSig,
     dataGE = dataFilt,
     colname.score = "MESO_PCBC_stem_score"
  )
}
