% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mofa.R
\name{create_mofa}
\alias{create_mofa}
\title{create a MOFA object}
\usage{
create_mofa(data, groups = NULL, extract_metadata = TRUE, ...)
}
\arguments{
\item{data}{one of the formats above}

\item{groups}{group information, only relevant when using the multi-group framework.}

\item{extract_metadata}{logical indicating whether to incorporate the sample metadata from the input object into the MOFA object (
not relevant when the input is a list of matrices). Default is \code{TRUE}.}

\item{...}{further arguments that can be passed to the function depending on the inout data format.
See the dpcumentation of above functions for details.}
}
\value{
Returns an untrained \code{\link{MOFA}} object
}
\description{
Method to create a \code{\link{MOFA}} object. Depending on the input data format, this method calls one of the following functions:
\itemize{
  \item{\strong{long data.frame}: }{\code{\link{create_mofa_from_df}}}
  \item{\strong{List of matrices}: }{\code{\link{create_mofa_from_matrix}}}
  \item{\strong{MultiAssayExperiment}: }{\code{\link{create_mofa_from_MultiAssayExperiment}}}
  \item{\strong{Seurat}: }{\code{\link{create_mofa_from_Seurat}}}
  \item{\strong{SingleCellExperiment}: }{\code{\link{create_mofa_from_SingleCellExperiment}}}
  }
 Please read the documentation of the corresponding function for more details on your specific data format.
}
\examples{
# Using an existing simulated data with two groups and two views
file <- system.file("extdata", "test_data.RData", package = "MOFA2")

# Load data (in long data.frame format)
load(file) 
MOFAmodel <- create_mofa(dt)
}
