macro(AddExecutableWithStdFS targetName)

if ("${CMAKE_CXX_COMPILER_ID}" STREQUAL "Clang" AND (CMAKE_CXX_COMPILER_VERSION VERSION_EQUAL 7.0 OR CMAKE_CXX_COMPILER_VERSION VERSION_GREATER 7.0))
    if(APPLE)
        include_directories(/usr/local/opt/llvm/include)
        link_directories(/usr/local/opt/llvm/lib)
    endif()
    add_executable(${targetName} ${ARGN})
    set_property(TARGET ${targetName} PROPERTY CXX_STANDARD 17)
    if (CMAKE_CXX_COMPILER_VERSION VERSION_LESS 9.0)
        if(APPLE)
            target_link_libraries(${targetName} -lc++fs)
        else()
            target_compile_options(${targetName} PRIVATE "-stdlib=libc++")
            target_link_libraries(${targetName} -stdlib=libc++ -lc++fs)
        endif()
    else()
        if(NOT APPLE)
            target_compile_options(${targetName} PRIVATE "-stdlib=libc++")
            target_link_libraries(${targetName} -stdlib=libc++)
        endif()
    endif()
    target_compile_definitions(${targetName} PRIVATE USE_STD_FS)
endif()

if (CMAKE_COMPILER_IS_GNUCXX AND (CMAKE_CXX_COMPILER_VERSION VERSION_EQUAL 8.0 OR CMAKE_CXX_COMPILER_VERSION VERSION_GREATER 8.0))
    add_executable(${targetName} ${ARGN})
    set_property(TARGET ${targetName} PROPERTY CXX_STANDARD 17)
    if (CMAKE_CXX_COMPILER_VERSION VERSION_LESS 9.0)
        target_link_libraries(${targetName} -lstdc++fs)
    endif()
    target_compile_definitions(${targetName} PRIVATE USE_STD_FS)
endif()

if(CMAKE_CXX_COMPILER_ID MATCHES MSVC AND (CMAKE_CXX_COMPILER_VERSION VERSION_EQUAL 19.15 OR CMAKE_CXX_COMPILER_VERSION VERSION_GREATER 19.15))
    add_executable(${targetName} ${ARGN})
    set_property(TARGET ${targetName} PROPERTY CXX_STANDARD 17)
    set_property(TARGET ${targetName} PROPERTY CXX_STANDARD_REQUIRED ON)
    target_compile_options(${targetName} PRIVATE "/Zc:__cplusplus")
    target_compile_definitions(${targetName} PRIVATE USE_STD_FS _CRT_SECURE_NO_WARNINGS)
endif()

endmacro()
