/* $Id$ 
 *
 * ImmediateOperand: An operand with a value.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __IMMEDIATE_OPERAND_HPP_INCLUDED
#define __IMMEDIATE_OPERAND_HPP_INCLUDED

#include "frontend/ast/Types.hpp"
#include "intermediate/operands/Operand.hpp"

namespace intermediate {

//! immediate operand.
/** This class represents an immediate operand. This means, that the operand
 *  must be a value (either int or real).
 */
class ImmediateOperand : public Operand {
public:
	//! c'tor for const integer operands
	/** @param val universal_integer value
	 */
	ImmediateOperand(
		universal_integer val
		) :	Operand(OP_TYPE_INTEGER),
			iValue(val) {}

	//! c'tior for const real operands
	/** @param val universal_real value
	 */
	ImmediateOperand(
		universal_real val
		) :	Operand(OP_TYPE_REAL),
			rValue(val) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor &v) {
		v.visit(*this);
	}

	//! integer value
	universal_integer iValue;
	//! real value
	universal_real rValue;

	//! return the ImmediateOperand for zero.
	static ImmediateOperand *
	getZero(void);

	//! return the ImmediateOperand for one.
	static ImmediateOperand *
	getOne(void);

private:
	//! universal integer 0.
	static ImmediateOperand *zero;
	//! universal integer 1.
	static ImmediateOperand *one;
};

}; /* namespace intermediate */

#endif /* __IMMEDIATE_OPERAND_HPP_INCLUDED */
