#ifndef UOS_RECOVERY_EVENT_LOG_MGR_H
#define UOS_RECOVERY_EVENT_LOG_MGR_H
/* 封装数据埋点接口
    SDK库名称为：libdeepin-event-log.so，完整路径：/usr/lib/libdeepin-event-log.so
    集成时需要在control文件Recommends选项中把deepin-event-log包作为安装依赖。
    sudo apt install deepin-event-log-daemon
    sudo apt install deepin-event-log
    sudo apt install uos-reporter

    上报数据临时缓存在/var/lib/deepin/event-log目录下，文件大小超过50K或者距离创建时间超过1小时就执行日志轮转生产.bk后缀的文件，
    .bk 文件会被上报到云端。
*/

#include <string>
#include <QJsonObject>
#include "../Singleton.h"

class EventLogMgr : public URS::Singleton<EventLogMgr> {
public:
    bool isInited();
    void writeEventLog(const QJsonObject &eventData);

protected:
    friend class URS::Singleton<EventLogMgr>;
    EventLogMgr();

private:
    /** 初始化SDK接口
     * packagename: 将packagenanme提供给统信进行认证
     * enable_sig: SDK默认会注册一些会导致crash的信号处理，如果应用本身有注册，为避免冲突，可以设置为false
    */
    bool (*InitializeFunc)(const std::string &packagename, bool enable_sig /*= true*/);

    /** 上报事件日志接口
     * eventdata: 事件日志数据, json格式
    */
    void (*WriteEventLogFunc)(const std::string &eventdata);

    bool init();
    bool m_isInited;
};

#endif
