#include "EventLogMgr.h"
#include <QJsonDocument>
#include <QLibrary>
#include <QDebug>

EventLogMgr::EventLogMgr() : InitializeFunc(nullptr), WriteEventLogFunc(nullptr)
{
    m_isInited = this->init();
}

bool EventLogMgr::init()
{
    QLibrary library("libdeepin-event-log.so");
    InitializeFunc = reinterpret_cast<bool (*)(const std::string &, bool)>(library.resolve("Initialize"));
    WriteEventLogFunc = reinterpret_cast<void (*)(const std::string &)>(library.resolve("WriteEventLog"));

    if (nullptr == InitializeFunc || nullptr == WriteEventLogFunc) {
        qInfo()<<"EventLogMgr::init, failed to init libdeepin-event-log.so";
        return false;
    }

    InitializeFunc("uos-recovery", true);
    m_isInited = true;
    return true;
}

bool EventLogMgr::isInited()
{
    return m_isInited;
}

void EventLogMgr::writeEventLog(const QJsonObject &eventData)
{
    if (nullptr == WriteEventLogFunc) {
        return;
    }

    std::string dataString = QJsonDocument(eventData).toJson(QJsonDocument::Compact).toStdString();
    qInfo()<<"writeEventLog, data = "<<dataString.data();
    WriteEventLogFunc(dataString);
}
