//
// Created by uos on 2022/5/23.
//

#ifndef UOS_RECOVERY_REMOVETASK_H
#define UOS_RECOVERY_REMOVETASK_H

#include "AsyncTask.h"
#include "global.h"

class RemoveTask : public AsyncTask
{
    Q_OBJECT
public:
    explicit RemoveTask();
    ErrorCode remove(const BackupInfo &backupInfo);
    void readStandardOutput() override;
    void readAllStandardError() override;
    void doResult() override;
    bool buildArgumentsForBackup() override;
    bool buildArgumentsForRestore(const QString &fromDir) override;

private:
    ErrorCode removeGhostDir(const BackupInfo &backupInfo);

private:
    BackupInfo m_delBackupInfo;
};


#endif //UOS_RECOVERY_REMOVETASK_H
