//
// Created by uos on 2022/4/1.
//

#ifndef UOS_RECOVERY_SYSTEMRESTOREWIDGET_H
#define UOS_RECOVERY_SYSTEMRESTOREWIDGET_H

#include "utils/global.h"
#include "common/BaseTableView.h"
#include <DWidget>
#include <DGuiApplicationHelper>
#include <DLabel>
#include <DPushButton>
#include <DProgressBar>
#include <DTextEdit>
#include <DSuggestButton>
#include <DTableView>
#include <QStandardItemModel>
#include <DListView>
#include <QMap>
#include <DFrame>
#include <DSpinner>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class SystemRestoreWidget : public DWidget
{
    Q_OBJECT
public:
    explicit SystemRestoreWidget(DWidget *parent = nullptr);
    void initUI();
    void initTableView();
    void setData(BackupInfoList &backupInfo);
    void startSpinner();
    void stopSpinner();
    void setTips(const QString &tips);
    void setTipsStyleSheet(const QString &styleSheet);

Q_SIGNALS:
    void cancel();
    void start(BackupInfo &backupInfo);

private Q_SLOTS:
    void onThemeChange();
    void onBackupFileChanged(const QModelIndex &index);
    void onRadioClicked(bool checked);

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    DLabel *m_title = nullptr;
    DLabel *m_subTitle = nullptr;
    BaseTableView *m_tableView = nullptr;
    DPushButton *m_cancelBtn = nullptr;
    DSuggestButton *m_okBtn = nullptr;
    QStandardItemModel *m_model = nullptr;
    DSpinner *m_spinner = nullptr;
    DLabel *m_tips = nullptr;
    QMap<QString, BackupInfo> m_allBackupInfo;
    QString m_backupFileOptUUID;
    QList<DFrame*> m_backgroundLst;    // 背景列表
};


#endif //UOS_RECOVERY_SYSTEMRESTOREWIDGET_H