//
// Created by uos on 2022/3/16.
//

#ifndef UOS_RECOVERY_RESTOREMODULE_H
#define UOS_RECOVERY_RESTOREMODULE_H

#include "interface/ModuleInterface.h"
#include "RestoreWidget.h"
#include "SystemRestoreWidget.h"
#include "SysRestoreWidgetV20.h"
#include "UserDataRestoreWidget.h"
#include "dimFileRestoreWidget.h"
#include "InitializeRestoreDim.h"
#include "common/ResultWidget.h"
#include "common/ProgressWidget.h"
#include "common/AuthorityUtils.h"
#include <QObject>

class FrameProxyInterface;
class QString;

class RestoreModule : public QObject, public ModuleInterface
{
    Q_OBJECT
public:
    explicit RestoreModule(FrameProxyInterface *frame, ComDeepinDaemonUosrecoveryInterface *interface,
                           QObject *parent = nullptr);
    ~RestoreModule() override;

    void initialize() override;

    QString name() const override;

    QString icons() const override;

    QString text() const override;

    void active() override;
    void setSystemSyncType(int type);
    void setUserDataSyncType(int type);
    void setSelinuxEnable(bool enable);
    void setLVM(bool isLVM);
    void setEncrypted(bool isEncrypted);
    void setDevice(bool isDevice);
    void setSupportV20BackupRestore(bool isSupport);
    void setFileMgrEncrypted(bool encrypt);
    void setMajorVersion(int version);
    void setMinorVersion(int version);

public Q_SLOTS:
    void onSystemRestore();
    void onStartSystemRestore(BackupInfo &backupInfo);
    void onDataRestore();
    void onStartUserDataRestore(BackupInfo &backupInfo);
    void onDimFileRestore(const QString &dimFilePath);
    void onInitializeRestore();
    void onInitializeRestoreV20();
    void doInitializeRestoreV20(bool formatData);
    void onOtherRestore();
    void onBack();
    void onBackHome();
    void onShowResult(bool success, int operateType, const QString &errorMsg = "");
    void onShowProgress(const QString &mainTitle, const QString &subTitle, const QString &warning);
    void updateProgress(const QString &progress);
    void onError(const QString &errMsg);
    void onSpaceChanged(const QString &space);
    void onManualRestoreV20(const QString &path);
    void onCancelRestoreV20();
    void onCancelInitRestoreV20();
    void onSuccess(const QString &msg);
    void doAdminAuthorityTask(bool result, int type);
    void doCommonAuthorityTask(bool result, int type);

private:
    int reboot();
    bool showRebootDialog(const QString &title, const QString &msg, const QString &iconName,
                          const QString &leftBtnText, const QString &rightBtnText);
    void restoreToOStreeFactory(const QString &request);
    void showSysRestoreWidgetV20();
    void checkAdminAuthority(AuthorityType type);
    void checkCommonAuthority(AuthorityType type);

private:
    RestoreWidget *m_restoreWidget = nullptr;
    SystemRestoreWidget *m_systemRestoreWidget = nullptr;
    SysRestoreWidgetV20 *m_sysRestoreWidgetV20 = nullptr;
    UserDataRestoreWidget *m_userDataRestoreWidget = nullptr;
    DefaultDataRestoreWidget *m_defaultDataRestoreWidget = nullptr;
    dimFileRestoreWidget *m_dimFileRestoreWidget = nullptr;
    ProgressWidget *m_progressWidget = nullptr;
    ResultWidget *m_resultWidget = nullptr;
    InitializeRestoreDim *m_initRestoreWidgetV20 = nullptr;
    int m_systemSyncType = -1;
    int m_userDataSyncType = -1;
    QString m_dimRestoreImgFilePath = "";
    QString seUser;
    QString m_curSysOpID = "";
    QString m_curUserOpID = "";
    AuthorityUtils *m_adminAuthUtils = nullptr;
    AuthorityUtils *m_commonAuthUtils = nullptr;
    bool m_isDimFileRestoreDone = false;
    bool m_isSelinuxEnabled = false;
    bool m_isLVMOnly = false;
    bool m_isEncrypted = false;
    bool m_isDevice = false;
    bool m_isSupportV20BackupRestore = false;
    bool m_isFileMgrEncrypted = false;
    int m_osMajorVer = -1;
    int m_osMinorVer = -1;
};


#endif //UOS_RECOVERY_RESTOREMODULE_H
