//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/11/25.
//

#ifndef UOS_RECOVERY_IMMU_SYSTEM_BACKUP_WIDGET_H
#define UOS_RECOVERY_IMMU_SYSTEM_BACKUP_WIDGET_H

#include <DWidget>
#include <DGuiApplicationHelper>
#include <DLabel>
#include <DPushButton>
//#include <DColoredProgressBar>
#include <DLineEdit>
#include <DTextEdit>
#include <DSuggestButton>
#include <DFrame>
#include <QHBoxLayout>
#include <DTipLabel>
#include <dfilechooseredit.h>
#include "ImmuItemFrame.h"

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class SysBackupItemFrame : public ImmuItemFrame
{
    Q_OBJECT
public:
    explicit SysBackupItemFrame(const QString &title, const QString &titleDes, const QString &icon, QWidget *parent = nullptr);
    virtual ~SysBackupItemFrame();
    void initUI() override;
    void initLayout() override;

    void setPartitionPathText(const QString &text);

private:
    DLabel *m_partitionPath = nullptr;
};

class ImmuSystemBackupWidget : public DWidget
{
    Q_OBJECT
public:
    explicit ImmuSystemBackupWidget(DWidget *parent = nullptr);
    void initUI();
    void setDestPartitionText(const QJsonObject &jsonObject);
    void setTips(const QString &tips);
    void setNotes(const QString &txt);
    void setTipsStyleSheet(const QString &styleSheet);

Q_SIGNALS:
    void cancel();
    void start(const QString &remark);
    void notifySetDestPartition(QWidget *parent);
    void notifyBackupManage();

private Q_SLOTS:
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);
    void onNoteTextChanged();
    void updateNoteCharNum(int num);

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    DLabel *m_title = nullptr;
    DLabel *m_titleDes = nullptr;
    DLabel *m_labelDest = nullptr;
    DFileChooserEdit* m_dirChooseWidget = nullptr;
    DLabel *m_curPartitionText = nullptr;
    SysBackupItemFrame *m_sysBackupItem = nullptr;
    DPushButton *m_destBtn = nullptr;
    DLabel *m_storeText = nullptr;
    DPushButton *m_spaceManageBtn = nullptr;
    DTextEdit *m_lineEdit = nullptr;
    DTipLabel *m_lineEditCount = nullptr;
    DLabel *m_ostreeTips = nullptr;
    DLabel *m_tips = nullptr;
    DPushButton *m_cancel = nullptr;
    DPushButton *m_start = nullptr;
    int m_maxNum = 40;
};
#endif //UOS_RECOVERY_IMMU_SYSTEM_BACKUP_WIDGET_H
