//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/11/19.
//

#ifndef UOS_RECOVERY_IMMU_BACKUP_MODULE_H
#define UOS_RECOVERY_IMMU_BACKUP_MODULE_H

#include "interface/ModuleInterface.h"
#include "ImmuBackupWidget.h"
#include "ImmuSystemBackupWidget.h"
#include "ImmuDataBackupWidget.h"
#include "ImmuGhostWidget.h"
#include "common/ProgressWidget.h"
#include "common/ResultWidget.h"
#include "common/AuthorityUtils.h"
#include <QObject>
#include <QTimer>
#include <QJsonObject>
#include <QString>

class FrameProxyInterface;

class ImmuBackupModule : public QObject, public ModuleInterface
{
    Q_OBJECT
public:
    explicit ImmuBackupModule(FrameProxyInterface *frame, ComDeepinDaemonUosrecoveryInterface *interface,
                          QObject *parent = nullptr);
    ~ImmuBackupModule() override;

    void initialize() override;

    QString name() const override;

    QString icons() const override;

    QString text() const override;

    void active() override;

    void updateDestPartition(const QJsonObject &jsonObject);
    void setSystemSyncType(int type);
    void setUserDataSyncType(int type);
    void setSystemBackupSpaceTips(const QString &tips);
    void setSelinuxEnable(bool enable);
    void setLVM(bool isLVM);
    void setEncrypted(bool isEncrypted);
    void setDevice(bool isDevice);
    void setSupportV20BackupRestore(bool isSupport);
    void setFileMgrEncrypted(bool encrypt);
    void setMajorVersion(int version);
    void setMinorVersion(int version);
    void setImmutable(bool isImmutable);

public Q_SLOTS:
    void onShowProgress(OperateType opType, const QString &mainTitle, const QString &subTitle, const QString &warning);
    void updateProgress(const QString &progress);
    void onShowResult(bool success, int operateType, const QString &errorMsg = "", const QString &customResultText = "");
    void onShowResult(bool success, const Response &rsp);
    void onSystemBackup();
    void onStartSystemBackup(const QString &remark);
    void onDataBackup();
    void onStartDataBackup(const QString &remark);
    void onGhostBackup();
    void onStartGhostBackup(const QString &selectDir);
    void onBack();
    void onBackHome();
    void onError(const QString &errMsg);
    void onSpaceChanged(const QString &space);
    void onGhostCheckSpace(const QString &selectDir);
    void onDataBackupCheckSpace(const QString &msg);
    void onReportCheckSpace(const QString &space);
    void onSuccess(const QString &msg);
    void doAdminAuthorityTask(bool result, int type);
    void doCommonAuthorityTask(bool result, int type);

private:
    QStringList getUsrDataSpecialExcludes();
    void systemBackup(int operateType, int errorCode);
    void doDataBackup(const QString &totalSizeBytes);
    void checkAdminAuthority(AuthorityType type);
    void checkCommonAuthority(AuthorityType type);
    void onGhostShowResult(bool success, int operateType, const QString &errorMsg = "");

private:
    ImmuBackupWidget *m_backupWidget = nullptr;
    ProgressWidgetV2 *m_progressWidget = nullptr;
    ImmuSystemBackupWidget *m_systemBackupWidget = nullptr;
    ImmuDataBackupWidget *m_dataBackupWidget = nullptr;
    ImmuGhostWidget *m_ghostWidget = nullptr;
    ResultWidgetV2 *m_resultWidget = nullptr;
    AuthorityUtils *m_adminAuthUtils = nullptr;
    AuthorityUtils *m_commonAuthUtils = nullptr;
    QList<FileItem> m_fileItems;
    QList<FileItem> m_excludeFileItems;
    QStringList m_excludes;
    QString m_destUUID;
    QString m_curSysBackupReq = "";
    QString m_curSysOpID = "";
    QString m_curUserOpID = "";
    QString m_backupPath;
    SystemBackupRequest m_curSystemBackupRequest;
    int m_systemSyncType = -1;
    int m_userDataSyncType = -1;
    bool m_isSelinuxEnabled = false;
    bool m_isLVMOnly = false;
    bool m_isEncrypted = false;
    bool m_isDevice = false;
    bool m_isSupportV20BackupRestore = false;
    bool m_isFileMgrEncrypted = false;
    bool m_isImmutable = false;
    int m_osMajorVer = -1;
    int m_osMinorVer = -1;
    qint64 m_backupSizeBytes = 0;
    QPixmap m_ghostProgressIcon;
};

#endif //UOS_RECOVERY_IMMU_BACKUP_MODULE_H
