/*
* Copyright (C) 2019 ~ 2019 Uniontech Technology Co., Ltd.
*
* Author:     liaojiayun <liaojiayun@uniontech.com>
*
* Maintainer: liaojiayun <liaojiayun@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef BASE_HEADER_VIEW_V20_H
#define BASE_HEADER_VIEW_V20_H

#include <DHeaderView>

DWIDGET_USE_NAMESPACE

class QModelIndex;
class BaseHeaderViewV20 : public DHeaderView
{
    Q_OBJECT

public:
    explicit BaseHeaderViewV20(Qt::Orientation orientation, QWidget *parent = nullptr);

    QSize sizeHint() const override;
    int sectionSizeHint(int logicalIndex) const;

    inline int getSpacing() const { return m_spacing; }
    inline void setSpacing(int spacing) { m_spacing = spacing; }

protected:
    void paintEvent(QPaintEvent *e) override;
    void paintSection(QPainter *painter, const QRect &rect,
                      int logicalIndex) const override;
    bool eventFilter(QObject *obj, QEvent *ev) override;
    bool viewportEvent(QEvent *e) override;

private:
    int m_spacing {1};

    int m_hover {-1};
    int m_pressed {-1};
};

#endif  // BASE_HEADER_VIEW_V20_H
