#ifndef BASE_ITEM_DELEGATE_H
#define BASE_ITEM_DELEGATE_H

#include <QItemDelegate>

class QModelIndex;
class QPainter;
class QStyleOptionViewItem;

const int DEFAULT_ROW_HEIGHT = 36;

class BaseItemDelegate : public QItemDelegate
{
Q_OBJECT

public:
    explicit BaseItemDelegate(QObject *parent = nullptr);

    void paint(QPainter *painter, const QStyleOptionViewItem &option,
               const QModelIndex &index) const override;
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const override;
    bool helpEvent(QHelpEvent *e, QAbstractItemView *view, const QStyleOptionViewItem &option,
                   const QModelIndex &index) override;

protected:
    void initStyleOption(QStyleOptionViewItem *option, const QModelIndex &index) const;

};

#endif  // BASE_ITEM_DELEGATE_H
