#ifndef BASE_HEADER_VIEW_H
#define BASE_HEADER_VIEW_H

#include <DHeaderView>

DWIDGET_USE_NAMESPACE

class QModelIndex;
class BaseHeaderView : public DHeaderView
{
    Q_OBJECT

public:
    explicit BaseHeaderView(Qt::Orientation orientation, QWidget *parent = nullptr);

    QSize sizeHint() const override;
    int sectionSizeHint(int logicalIndex) const;

    inline int getSpacing() const { return m_spacing; }
    inline void setSpacing(int spacing) { m_spacing = spacing; }

    void setCheckAllState(Qt::CheckState checkState);

Q_SIGNALS:
    void checkAllChanged(Qt::CheckState checkState);

protected:
    void paintEvent(QPaintEvent *e) override;
    void paintSection(QPainter *painter, const QRect &rect,
                      int logicalIndex) const override;
    bool eventFilter(QObject *obj, QEvent *ev) override;
    bool viewportEvent(QEvent *e) override;
    void mousePressEvent(QMouseEvent *e) override;

protected:
    int m_spacing {1};

    int m_hover {-1};
    int m_pressed {-1};
    Qt::CheckState m_checkAll = Qt::Checked;
};

#endif  // BASE_HEADER_VIEW_H
