//
// Created by uos on 2022/4/19.
//

#ifndef UOS_RECOVERY_USERDATABACKUPWIDGET_H
#define UOS_RECOVERY_USERDATABACKUPWIDGET_H

#include "common/SelectFileTreeView.h"
#include "utils/global.h"
#include <DWidget>
#include <DGuiApplicationHelper>
//#include <DFileChooserEdit>
#include <DLineEdit>
#include <DTreeWidget>
#include <DSuggestButton>
#include <QStandardItemModel>
#include <DComboBox>


DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class UserDataBackupWidget : public DWidget
{
    Q_OBJECT

public:
    explicit UserDataBackupWidget(DWidget *parent = nullptr);
    void initUI();
    void setComboBoxText(const QString &text);
    void setRemark(const QString &remark);
    QString getDestDeviceUUID();
    void setFiles(const QList<FileItem> &fileItemList);

Q_SIGNALS:
    void cancel();
    void start(const QString &remark);

private Q_SLOTS:
    void onThemeChange();
    void onNoteTextChanged();

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    DLineEdit *m_remark = nullptr;
    SelectFileTreeView *m_treeView = nullptr;
    QStandardItemModel *m_model = nullptr;
    DPushButton *m_cancelBtn = nullptr;
    DSuggestButton *m_startBtn = nullptr;
    DComboBox *m_comboBox;
    QList<Partition> m_partitionList;
};


#endif //UOS_RECOVERY_USERDATABACKUPWIDGET_H
