#include "RecoveryService.h"
#include "RecoveryAdaptor.h"
#include <QCoreApplication>
#include <QDebug>
#include <QDBusConnection>
#include <QDBusError>
#include <QProcess>
#include <DLog>

DCORE_USE_NAMESPACE

const QString RecoveryServiceName = "com.deepin.uosrecovery";
const QString RecoveryServicePath = "/com/deepin/uosrecovery";


int main(int argc, char **argv)
{
    QCoreApplication app(argc, argv);
    auto systemBus = QDBusConnection::systemBus();
    if (!systemBus.registerService(RecoveryServiceName)) {
        qCritical() << "registerService failed:" << systemBus.lastError();
        exit(0x0001);
    }

    //设置日志
    const QString logFormat = "%{time}{yyyy-MM-dd, HH:mm:ss.zzz}[%{type:1}][%{function:-35} %{line:-4} %{threadid} ] %{message}\n";
    const QString logDir("/var/log/deepin/uos-recovery/");
    QDir dir(logDir);
    if (!dir.exists()) {
        dir.mkpath(logDir);
    }

    DLogManager::setlogFilePath(logDir + "uos-recovery-service.log");
    DLogManager::registerFileAppender();
    DLogManager::registerConsoleAppender();

    QDBusConnection connection = QDBusConnection::systemBus();
    RecoveryService interface;

    UosrecoveryAdaptor adaptor(&interface);

    if (!connection.registerService(RecoveryServiceName))
    {
        qDebug() << connection.lastError().message();
        exit(1);
    }

    connection.registerObject(RecoveryServicePath, &interface, QDBusConnection::ExportAllContents);

    return app.exec();
}