//
// Created by uos on 2022/4/28.
//

#ifndef UOS_RECOVERY_USERDATARESTOREWIDGET_H
#define UOS_RECOVERY_USERDATARESTOREWIDGET_H

#include "utils/global.h"
#include "common/BaseTableView.h"
#include <DWidget>
#include <QTableView>
#include <DGuiApplicationHelper>
#include <DLabel>
#include <DPushButton>
#include <DSuggestButton>
#include <QStandardItemModel>
#include <QMap>
#include <DFrame>

class QVBoxLayout;

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class DefaultDataRestoreWidget : public DWidget {
    Q_OBJECT
public:
    explicit DefaultDataRestoreWidget(DWidget *parent = nullptr);
    void initUI();
    void initLayout();

Q_SIGNALS:
    void cancel();

private:
    DLabel *m_icon = nullptr;
    DLabel *m_text = nullptr;
    DPushButton *m_button = nullptr;
    QVBoxLayout *m_vMainLayout = nullptr;
};

class UserDataRestoreWidget : public DWidget
{
    Q_OBJECT
public:
    explicit UserDataRestoreWidget(DWidget *parent = nullptr);
    void initUI();
    void initTableView();
    void setData(BackupInfoList &backupInfo);
    void setTips(const QString &tips, bool normalStyle = true);
    void setTipsStyleSheet(const QString &styleSheet);
Q_SIGNALS:
    void cancel();
    void start(BackupInfo &backupInfo);

private Q_SLOTS:
    void onThemeChange();
    void onBackupFileChanged(const QModelIndex &index);
    void onRadioClicked(bool checked);

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    DLabel *m_title = nullptr;
    DLabel *m_subTitle = nullptr;
    BaseTableView *m_tableView = nullptr;
    DPushButton *m_cancelBtn = nullptr;
    DSuggestButton *m_okBtn = nullptr;
    QStandardItemModel *m_model = nullptr;
    QMap<QString, BackupInfo> m_allBackupInfo;
    QString m_backupFileOptUUID;
    DLabel *m_tips = nullptr;
};


#endif //UOS_RECOVERY_USERDATARESTOREWIDGET_H
