//
// Created by uos on 2022/4/26.
//

#ifndef UOS_RECOVERY_SELECTFILEITEMDELEGATE_H
#define UOS_RECOVERY_SELECTFILEITEMDELEGATE_H
#include <QItemDelegate>

class QModelIndex;
class QPainter;
class QStyleOptionViewItem;

class SelectFileItemDelegate : public QItemDelegate
{
Q_OBJECT

public:
    explicit SelectFileItemDelegate(QObject *parent = nullptr);

    void paint(QPainter *painter, const QStyleOptionViewItem &option,
               const QModelIndex &index) const override;

//    void drawCheck(QPainter *painter, const QStyleOptionViewItem &option,
//                   const QRect &rect, Qt::CheckState state) const override;

    QWidget *createEditor(QWidget *, const QStyleOptionViewItem &,
                          const QModelIndex &) const override;
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const override;
    bool helpEvent(QHelpEvent *e, QAbstractItemView *view, const QStyleOptionViewItem &option,
                   const QModelIndex &index) override;
    void setAlwaysChecked(bool checked);

protected:
    void initStyleOption(QStyleOptionViewItem *option, const QModelIndex &index) const;
    bool m_alwaysChecked = false; // 为true表示点击的时候不要改变checked的状态，已选择备份文件列表中会使用到
};


#endif //UOS_RECOVERY_SELECTFILEITEMDELEGATE_H
