#include "EventLogMgrTest.h"
#include "data-collection/EventData.h"
#include "data-collection/EventLogMgr.h"
#include <QJsonObject>

//deb  [trusted=yes] https://aptly.uniontech.com/pkg/eagle-1053/release-candidate/5pWw5o2u5YiG5p6Q5bmz5Y-w5LiJ5pyfMjAyMi0wOC0xMCAwOTozODozOA/  unstable main

TEST_F(EventLogMgrTest, dataBackup)
{
    BackupEventData eventData;
    eventData.tid = 100001;
    eventData.version = "6.0.11";
    eventData.resInfo = ResultInfo(0, "success", "no error");
    eventData.operateType = "Data Backup";
    eventData.backupType = "rsync";

    QJsonObject dataObj = eventData.marshal();

    EventLogMgr *eventLogMgr = EventLogMgr::getInstance();
    bool retCode = eventLogMgr->isInited();
    eventLogMgr->writeEventLog(dataObj);
    EXPECT_TRUE(retCode);
}

TEST_F(EventLogMgrTest, cpuInfo)
{
    BackupEventData eventData;
    eventData.tid = 100002;
    eventData.resInfo = ResultInfo(0, "success", "no error");
    eventData.operateType = "System Backup";
    eventData.backupType = "ostree";


    QJsonObject dataObj = eventData.marshal();

    EventLogMgr *eventLogMgr = EventLogMgr::getInstance();
    bool retCode = eventLogMgr->isInited();
    if (retCode) {
        eventLogMgr->writeEventLog(dataObj);
    }

    retCode = EventLogMgr::getInstance()->isInited();
    if (retCode) {
        eventLogMgr->writeEventLog(dataObj);
    }
    
    EXPECT_TRUE(retCode);
}
