#include "describeinputbox.h"
#include <QHBoxLayout>
#include <QIntValidator>
DescribeInputBox::DescribeInputBox()
    : QWidget()

{
    QHBoxLayout * describox =new  QHBoxLayout();
    this->setLayout(describox);
    deslineEdit = new DLineEdit();
    describox->addWidget(deslineEdit);
    deslineEdit->show();
}

DescribeInputBox::DescribeInputBox(QString predescInfo,QString afterInfo1 ,QString afterInfo2)
{
    QHBoxLayout * describox =new  QHBoxLayout();
    this->setLayout(describox);

    deslineEdit = new DLineEdit();
    predescLabel = new DLabel();
    predescLabel->setText(predescInfo);
    afterLabel1 = new DLabel();
    afterLabel1->setText(afterInfo1);
    afterLabel2 = new DLabel();
    afterLabel2->setText(afterInfo2);

    describox->addWidget(predescLabel);
    describox->addWidget(deslineEdit);
    describox->addWidget(afterLabel1);
    describox->addWidget(afterLabel2);
    describox->setContentsMargins(0,0,0,0);
    deslineEdit->show();
    connect(deslineEdit,&DLineEdit::textChanged,this,&DescribeInputBox::get_textChanged);

}

DescribeInputBox::DescribeInputBox(QString predescInfo,QString afterInfo1 ,QString afterInfo2,QString lineEditValue)
{
    QHBoxLayout * describox =new  QHBoxLayout();
    this->setLayout(describox);

    deslineEdit = new DLineEdit();
    deslineEdit->setText(lineEditValue);
    predescLabel = new DLabel();
    predescLabel->setText(predescInfo);
    afterLabel1 = new DLabel();
    afterLabel1->setText(afterInfo1);
    afterLabel2 = new DLabel();
    afterLabel2->setText(afterInfo2);

    describox->addWidget(predescLabel);
    describox->addWidget(deslineEdit);
    describox->addWidget(afterLabel1);
    describox->addWidget(afterLabel2);
    describox->setContentsMargins(0,0,0,0);
    deslineEdit->show();
    connect(deslineEdit,&DLineEdit::textChanged,this,&DescribeInputBox::get_textChanged);

}

void DescribeInputBox::setLineEditValue(QString value)
{
    deslineEdit->setText(value);
}


void DescribeInputBox::setValid(int minValid ,int maxValid)
{
    QIntValidator *validator = new QIntValidator(minValid, maxValid, this);
    deslineEdit->lineEdit()->setValidator(validator);
}
