#include "tb_url_info.h"
#include <QSqlDatabase>
#include <QDebug>
#include <QtSql/qsqlquery.h>
#include <QSqlError>

extern QSqlDatabase database ;
Tb_Url_Info::Tb_Url_Info()
{

}

Tb_Url_Info::Tb_Url_Info(QString task_id ,QString url ,QString download_type,QString seedFile,QString selectedNum,QString infoHash)
{
    this->task_id = task_id ;
    this->url = url;
    this->download_type = download_type;
    this->seedFile = seedFile;
    this->selectedNum = selectedNum;
    this->infoHash = infoHash;

}
//添加一条url信息
bool  Tb_Url_Info::addUrlInfo(Tb_Url_Info * urlInfo)
{
    if(database.open())
    {
        QSqlQuery sql_query;

        sql_query.prepare("insert into url_info values (?,?,?,?,?,?);");

        sql_query.addBindValue(urlInfo->task_id);
        sql_query.addBindValue(urlInfo->url);
        sql_query.addBindValue(urlInfo->download_type);
        sql_query.addBindValue(urlInfo->seedFile);
        sql_query.addBindValue(urlInfo->selectedNum);
        sql_query.addBindValue(urlInfo->infoHash);


        if(!sql_query.exec())
        {
            qWarning()<<"insert url_info failed : " << sql_query.lastError();
            database.close();
            return false;
        }
        database.close();
        sql_query.clear();
        return true;
    }

    return false;
}

bool Tb_Url_Info::updateUrlInfoByTaskId(Tb_Url_Info * urlInfo)
{
    if(database.open())
    {
        QSqlQuery sql_query;

        sql_query.prepare("update  url_info set url=?,download_type=?,seedFile=?,selectedNum=? ,infoHash=? where task_id= ?");

        sql_query.addBindValue(urlInfo->url);
        sql_query.addBindValue(urlInfo->download_type);
        sql_query.addBindValue(urlInfo->seedFile);
        sql_query.addBindValue(urlInfo->selectedNum);
        sql_query.addBindValue(urlInfo->infoHash);
        sql_query.addBindValue(urlInfo->task_id);

        if(!sql_query.exec())
        {
            qWarning()<<"update url_info failed : " << sql_query.lastError();
            database.close();
            return false;
        }
        database.close();
        sql_query.clear();
        return true;
    }

    return false;

}

Tb_Url_Info * Tb_Url_Info::getTbUrlInfoByTaskId(QString task_id)
{
    Tb_Url_Info * tb_urlInfo =NULL;
    if(database.open())
    {
        QString select_all_sql = "select * from url_info where task_id='"+task_id+"';";
        QSqlQuery sql_query;
        sql_query.prepare(select_all_sql);
        if(!sql_query.exec())
        {
            qWarning()<<"select url_info failed : " << sql_query.lastError();

            return NULL;
        }
        else
        {
            while(sql_query.next())
            {
                QString task_id = sql_query.value(0).toString(); //任务id
                QString url = sql_query.value(1).toString(); // url 下载地址
                QString download_type = sql_query.value(2).toString();//下载类型
                QString seedFile = sql_query.value(3).toString(); //种子文件
                QString selectedNum = sql_query.value(4).toString(); //选择的种子文件号码
                QString infoHash = sql_query.value(5).toString(); //种子文件hash值
                tb_urlInfo = new Tb_Url_Info( task_id, url,download_type,seedFile,selectedNum,infoHash);
            }
            database.close();
            sql_query.clear();

            return tb_urlInfo;

        }
    }
    return NULL;
}

 QList<Tb_Url_Info *> Tb_Url_Info::getAllTbUrlInfo()
 {
     QList<Tb_Url_Info *> list;
     if(!database.open())
     {
             qWarning()<<"open database failed : " << database.lastError();
             qFatal("open database failed .") ;
             return list;
     }
     else
     {
         QString select_all_sql = "select * from url_info;";
         QSqlQuery sql_query;
         sql_query.prepare(select_all_sql);
         if(!sql_query.exec())
         {
             qDebug() << sql_query.lastError();

             return list;
         }
         else
         {
             while(sql_query.next())
             {
                 QString task_id = sql_query.value(0).toString(); //任务id
                 QString url = sql_query.value(1).toString(); // url 下载地址
                 QString download_type = sql_query.value(2).toString();//下载类型
                 QString seedFile = sql_query.value(3).toString(); //种子文件
                 QString selectedNum = sql_query.value(4).toString(); //选择的种子文件号码
                 QString infoHash = sql_query.value(5).toString(); //种子文件hash值
                 Tb_Url_Info * tb_urlInfo = new Tb_Url_Info( task_id, url,download_type,seedFile,selectedNum,infoHash);

                 list.append(tb_urlInfo);
             }
         }

         database.close();
         sql_query.clear();

         return list;
     }
 }

 bool Tb_Url_Info::deleteTbUrl(QString task_id)
 {
     bool status = true;
     if(database.open())
     {
         QSqlQuery sql_query;

         sql_query.prepare("delete from  url_info where task_id=?;");

         sql_query.addBindValue(task_id);

         if(!sql_query.exec())
         {
             QSqlError error = sql_query.lastError();


             status = false;

         }

         database.close();
         sql_query.clear();

     }

     return status;
 }
 bool Tb_Url_Info::deleteAllTbUrl()
 {
     if(database.open())
     {
         QSqlQuery sql_query;

         sql_query.prepare("delete from  url_info ;");


         if(!sql_query.exec())
         {

             database.close();
             return false;
         }
         database.close();
         sql_query.clear();
         return true;
     }

     return false;
 }
